/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.AWTImageLoader;
import irc.CTCPInterpretor;
import irc.ConfigurationLoader;
import irc.DefaultInterpretor;
import irc.DefaultSource;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.IRCObject;
import irc.IRCServer;
import irc.Interpretor;
import irc.LocalFileHandler;
import irc.NullSoundHandler;
import irc.NullURLHandler;
import irc.PluginManager;
import irc.Server;
import irc.ServerListener;
import irc.ServerManager;
import irc.Source;
import irc.StartupConfiguration;
import irc.StreamParameterProvider;
import irc.gui.GUISource;
import irc.gui.IRCInterface;
import irc.gui.IRCInterfaceListener;
import irc.ident.IdentListener;
import irc.ident.IdentWrapper;
import irc.plugin.Plugin;
import java.awt.Button;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IRCApplication
extends IRCObject
implements ServerListener,
ServerManager,
IdentListener,
IRCInterfaceListener,
WindowListener,
ActionListener,
PluginManager {
    private DefaultSource _defaultSource;
    private Interpretor _inter;
    private IdentWrapper _ident;
    private StartupConfiguration _start;
    private IRCInterface _interface;
    private Vector _plugins;
    private Hashtable _pluginsTable;
    private Frame _frame;
    private Container _container;
    private Hashtable<Server, Server> _servers;
    private Object _nickLock = new Object();

    public IRCApplication(IRCConfiguration config, StartupConfiguration startupConfig, Container source) {
        super(config);
        this._container = source;
        this._start = startupConfig;
        this._plugins = new Vector();
        this._pluginsTable = new Hashtable();
        String gui = config.getS("gui");
        try {
            Class<?> cl = Class.forName("irc.gui." + gui + ".Interface");
            Constructor<?> ctr = cl.getDeclaredConstructor(config.getClass());
            this._interface = (IRCInterface)ctr.newInstance(config);
        }
        catch (InvocationTargetException iex) {
            iex.getTargetException().printStackTrace();
            throw new Error("Unable to load interface " + gui + " : " + iex.getTargetException());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new Error("Unable to load interface " + gui + " : " + ex);
        }
        this._servers = new Hashtable();
        this._defaultSource = new DefaultSource(this._ircConfiguration);
        DefaultInterpretor defaultInter = new DefaultInterpretor(this._ircConfiguration, this._start, this, this);
        this._defaultSource.setInterpretor(defaultInter);
    }

    public synchronized void init() {
        this.loadPlugin(this._interface);
        String[] plugins = this._start.getPlugins();
        for (int i = 0; i < plugins.length; ++i) {
            this.loadPlugin(plugins[i]);
        }
        this._interface.addIRCInterfaceListener(this);
        if (this._container == null) {
            this._frame = new Frame();
            this._frame.addWindowListener(this);
            if (this._interface.getComponent() != null) {
                this._frame.add(this._interface.getComponent());
            }
            this._frame.setFont(new Font("", 0, 12));
            this._frame.setSize(640, 400);
            this._frame.setVisible(true);
        } else {
            this._frame = null;
            this._container.removeAll();
            this._container.setLayout(new GridLayout(1, 1));
            if (this._interface.getComponent() != null) {
                this._container.add(this._interface.getComponent());
            }
        }
        this._inter = new CTCPInterpretor(this._ircConfiguration, this._defaultSource.getInterpretor(), this);
        this._inter.addLast(this._interface.getInterpretor());
        if (this._ircConfiguration.getB("useidentserver")) {
            try {
                this._ident = new IdentWrapper(this._ircConfiguration);
                Exception e = this._ident.start(this._start.getName(), this);
                if (e != null) {
                    this._defaultSource.report("\u00036*** " + this.getText(513, e.getMessage()));
                }
            }
            catch (Throwable ex) {
                this._ircConfiguration.internalError("ident error", ex, "bugs@frostwire.com");
            }
        } else {
            this._ident = null;
        }
        String[] init = this._ircConfiguration.getInitialization();
        for (int i = 0; i < init.length; ++i) {
            this._defaultSource.sendString(init[i]);
        }
        IRCServer server = new IRCServer(this._ircConfiguration, this, this._start.getNick(), this._start.getAltNick(), this._start.getName(), this._start.getAlias());
        server.setServers(this._start.getHost(), this._start.getPort(), this._start.getPass());
        this.newServer(server, this._ircConfiguration.getB("autoconnection"));
        if (!this._start.getSmileysSupport()) {
            this._ircConfiguration.resetSmileyTable();
            System.out.println("Smileys should be DISABLED!");
        } else {
            this._ircConfiguration.restoreSmileyTable();
            System.out.println("Smileys should be ACTIVE!");
        }
        this.requestSourceFocus();
    }

    public IRCInterface getIRCInterface() {
        return this._interface;
    }

    public void newServer(Server server, boolean connect) {
        server.addServerListener(this);
        this._servers.put(server, server);
        Enumeration enum1 = this._plugins.elements();
        while (enum1.hasMoreElements()) {
            Plugin plugin = (Plugin)enum1.nextElement();
            plugin.serverCreated(server);
        }
        server.enumerateSourcesAsCreated(this);
        if (connect) {
            server.connect();
        }
    }

    public synchronized void uninit() {
        Enumeration<Server> en = this._servers.keys();
        while (en.hasMoreElements()) {
            Server s = en.nextElement();
            s.leave();
        }
        if (this._ident != null) {
            this._ident.stop();
        }
        this._interface.removeIRCInterfaceListener(this);
        if (this._frame != null) {
            this._frame.removeWindowListener(this);
        }
        this._frame = null;
        while (this._plugins.size() > 0) {
            this.unloadPlugin((Plugin)this._plugins.elementAt(this._plugins.size() - 1));
        }
        this._pluginsTable = new Hashtable();
        if (this._container != null) {
            this._container.removeAll();
        }
        EventDispatcher.clearCache();
    }

    public boolean loadPlugin(String str) {
        Plugin plugin;
        if (this._pluginsTable.get(str) != null) {
            return false;
        }
        try {
            Class<?> cl = Class.forName("irc.plugin." + str);
            Constructor<?> ctr = cl.getDeclaredConstructor(this._ircConfiguration.getClass());
            plugin = (Plugin)ctr.newInstance(this._ircConfiguration);
            this.loadPlugin(plugin);
        }
        catch (Throwable ex) {
            System.out.println("IRCApplication.loadPlugin() here is where the exception got thrown");
            return false;
        }
        this._pluginsTable.put(str, plugin);
        return true;
    }

    public boolean unloadPlugin(String str) {
        Plugin plugin = (Plugin)this._pluginsTable.get(str);
        if (plugin == null) {
            return false;
        }
        this._pluginsTable.remove(str);
        this.unloadPlugin(plugin);
        return true;
    }

    private void loadPlugin(Plugin plugin) {
        plugin.setIRCApplication(this);
        plugin.load();
        this._plugins.insertElementAt(plugin, this._plugins.size());
        plugin.sourceCreated(this._defaultSource, Boolean.TRUE);
        Enumeration<Server> en = this._servers.keys();
        while (en.hasMoreElements()) {
            Server s = en.nextElement();
            plugin.serverCreated(s);
            class AddHandler
            implements ServerListener {
                private Plugin _plugin;

                public AddHandler(Plugin plug) {
                    this._plugin = plug;
                }

                public void serverConnected(Server s) {
                }

                public void serverDisconnected(Server s) {
                }

                public void serverLeft(Server s) {
                }

                public String[] cannotUseRequestedNicknames(Server s) {
                    return null;
                }

                public void sourceCreated(Source source, Server server, Boolean bring) {
                    this._plugin.sourceCreated(source, bring);
                }

                public void sourceRemoved(Source source, Server server) {
                }

                public Object specialServerRequest(String request, Server server, Object[] params) {
                    return null;
                }
            }
            s.enumerateSourcesAsCreated(new AddHandler(plugin));
        }
    }

    private void unloadPlugin(Plugin plugin) {
        for (int i = 0; i < this._plugins.size(); ++i) {
            if (this._plugins.elementAt(i) != plugin) continue;
            this._plugins.removeElementAt(i);
            Enumeration<Server> en = this._servers.keys();
            while (en.hasMoreElements()) {
                Server s = en.nextElement();
                class RemoveHandler
                implements ServerListener {
                    private Plugin _plugin;

                    public RemoveHandler(Plugin plug) {
                        this._plugin = plug;
                    }

                    public void serverConnected(Server s) {
                    }

                    public void serverDisconnected(Server s) {
                    }

                    public void serverLeft(Server s) {
                    }

                    public String[] cannotUseRequestedNicknames(Server s) {
                        return null;
                    }

                    public void sourceCreated(Source source, Server server, Boolean bring) {
                    }

                    public void sourceRemoved(Source source, Server server) {
                        this._plugin.sourceRemoved(source);
                    }

                    public Object specialServerRequest(String request, Server server, Object[] params) {
                        return null;
                    }
                }
                s.enumerateSourcesAsRemoved(new RemoveHandler(plugin));
                plugin.serverRemoved(s);
            }
            plugin.sourceRemoved(this._defaultSource);
            plugin.unload();
            return;
        }
    }

    public void sourceCreated(Source source, Server server, Boolean bring) {
        source.getInterpretor().addLast(this._inter);
        Enumeration enum1 = this._plugins.elements();
        while (enum1.hasMoreElements()) {
            Plugin plugin = (Plugin)enum1.nextElement();
            plugin.sourceCreated(source, bring);
        }
    }

    public void sourceRemoved(Source source, Server server) {
        Enumeration enum1 = this._plugins.elements();
        while (enum1.hasMoreElements()) {
            Plugin plugin = (Plugin)enum1.nextElement();
            plugin.sourceRemoved(source);
        }
    }

    public void serverLeft(Server s) {
        Enumeration enum1 = this._plugins.elements();
        while (enum1.hasMoreElements()) {
            Plugin plugin = (Plugin)enum1.nextElement();
            plugin.serverRemoved(s);
        }
        this._servers.remove(s);
        s.removeServerListener(this);
    }

    private Frame getParentFrame() {
        if (this._frame != null) {
            return this._frame;
        }
        for (Container ans = this._container; ans != null; ans = ans.getParent()) {
            if (!(ans instanceof Frame)) continue;
            return (Frame)ans;
        }
        return null;
    }

    public Container getContainer() {
        if (this._frame != null) {
            return this._frame;
        }
        return this._container;
    }

    public Object specialServerRequest(String request, Server s, Object[] params) {
        if (request.equals("DCCFileRequest")) {
            File f = this._ircConfiguration.getSecurityProvider().getSaveFile(params[1].toString(), this.getText(769) + " [" + params[1] + "]");
            return f;
        }
        if (request.equals("DCCChatRequest")) {
            boolean accept = this._ircConfiguration.getSecurityProvider().confirm(this.getParentFrame(), this.getText(1820), this.getText(1821, (String)params[0]));
            return new Boolean(accept);
        }
        this._ircConfiguration.internalError("Unknown request : " + request, null, "bugs@frostwire.com");
        return null;
    }

    public void serverConnected(Server server) {
        for (int i = 0; i < this._start.getCommands().length; ++i) {
            String cmd = this._start.getCommands()[i];
            if (cmd.startsWith("/") && server instanceof IRCServer) {
                ((IRCServer)server).getStatus().sendString(this._start.getCommands()[i]);
                continue;
            }
            server.execute(this._start.getCommands()[i]);
        }
        Enumeration enum1 = this._plugins.elements();
        while (enum1.hasMoreElements()) {
            Plugin plugin = (Plugin)enum1.nextElement();
            plugin.serverConnected(server);
        }
    }

    public void serverDisconnected(Server s) {
        Enumeration enum1 = this._plugins.elements();
        while (enum1.hasMoreElements()) {
            Plugin plugin = (Plugin)enum1.nextElement();
            plugin.serverDisconnected(s);
        }
    }

    public void identRequested(String source, Integer result, String reply) {
        this._defaultSource.report("\u00036*** " + this.getText(514, source));
        String s = "";
        switch (result) {
            case -1: {
                s = this.getText(515);
                break;
            }
            case 0: {
                s = this.getText(516, reply);
                break;
            }
            case 1: {
                s = this.getText(516, this.getText(517) + " : " + reply);
                break;
            }
            case 2: {
                s = this.getText(518);
                break;
            }
            default: {
                s = this.getText(523);
            }
        }
        this._defaultSource.report("\u00036*** " + s);
    }

    public void identRunning(Integer port) {
        this._defaultSource.report("\u00036*** " + this.getText(519, port + ""));
    }

    public void identLeaving(String message) {
        this._defaultSource.report("\u00036*** " + this.getText(520, message));
    }

    public void activeChanged(GUISource source, IRCInterface inter) {
        if (source != null) {
            if (source.getSource().mayDefault()) {
                source.getSource().getServer().setDefaultSource(source.getSource());
            }
            if (this._frame != null) {
                this._frame.setTitle(source.getTitle());
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (e.getSource() == this._frame) {
            EventDispatcher.dispatchEventAsync(this, "uninit", new Object[0]);
        }
    }

    public void windowClosing(WindowEvent e) {
        ((Frame)e.getSource()).setVisible(false);
        ((Frame)e.getSource()).dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    private GUISource getActiveSource() {
        return this._interface.getActive();
    }

    private Source getSource(String serverName, String type, String name) {
        Enumeration<Server> e = this._servers.keys();
        while (e.hasMoreElements()) {
            Server s = e.nextElement();
            String sname = s.getServerName();
            if (!sname.equals(serverName) && serverName.length() != 0) continue;
            Enumeration f = s.getSources();
            while (f.hasMoreElements()) {
                Source src = (Source)f.nextElement();
                if (!src.getType().equals(type) || !src.getName().equals(name)) continue;
                return src;
            }
        }
        return null;
    }

    public void requestSourceFocus() {
        GUISource current = this.getActiveSource();
        if (current == null) {
            return;
        }
        current.requestFocus();
    }

    public void requestSourceFocus(String serverName, String type, String name) {
        GUISource gui;
        Source source = this.getSource(serverName, type, name);
        if (source != null && (gui = this._interface.getGUISource(source)) != null) {
            this._interface.setActive(gui);
        }
    }

    public void sendString(String serverName, String type, String name, String cmd) {
        Source source = this.getSource(serverName, type, name);
        if (source != null) {
            source.sendString(cmd);
        }
    }

    public void sendUserString(String str) {
        GUISource current = this.getActiveSource();
        if (current == null) {
            return;
        }
        current.getSource().sendUserString(str);
    }

    public void sendString(String str) {
        GUISource current = this.getActiveSource();
        if (current == null) {
            return;
        }
        current.getSource().sendString(str);
    }

    public boolean isConnected() {
        GUISource current = this.getActiveSource();
        if (current == null) {
            return false;
        }
        return current.getSource().isConnected();
    }

    public void sendReport(String description) {
        GUISource current = this.getActiveSource();
        if (current == null) {
            return;
        }
        current.getSource().report(description);
    }

    public void setFieldText(String txt) {
        GUISource current = this.getActiveSource();
        if (current == null) {
            return;
        }
        current.setFieldText(txt);
    }

    public String getFieldText() {
        GUISource current = this.getActiveSource();
        if (current == null) {
            return "";
        }
        return current.getFieldText();
    }

    public void validateText() {
        GUISource current = this.getActiveSource();
        if (current == null) {
            return;
        }
        current.validateText();
    }

    public void sendPluginEvent(String pluginName, Object event) {
        Plugin plugin = (Plugin)this._pluginsTable.get(pluginName);
        if (plugin == null) {
            return;
        }
        plugin.externalEvent(event);
    }

    public Object getPluginValue(String pluginName, Object valueName) {
        Plugin plugin = (Plugin)this._pluginsTable.get(pluginName);
        if (plugin == null) {
            return null;
        }
        return plugin.getValue(valueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] cannotUseRequestedNicknames(Server s) {
        Object object = this._nickLock;
        synchronized (object) {
            if (this._interface.getComponent() != null) {
                this._interface.getComponent().setEnabled(false);
            }
            if (this._frame != null) {
                this._frame.setEnabled(false);
            }
            Frame f = new Frame();
            f.setLayout(new FlowLayout());
            f.setSize(200, 65);
            f.setTitle("Change nickname to");
            TextField field = new TextField(this._start.getNick());
            Button b = new Button("Ok");
            b.addActionListener(this);
            f.add(field);
            f.add(b);
            f.setVisible(true);
            try {
                this._nickLock.wait();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            f.setVisible(false);
            f.remove(b);
            f.remove(field);
            f.dispose();
            String[] ans = new String[]{field.getText()};
            if (this._frame != null) {
                this._frame.setEnabled(true);
            }
            if (this._interface.getComponent() != null) {
                this._interface.getComponent().setEnabled(true);
            }
            return ans;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt) {
        Object object = this._nickLock;
        synchronized (object) {
            this._nickLock.notifyAll();
        }
    }

    private static void usage() {
        System.out.println("Usage :");
        System.out.println("   java irc.IRCApplication -f configfile");
        System.out.println("or java irc.IRCApplication -p nick fullname host gui");
        System.out.println("");
        System.out.println("Without any parameter, '-f pjirc.cfg' parameters are assumed.");
    }

    public static void go(String[] args) {
        LocalFileHandler file = new LocalFileHandler();
        try {
            StartupConfiguration startupConfiguration;
            IRCConfiguration ircConfiguration;
            if (args.length == 0 || args.length >= 2 && args[0].equals("-f")) {
                String f = "pjirc.cfg";
                if (args.length >= 2) {
                    f = args[1];
                }
                StreamParameterProvider provider = new StreamParameterProvider(file.getInputStream(f));
                ConfigurationLoader loader = new ConfigurationLoader(provider, new NullURLHandler(), new AWTImageLoader(), new NullSoundHandler(), file);
                ircConfiguration = loader.loadIRCConfiguration();
                startupConfiguration = loader.loadStartupConfiguration();
            } else if (args.length >= 5 && args[0].equals("-p")) {
                StreamParameterProvider provider = new StreamParameterProvider(null);
                ConfigurationLoader loader = new ConfigurationLoader(provider, new NullURLHandler(), new AWTImageLoader(), new NullSoundHandler(), file);
                ircConfiguration = loader.loadIRCConfiguration();
                ircConfiguration.set("gui", args[4]);
                startupConfiguration = new StartupConfiguration(args[1], "", args[2], new String[]{""}, new String[]{args[3]}, new int[]{6667}, "", new String[0], new String[0], true);
            } else {
                IRCApplication.usage();
                return;
            }
            IRCApplication application = new IRCApplication(ircConfiguration, startupConfiguration, null);
            EventDispatcher.dispatchEventAsyncAndWaitEx(application, "init", new Object[0]);
        }
        catch (Throwable ex) {
            System.out.println("Error : " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        IRCApplication.go(args);
    }
}

