/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.AWTImageLoader;
import irc.AboutDialog;
import irc.AudioConfiguration;
import irc.ConfigurationLoader;
import irc.FileHandler;
import irc.ImageLoader;
import irc.ListHandler;
import irc.LocalFileHandler;
import irc.NullItem;
import irc.NullSoundHandler;
import irc.NullURLHandler;
import irc.ParameterProvider;
import irc.RuleList;
import irc.SmileyLoader;
import irc.SmileyTable;
import irc.SoundHandler;
import irc.StreamParameterProvider;
import irc.StyleContext;
import irc.TextProvider;
import irc.URLHandler;
import irc.security.SecurityProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.util.Hashtable;
import java.util.Locale;

public class IRCConfiguration {
    public static final int TILING_CENTER = 0;
    public static final int TILING_STRETCH = 1;
    public static final int TILING_TILE = 2;
    public static final int TILING_FIXED = 3;
    public static final int TILING_HORIZONTAL_LEFT = 0;
    public static final int TILING_HORIZONTAL_RIGHT = 256;
    public static final int TILING_VERTICAL_UP = 0;
    public static final int TILING_VERTICAL_DOWN = 512;
    private NullItem NULL_ITEM = new NullItem();
    private TextProvider _textProvider;
    private ImageLoader _loader;
    private SmileyLoader _smileyLoader;
    private URLHandler _handler;
    private FileHandler _file;
    private AudioConfiguration _audioConfig;
    private RuleList _backgroundImageRules;
    private RuleList _backgroundTilingRules;
    private RuleList _colorsRules;
    private RuleList _fontRules;
    private SmileyTable _table;
    private SmileyTable _backuptable;
    private ListHandler _mayJoinList;
    private ListHandler _mayLeaveList;
    private ListHandler _mayCommandList;
    private Hashtable _htable;
    private SecurityProvider _provider = new SecurityProvider();
    private ParameterProvider _paramProvider;
    private ParameterProvider _interfaceParamProvider;
    private String _guiInfoString;
    private String[] _initCommands;

    public IRCConfiguration(TextProvider text, URLHandler handler, ImageLoader loader, SoundHandler sound, FileHandler file, ParameterProvider paramProvider, ParameterProvider interfaceParamProvider) {
        this._paramProvider = paramProvider;
        this._interfaceParamProvider = interfaceParamProvider;
        this._htable = new Hashtable();
        this._backgroundImageRules = new RuleList();
        this._backgroundTilingRules = new RuleList();
        this._backgroundTilingRules.setDefaultValue(new Integer(0));
        this._fontRules = new RuleList();
        this._fontRules.setDefaultValue(new Font("SanSerif", 0, 13));
        this._colorsRules = new RuleList();
        Color[] def = new Color[16];
        this.loadDefaultColors(def);
        this._colorsRules.setDefaultValue(def);
        this._audioConfig = new AudioConfiguration(sound);
        this._table = new SmileyTable();
        this._backuptable = new SmileyTable();
        this._file = file;
        this._loader = loader;
        this._textProvider = text;
        this._handler = handler;
        this._guiInfoString = "";
        this._initCommands = new String[0];
    }

    public static IRCConfiguration createDummyIRCConfiguration() {
        try {
            LocalFileHandler file = new LocalFileHandler();
            StreamParameterProvider provider = new StreamParameterProvider(null);
            ConfigurationLoader loader = new ConfigurationLoader(provider, new NullURLHandler(), new AWTImageLoader(), new NullSoundHandler(), file);
            return loader.loadIRCConfiguration();
        }
        catch (Exception ex) {
            throw new Error("Error creating dummy IRCConfiguration : " + ex);
        }
    }

    public String[] getInitialization() {
        return this._initCommands;
    }

    public void setInitialisation(String[] init) {
        this._initCommands = init;
    }

    public String getGUIInfoString() {
        return this._guiInfoString;
    }

    public void setGUIInfoString(String string) {
        this._guiInfoString = string;
    }

    public FileHandler getFileHandler() {
        return this._file;
    }

    public void displayAboutPage() {
        new AboutDialog(this);
    }

    public ParameterProvider getParameterProvider() {
        return this._paramProvider;
    }

    public ParameterProvider getInterfaceParameterProvider() {
        return this._interfaceParamProvider;
    }

    public int getVersionHigh() {
        return 2;
    }

    public int getVersionMed() {
        return 2;
    }

    public int getVersionLow() {
        return 1;
    }

    public String getVersionModifiers() {
        return "";
    }

    public String getVersion() {
        return this.getVersionHigh() + "." + this.getVersionMed() + "." + this.getVersionLow() + this.getVersionModifiers();
    }

    public SecurityProvider getSecurityProvider() {
        return this._provider;
    }

    public synchronized void set(String key, Object obj) {
        if (obj == null) {
            obj = this.NULL_ITEM;
        }
        this._htable.put(key.toLowerCase(Locale.ENGLISH), obj);
    }

    public synchronized void set(String key, int val) {
        this.set(key, new Integer(val));
    }

    public synchronized void set(String key, boolean val) {
        this.set(key, new Boolean(val));
    }

    public synchronized Object get(String key) {
        Object v = this._htable.get(key.toLowerCase(Locale.ENGLISH));
        if (v == null) {
            throw new RuntimeException("Unknown configuration property " + key);
        }
        if (v == this.NULL_ITEM) {
            v = null;
        }
        return v;
    }

    public synchronized int getI(String key) {
        Integer i = (Integer)this.get(key);
        return i;
    }

    public synchronized boolean getB(String key) {
        Boolean b = (Boolean)this.get(key);
        return b;
    }

    public synchronized String getS(String key) {
        return (String)this.get(key);
    }

    public synchronized boolean mayLeave(String channel) {
        return this._mayLeaveList.inList(channel);
    }

    public synchronized boolean mayJoin(String channel) {
        return this._mayJoinList.inList(channel);
    }

    public synchronized void setJoinList(String list) {
        this._mayJoinList = new ListHandler(list);
    }

    public synchronized void setLeaveList(String list) {
        this._mayLeaveList = new ListHandler(list);
    }

    public synchronized void setCommandList(String list) {
        this._mayCommandList = new ListHandler(list);
    }

    public synchronized boolean mayCommand(String cmd) {
        if (cmd.startsWith("/")) {
            cmd = cmd.substring(1);
        }
        return this._mayCommandList.inList(cmd);
    }

    public synchronized Image getBackgroundImage(String type, String name) {
        if (!this.getB("style:backgroundImage")) {
            return null;
        }
        return (Image)this._backgroundImageRules.findValue(new String[]{type, name});
    }

    public synchronized int getBackgroundTiling(String type, String name) {
        return (Integer)this._backgroundTilingRules.findValue(new String[]{type, name});
    }

    public synchronized void setBackgroundImage(String type, String name, String image) {
        this._backgroundImageRules.addRule(new String[]{type, name}, this.getImageLoader().getImage(image));
    }

    public synchronized void setBackgroundTiling(String type, String name, int tiling) {
        this._backgroundTilingRules.addRule(new String[]{type, name}, new Integer(tiling));
    }

    public synchronized void setFont(String type, String name, Font f) {
        this._fontRules.addRule(new String[]{type, name}, f);
    }

    public synchronized String formatASL(String info) {
        int text;
        int pos;
        String noprefix = this.getS("noasldisplayprefix");
        if (noprefix.length() > 0 && info.startsWith(noprefix)) {
            return "";
        }
        String separator = this.getS("aslseparatorstring");
        if (separator.length() > 0 && (pos = info.indexOf(separator)) >= 0) {
            info = info.substring(0, pos);
        }
        String orig = info;
        int pos2 = info.indexOf(32);
        if (pos2 < 0) {
            return orig;
        }
        String age = info.substring(0, pos2).trim();
        if ((pos2 = (info = info.substring(pos2 + 1).trim()).indexOf(32)) < 0) {
            return orig;
        }
        String gender = info.substring(0, pos2).trim().toLowerCase(Locale.ENGLISH);
        String location = info.substring(pos2 + 1).trim();
        if (gender.equals(this.getS("aslmale").toLowerCase(Locale.ENGLISH))) {
            text = 2049;
        } else if (gender.equals(this.getS("aslfemale").toLowerCase(Locale.ENGLISH))) {
            text = 2050;
        } else if (gender.equals(this.getS("aslunknown").toLowerCase(Locale.ENGLISH))) {
            text = 2051;
        } else {
            return orig;
        }
        return this.getText(text, age, location);
    }

    public synchronized Color getASLColor(String info, Color male, Color femeale, Color undef) {
        int pos = info.indexOf(32);
        if (pos < 0) {
            return undef;
        }
        if ((pos = (info = info.substring(pos).trim()).indexOf(32)) < 0) {
            return undef;
        }
        if ((info = info.substring(0, pos).trim().toLowerCase(Locale.ENGLISH)).equals(this.getS("aslmale").toLowerCase(Locale.ENGLISH))) {
            return male;
        }
        if (info.equals(this.getS("aslfemale").toLowerCase(Locale.ENGLISH))) {
            return femeale;
        }
        return undef;
    }

    public AudioConfiguration getAudioConfiguration() {
        return this._audioConfig;
    }

    public synchronized StyleContext getDefaultStyleContext() {
        return this.getStyleContext("", "");
    }

    public synchronized StyleContext getStyleContext(String type, String name) {
        StyleContext ctx = new StyleContext();
        ctx.type = type;
        ctx.name = name;
        return ctx;
    }

    public synchronized void loadDefaultColors(Color[] cols) {
        cols[0] = new Color(0xFFFFFF);
        cols[1] = new Color(0);
        cols[2] = new Color(127);
        cols[3] = new Color(37632);
        cols[4] = new Color(0xFF0000);
        cols[5] = new Color(0x7F0000);
        cols[6] = new Color(0x9C009C);
        cols[7] = new Color(16547584);
        cols[8] = new Color(0xFFFF00);
        cols[9] = new Color(64512);
        cols[10] = new Color(37779);
        cols[11] = new Color(65535);
        cols[12] = new Color(252);
        cols[13] = new Color(0xFF00FF);
        cols[14] = new Color(0x7F7F7F);
        cols[15] = new Color(0xD2D2D2);
    }

    public synchronized void setSourceColor(String type, String name, Color[] c) {
        this._colorsRules.addRule(new String[]{type, name}, c);
    }

    public synchronized Color[] getStyleColors(StyleContext context) {
        return (Color[])this._colorsRules.findValue(new String[]{context.type, context.name});
    }

    public synchronized Font getStyleFont(StyleContext context) {
        return (Font)this._fontRules.findValue(new String[]{context.type, context.name});
    }

    public synchronized Image getStyleBackgroundImage(StyleContext context) {
        return this.getBackgroundImage(context.type, context.name);
    }

    public synchronized int getStyleBackgroundTiling(StyleContext context) {
        return this.getBackgroundTiling(context.type, context.name);
    }

    private ImageLoader getSmileyLoader() {
        if (this._smileyLoader == null) {
            this._smileyLoader = new SmileyLoader();
        }
        return this._smileyLoader;
    }

    public synchronized void addSmiley(String match, String file) {
        this._table.addSmiley(match, this.getSmileyLoader().getImage(file));
        this._backuptable.addSmiley(match, this.getSmileyLoader().getImage(file));
    }

    public ImageLoader getImageLoader() {
        return this._loader;
    }

    public SmileyTable getSmileyTable() {
        return this._table;
    }

    public SmileyTable resetSmileyTable() {
        this._table = new SmileyTable();
        return this._table;
    }

    public SmileyTable restoreSmileyTable() {
        this._table = this._backuptable;
        return this._table;
    }

    public String reloadSmileyTable() {
        int tsize = this._table.getSize();
        System.out.print("The Smiley Table has been changed, previous value: ");
        System.out.println(tsize);
        if (tsize == 0) {
            System.out.println("Smileys are now enabled");
            this.restoreSmileyTable();
            return "Smileys are now enabled";
        }
        System.out.println("Smileys are now disabled");
        this.resetSmileyTable();
        return "Smileys are now disabled";
    }

    public synchronized boolean getASLMaster() {
        return this.getB("asl") | this.getB("style:floatingasl");
    }

    public URLHandler getURLHandler() {
        return this._handler;
    }

    public TextProvider getTextProvider() {
        return this._textProvider;
    }

    public void internalError(String message, Throwable ex, String mail) {
        System.err.println("************ Internal error ************");
        System.err.println("Please submit a bug report to " + mail + " including the following information:");
        System.err.println("Message:");
        System.err.println(message);
        if (ex != null) {
            System.err.println("Root cause:");
            ex.printStackTrace();
        }
        System.err.println("Stack trace:");
        Thread.dumpStack();
    }

    public synchronized String getText(int code) {
        return this._textProvider.getString(code);
    }

    public synchronized String getText(int code, String p1) {
        return this._textProvider.getString(code, p1);
    }

    public synchronized String getText(int code, String p1, String p2) {
        return this._textProvider.getString(code, p1, p2);
    }

    public synchronized String getText(int code, String p1, String p2, String p3) {
        return this._textProvider.getString(code, p1, p2, p3);
    }
}

