/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.BasicInterpretor;
import irc.IRCConfiguration;
import irc.IRCServer;
import irc.NotEnoughParametersException;
import irc.Source;

public class IRCInterpretor
extends BasicInterpretor {
    public IRCInterpretor(IRCConfiguration config) {
        super(config);
    }

    protected void handleCommand(Source source, String cmd, String[] parts, String[] cumul) {
        try {
            IRCServer server = (IRCServer)source.getServer();
            if (cmd.equals("list")) {
                if (parts.length <= 1) {
                    server.execute("LIST");
                } else {
                    server.execute("LIST " + parts[1]);
                }
            } else if (cmd.equals("topic")) {
                this.test(cmd, parts, 2);
                server.execute("TOPIC " + parts[1] + " :" + cumul[2]);
            } else if (cmd.equals("away")) {
                if (parts.length <= 1) {
                    server.execute("AWAY");
                } else {
                    server.execute("AWAY :" + cumul[1]);
                }
            } else if (cmd.equals("quit")) {
                if (parts.length > 1) {
                    server.execute("QUIT :" + cumul[1]);
                } else {
                    server.execute("QUIT");
                }
            } else if (cmd.equals("part")) {
                this.test(cmd, parts, 1);
                if (parts.length == 2) {
                    server.execute("PART " + parts[1]);
                } else {
                    server.execute("PART " + parts[1] + " :" + cumul[2]);
                }
            } else if (cmd.equals("kick")) {
                this.test(cmd, parts, 2);
                if (parts.length == 3) {
                    server.execute("KICK " + parts[1] + " " + parts[2]);
                } else {
                    server.execute("KICK " + parts[1] + " " + parts[2] + " :" + cumul[3]);
                }
            } else if (cmd.equals("notice")) {
                this.test(cmd, parts, 2);
                server.execute("NOTICE " + parts[1] + " :" + cumul[2]);
                source.report("-> -" + parts[1] + "- " + cumul[2]);
            } else if (cmd.equals("join")) {
                this.test(cmd, parts, 1);
                String chan = parts[1];
                if (!(chan.startsWith("#") || chan.startsWith("!") || chan.startsWith("&") || chan.startsWith("+"))) {
                    chan = '#' + chan;
                }
                if (parts.length <= 2) {
                    server.execute("JOIN " + chan);
                } else {
                    server.execute("JOIN " + chan + " " + parts[2]);
                }
            } else if (cmd.equals("j")) {
                this.sendString(source, "/join " + cumul[1]);
            } else if (cmd.equals("query")) {
                this.test(cmd, parts, 1);
                server.getQuery(parts[1], true);
            } else if (cmd.equals("whisper")) {
                this.test(cmd, parts, 1);
                server.getQuery(parts[1], true);
            } else if (cmd.equals("ignore")) {
                this.test(cmd, parts, 1);
                if (!server.ignore(parts[1])) {
                    server.addIgnore(parts[1]);
                    source.report("\u000314      \ufffd\ufffd\ufffd You are now ignoring " + parts[1] + ".");
                }
            } else if (cmd.equals("unignore")) {
                this.test(cmd, parts, 1);
                if (server.ignore(parts[1])) {
                    server.removeIgnore(parts[1]);
                    source.report("\u000314      \ufffd\ufffd\ufffd You are no longer ignoring " + parts[1] + ".");
                }
            } else if (cmd.equals("server")) {
                this.test(cmd, parts, 1);
                int port = 6667;
                String pass = "";
                if (parts.length > 2) {
                    port = new Integer(parts[2]);
                }
                if (parts.length > 3) {
                    pass = parts[3];
                }
                String host = parts[1];
                if (server.isConnected()) {
                    server.disconnect();
                }
                server.setServers(new String[]{host}, new int[]{port}, new String[]{pass});
                server.connect();
            } else if (cmd.equals("connect")) {
                server.connect();
            } else if (cmd.equals("disconnect")) {
                server.disconnect();
            } else {
                super.handleCommand(source, cmd, parts, cumul);
            }
        }
        catch (NotEnoughParametersException ex) {
            source.report("\u00032      \ufffd\ufffd\ufffd Invalid command format: " + ex.getMessage());
        }
    }
}

