/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.ChanList;
import irc.Channel;
import irc.ChannelInfo;
import irc.FirstLineFilter;
import irc.IRCConfiguration;
import irc.IRCObject;
import irc.ListenerGroup;
import irc.MessageServerListener;
import irc.ModeHandler;
import irc.MultiModeHandler;
import irc.Query;
import irc.ReplyServerListener;
import irc.Server;
import irc.ServerListener;
import irc.ServerManager;
import irc.ServerProtocol;
import irc.ServerProtocolListener;
import irc.Source;
import irc.Status;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class IRCServer
extends IRCObject
implements Server,
ServerProtocolListener {
    private ServerProtocol _protocol;
    private Hashtable _channels;
    private Hashtable _queries;
    private Hashtable _chanlist;
    private Status _status;
    private Hashtable _ignoreList;
    private ListenerGroup _listeners;
    private ListenerGroup _replylisteners;
    private ListenerGroup _messagelisteners;
    private String[] _askedNick;
    private String _nick;
    private String _userName;
    private int _tryNickIndex;
    private ModeHandler _mode;
    private String[] _host;
    private int[] _port;
    private String[] _passWord;
    private int _tryServerIndex;
    private boolean _connected;
    private String _name;
    private Source _defaultSource;
    private boolean _serverLeaving;
    private boolean _registered;
    private FirstLineFilter _filter;
    private char[] _nickModes = new char[]{'q', 'a', 'o', 'h', 'v'};
    private char[] _nickPrefixes = new char[]{'~', '&', '@', '%', '+'};
    private char[] _channelPrefixes = new char[]{'#', '&', '!', '+'};
    private char[][] _globalModes = new char[][]{{'b'}, {'k'}, {'l'}, {'i', 'm', 'n', 'p', 's', 't', 'a', 'q', 'r'}};

    public IRCServer(IRCConfiguration config, ServerManager mgr, String nick, String altNick, String userName, String name) {
        super(config);
        this._filter = new FirstLineFilter(this, mgr, config);
        this._serverLeaving = false;
        this._name = name;
        this._userName = userName;
        this._askedNick = new String[2];
        this._askedNick[0] = nick;
        this._askedNick[1] = altNick;
        this._nick = nick;
        this._connected = false;
        this._ignoreList = new Hashtable();
        this._channels = new Hashtable();
        this._queries = new Hashtable();
        this._chanlist = new Hashtable();
        this._listeners = new ListenerGroup();
        this._replylisteners = new ListenerGroup();
        this._messagelisteners = new ListenerGroup();
        this._status = new Status(this._ircConfiguration, this);
        this._defaultSource = this._status;
        this._protocol = new ServerProtocol(this._ircConfiguration);
        this._protocol.addServerProtocolListener(this);
        this._host = null;
        this._mode = new ModeHandler(this._globalModes, this._nickModes);
    }

    public Object[] specialRequest(String request, Object[] params) {
        return this._listeners.sendEvent("specialServerRequest", request, this, params);
    }

    public void release() {
        this._protocol.removeServerProtocolListener(this);
        this._filter.release();
        super.release();
    }

    public Enumeration getSources() {
        Vector<Object> v = new Vector<Object>();
        Enumeration e = this._channels.elements();
        while (e.hasMoreElements()) {
            v.insertElementAt(e.nextElement(), v.size());
        }
        e = this._queries.elements();
        while (e.hasMoreElements()) {
            v.insertElementAt(e.nextElement(), v.size());
        }
        e = this._chanlist.elements();
        while (e.hasMoreElements()) {
            v.insertElementAt(e.nextElement(), v.size());
        }
        if (this._status != null) {
            v.insertElementAt(this._status, v.size());
        }
        return v.elements();
    }

    public void enumerateSourcesAsCreated(ServerListener lis) {
        Enumeration e = this._channels.elements();
        while (e.hasMoreElements()) {
            lis.sourceCreated((Source)e.nextElement(), this, new Boolean(false));
        }
        e = this._queries.elements();
        while (e.hasMoreElements()) {
            lis.sourceCreated((Source)e.nextElement(), this, new Boolean(false));
        }
        e = this._chanlist.elements();
        while (e.hasMoreElements()) {
            lis.sourceCreated((Source)e.nextElement(), this, new Boolean(false));
        }
        if (this._status != null) {
            lis.sourceCreated(this._status, this, new Boolean(true));
        }
    }

    public void enumerateSourcesAsRemoved(ServerListener lis) {
        Enumeration e = this._channels.elements();
        while (e.hasMoreElements()) {
            lis.sourceRemoved((Source)e.nextElement(), this);
        }
        e = this._queries.elements();
        while (e.hasMoreElements()) {
            lis.sourceRemoved((Source)e.nextElement(), this);
        }
        e = this._chanlist.elements();
        while (e.hasMoreElements()) {
            lis.sourceRemoved((Source)e.nextElement(), this);
        }
        if (this._status != null) {
            lis.sourceRemoved(this._status, this);
        }
    }

    public void setDefaultSource(Source s) {
        this._defaultSource = s;
    }

    public Source getDefaultSource() {
        return this._defaultSource;
    }

    public void setServers(String[] host, int[] port, String[] passWord) {
        int i;
        this._tryServerIndex = 0;
        this._host = new String[host.length];
        for (i = 0; i < host.length; ++i) {
            this._host[i] = host[i];
        }
        this._port = new int[port.length];
        for (i = 0; i < port.length; ++i) {
            this._port[i] = port[i];
        }
        this._passWord = new String[passWord.length];
        for (i = 0; i < passWord.length; ++i) {
            this._passWord[i] = passWord[i];
        }
    }

    public void connect() {
        this._tryServerIndex = 0;
        if (this._host != null) {
            this.connect(this._host, this._port, this._passWord);
        }
    }

    private void connect(String[] host, int[] port, String[] passWord) {
        this._registered = false;
        if (this._tryServerIndex == this._host.length) {
            return;
        }
        this._tryNickIndex = 0;
        this._passWord = passWord;
        if (this._protocol.connecting()) {
            this.sendStatusMessage("\u00033  Unable to connect to " + host[this._tryServerIndex] + ". Currently trying to connect to " + this._host[this._tryServerIndex] + ".");
            return;
        }
        if (this._protocol.connected()) {
            this._protocol.disconnect();
        }
        this._connected = false;
        this.sendStatusMessage("\u00033  Please wait, connecting to server...");
        this._protocol.connect(host[this._tryServerIndex], port[this._tryServerIndex]);
    }

    public void disconnect() {
        if (this._protocol.connected()) {
            if (this._ircConfiguration.getS("quitmessage").length() == 0) {
                this.execute("QUIT");
            } else {
                this.execute("QUIT :" + this._ircConfiguration.get("quitmessage"));
            }
        } else {
            this.sendStatusMessage("\u00032  You are currently not connected...");
        }
    }

    public boolean isConnected() {
        return this._connected;
    }

    public void connectionFailed(String message, String host) {
        this.sendStatusMessage("\u00032  Network problems are preventing you from connecting to the chat service. Press connect to try again.");
        ++this._tryServerIndex;
        if (this._tryServerIndex < this._host.length) {
            this.connect(this._host, this._port, this._passWord);
        }
    }

    private void nickUsed() {
        if (this._tryNickIndex >= this._askedNick.length) {
            Object[] res = this._listeners.sendEvent("cannotUseRequestedNicknames", new Object[]{this});
            if (res.length > 0) {
                this._askedNick = (String[])res[0];
            }
            this._tryNickIndex = 0;
        } else if (this._askedNick[this._tryNickIndex].indexOf("?") == -1) {
            ++this._tryNickIndex;
        }
    }

    private void register() {
        String tryUseNick = this._askedNick[this._tryNickIndex];
        if (tryUseNick.length() == 0) {
            tryUseNick = "Guest_????";
        }
        String ans = "";
        for (int i = 0; i < tryUseNick.length(); ++i) {
            char c = tryUseNick.charAt(i);
            if (c == '?') {
                c = (char)(48.0 + Math.random() * 10.0);
            }
            ans = ans + c;
        }
        if (this._passWord[this._tryServerIndex].length() > 0) {
            this.execute("pass " + this._passWord[this._tryServerIndex]);
        }
        this.execute("nick " + ans);
        String name = this._ircConfiguration.getS("userid");
        if (name.length() == 0) {
            name = ans;
        }
        if (!this._registered) {
            this._registered = true;
            this.execute("user " + name + " 0 0 :" + this._userName);
        }
    }

    public int getLocalPort() {
        return this._protocol.getLocalPort();
    }

    public void connected(String host) {
        this.sendStatusMessage("\u00034  Connected!");
        this.sendStatusMessage("");
        this.sendStatusMessage("  Welcome to FrostWire Chat! FrostWire does not control or endorse the content, messages or information found in this chat. FrostWire specifically disclaims any liability with regard to these areas. To review the FrostWire Chat guidelines, go to \u000312\u001fhttp://www.frostwire.com/chat/conduct\u001f\u0003");
        this.sendStatusMessage("");
        this.register();
    }

    private void clear(Hashtable l) {
        Enumeration e = l.elements();
        while (e.hasMoreElements()) {
            this._listeners.sendEvent("sourceRemoved", e.nextElement(), this);
        }
        e = l.elements();
        while (e.hasMoreElements()) {
            ((Source)e.nextElement()).release();
        }
        l.clear();
    }

    public void disconnected(String host) {
        this.sendStatusMessage("\u00033  You have been disconnected from the chat server.");
        this.clear(this._channels);
        this.clear(this._queries);
        this.clear(this._chanlist);
        this._mode.reset();
        if (this._status != null) {
            this._status.modeChanged(this.getMode());
        }
        this._connected = false;
        this._listeners.sendEvent("serverDisconnected", this);
        if (this._serverLeaving) {
            this._listeners.sendEvent("sourceRemoved", this._status, this);
            this.deleteStatus("");
            this._listeners.sendEvent("serverLeft", this);
        }
    }

    public void sendStatusMessage(String msg) {
        if (this._status != null) {
            this._status.report(msg);
        }
    }

    public Enumeration getChannels() {
        return this._channels.elements();
    }

    public Enumeration getQueries() {
        return this._queries.elements();
    }

    public Enumeration getChanLists() {
        return this._chanlist.elements();
    }

    public Channel getChannel(String name, boolean create) {
        Channel c = (Channel)this._channels.get(name.toLowerCase(Locale.ENGLISH));
        if (c == null && create) {
            c = new Channel(this._ircConfiguration, name, this);
            this._channels.put(name.toLowerCase(Locale.ENGLISH), c);
            this._listeners.sendEvent("sourceCreated", c, this, new Boolean(true));
        }
        return c;
    }

    public Query getQuery(String nick, boolean local) {
        if (!this._connected) {
            return null;
        }
        if (this._ircConfiguration.getB("disablequeries")) {
            return null;
        }
        Query c = (Query)this._queries.get(nick.toLowerCase(Locale.ENGLISH));
        if (c == null) {
            c = new Query(this._ircConfiguration, nick, this);
            this._queries.put(nick.toLowerCase(Locale.ENGLISH), c);
            this._listeners.sendEvent("sourceCreated", c, this, new Boolean(local));
        }
        return c;
    }

    private ChanList getChanList(String name) {
        ChanList c = (ChanList)this._chanlist.get(name.toLowerCase(Locale.ENGLISH));
        if (c == null) {
            c = new ChanList(this._ircConfiguration, this, name);
            this._chanlist.put(name.toLowerCase(Locale.ENGLISH), c);
            this._listeners.sendEvent("sourceCreated", c, this, new Boolean(true));
        }
        return c;
    }

    public void leaveChannel(String name) {
        this.execute("part " + name);
    }

    public void leaveQuery(String name) {
        Query q = this.getQuery(name, false);
        if (q == null) {
            return;
        }
        this._listeners.sendEvent("sourceRemoved", q, this);
        this.deleteQuery(name);
    }

    public void leave() {
        this.leaveStatus("");
    }

    public void leaveStatus(String name) {
        if (this._status == null) {
            return;
        }
        if (this.isConnected()) {
            this._serverLeaving = true;
            this.disconnect();
        } else {
            this._listeners.sendEvent("sourceRemoved", this._status, this);
            this.deleteStatus("");
            this._listeners.sendEvent("serverLeft", this);
        }
    }

    public void leaveChanList(String name) {
        this._listeners.sendEvent("sourceRemoved", this.getChanList(name), this);
        this.deleteChanList(name);
    }

    private void deleteSource(Source src) {
        if (src == this._defaultSource) {
            this._defaultSource = null;
        }
        src.release();
    }

    private void deleteChannel(String name) {
        this.deleteSource((Source)this._channels.remove(name.toLowerCase(Locale.ENGLISH)));
    }

    private void deleteQuery(String name) {
        this.deleteSource((Source)this._queries.remove(name.toLowerCase(Locale.ENGLISH)));
    }

    private void deleteChanList(String name) {
        this.deleteSource((Source)this._chanlist.remove(name.toLowerCase(Locale.ENGLISH)));
    }

    private void deleteStatus(String name) {
        this.deleteSource(this._status);
        this._status = null;
    }

    public String getServerName() {
        if (this._name.length() == 0) {
            if (this._tryServerIndex < this._host.length) {
                return this._host[this._tryServerIndex];
            }
            return this._host[0];
        }
        return this._name;
    }

    public Status getStatus() {
        return this._status;
    }

    public void addServerListener(ServerListener l) {
        this._listeners.addListener(l);
    }

    public void removeServerListener(ServerListener l) {
        this._listeners.removeListener(l);
    }

    public void addReplyServerListener(ReplyServerListener l) {
        this._replylisteners.addListener(l);
    }

    public void addMessageServerListener(MessageServerListener l) {
        this._messagelisteners.addListener(l);
    }

    public void removeReplyServerListener(ReplyServerListener l) {
        this._replylisteners.removeListener(l);
    }

    public void removeMessageServerListener(MessageServerListener l) {
        this._messagelisteners.removeListener(l);
    }

    public char[] getChannelPrefixes() {
        return this._channelPrefixes;
    }

    public char[] getNickPrefixes() {
        return this._nickPrefixes;
    }

    public char[] getNickModes() {
        return this._nickModes;
    }

    public char[][] getChannelModes() {
        return this._globalModes;
    }

    public String getNickPrefix(String mode) {
        if (mode.length() == 0) {
            return "";
        }
        char cmode = mode.charAt(0);
        for (int i = 0; i < this._nickModes.length; ++i) {
            if (this._nickModes[i] != cmode) continue;
            return "" + this._nickPrefixes[i];
        }
        return "";
    }

    public String getNickMode(String prefix) {
        if (prefix.length() == 0) {
            return "";
        }
        char cprefix = prefix.charAt(0);
        for (int i = 0; i < this._nickPrefixes.length; ++i) {
            if (this._nickPrefixes[i] != cprefix) continue;
            return "" + this._nickModes[i];
        }
        return "";
    }

    private void setNicks(Channel c, Vector nicks) {
        String[] n = new String[nicks.size()];
        String[] modes = new String[nicks.size()];
        for (int i = 0; i < nicks.size(); ++i) {
            n[i] = (String)nicks.elementAt(i);
            modes[i] = "";
            if (n[i].length() <= 0) continue;
            modes[i] = this.getNickMode("" + n[i].charAt(0));
            if (modes[i].length() == 0) continue;
            n[i] = n[i].substring(1);
        }
        c.setNicks(n, modes);
    }

    private void decodeVariable(String key, String val) {
        block14: {
            int i;
            block15: {
                block13: {
                    int i2;
                    if (!key.toLowerCase(Locale.ENGLISH).equals("prefix")) break block13;
                    if (!val.startsWith("(")) {
                        return;
                    }
                    int pos = val.indexOf(")");
                    if (pos < 0) {
                        return;
                    }
                    String modes = val.substring(1, pos);
                    String prefixes = val.substring(pos + 1);
                    if (prefixes.length() != modes.length()) {
                        return;
                    }
                    this._nickModes = new char[modes.length()];
                    for (i2 = 0; i2 < modes.length(); ++i2) {
                        this._nickModes[i2] = modes.charAt(i2);
                    }
                    this._nickPrefixes = new char[modes.length()];
                    for (i2 = 0; i2 < prefixes.length(); ++i2) {
                        this._nickPrefixes[i2] = prefixes.charAt(i2);
                    }
                    break block14;
                }
                if (!key.toLowerCase(Locale.ENGLISH).equals("chantypes")) break block15;
                this._channelPrefixes = new char[val.length()];
                for (int i3 = 0; i3 < this._channelPrefixes.length; ++i3) {
                    this._channelPrefixes[i3] = val.charAt(i3);
                }
                break block14;
            }
            if (!key.toLowerCase(Locale.ENGLISH).equals("chanmodes")) break block14;
            int pos = val.indexOf(44);
            if (pos < 0) {
                return;
            }
            String a = val.substring(0, pos);
            if ((pos = (val = val.substring(pos + 1)).indexOf(44)) < 0) {
                return;
            }
            String b = val.substring(0, pos);
            if ((pos = (val = val.substring(pos + 1)).indexOf(44)) < 0) {
                return;
            }
            String c = val.substring(0, pos);
            String d = val.substring(pos + 1);
            this._globalModes = new char[4][];
            this._globalModes[0] = new char[a.length()];
            for (i = 0; i < a.length(); ++i) {
                this._globalModes[0][i] = a.charAt(i);
            }
            this._globalModes[1] = new char[b.length()];
            for (i = 0; i < b.length(); ++i) {
                this._globalModes[1][i] = b.charAt(i);
            }
            this._globalModes[2] = new char[c.length()];
            for (i = 0; i < c.length(); ++i) {
                this._globalModes[2][i] = c.charAt(i);
            }
            this._globalModes[3] = new char[d.length()];
            for (i = 0; i < d.length(); ++i) {
                this._globalModes[3][i] = d.charAt(i);
            }
        }
    }

    private void learnServerVariables(String[] var) {
        for (int i = 1; i < var.length; ++i) {
            String val;
            String key;
            String v = var[i];
            int pos = v.indexOf(61);
            if (pos < 0) {
                key = v;
                val = "";
            } else {
                key = v.substring(0, pos);
                val = v.substring(pos + 1);
            }
            this.decodeVariable(key, val);
        }
        this._mode = new ModeHandler(this._globalModes, this._nickModes);
    }

    public void replyReceived(String prefix, String id, String[] params) {
        Object[] b = this._replylisteners.sendEvent("replyReceived", new Object[]{prefix, id, params, this});
        for (int i = 0; i < b.length; ++i) {
            if (!((Boolean)b[i]).booleanValue()) continue;
            return;
        }
        if (id.equals("232")) {
            String toSend = "";
            for (int i = 1; i < params.length; ++i) {
                toSend = toSend + " " + params[i];
            }
            toSend = toSend.substring(1);
            this.sendStatusMessage(toSend);
        } else if (id.equals("324")) {
            Channel c = this.getChannel(params[1], false);
            if (c != null) {
                String mode = "";
                for (int i = 2; i < params.length; ++i) {
                    mode = mode + " " + params[i];
                }
                mode = mode.substring(1);
                c.applyMode(mode, "");
            }
        } else if (id.equals("332")) {
            Channel c = this.getChannel(params[1], false);
            if (c != null) {
                c.setTopic(params[2], "");
            }
        } else if (id.equals("353")) {
            Channel c;
            int first = 1;
            if (params[1].length() == 1) {
                ++first;
            }
            if ((c = this.getChannel(params[first], false)) != null) {
                String nick = "";
                Vector<String> nicks = new Vector<String>();
                for (int i = 0; i < params[first + 1].length(); ++i) {
                    char u = params[first + 1].charAt(i);
                    if (u == ' ') {
                        if (nick.length() > 0) {
                            nicks.insertElementAt(nick, nicks.size());
                        }
                        nick = "";
                        continue;
                    }
                    nick = nick + u;
                }
                if (nick.length() > 0) {
                    nicks.insertElementAt(nick, nicks.size());
                }
                this.setNicks(c, nicks);
            }
        } else if (id.equals("001")) {
            String nick = params[0];
            if (!nick.equals(this._nick)) {
                this._nick = nick;
                if (this._status != null) {
                    this._status.nickChanged(nick);
                }
            }
            this._connected = true;
            this._listeners.sendEvent("serverConnected", this);
        } else if (id.equals("005")) {
            this.learnServerVariables(params);
        } else if (id.equals("321")) {
            this.getChanList(this._host[this._tryServerIndex]).begin();
        } else if (id.equals("322")) {
            String name = params[1];
            int count = new Integer(params[2]);
            if (count < Short.MAX_VALUE && this.isChannel(name)) {
                String topic = params[3];
                this.getChanList(this._host[this._tryServerIndex]).addChannel(new ChannelInfo(name, topic, count));
            }
        } else if (id.equals("323")) {
            this.getChanList(this._host[this._tryServerIndex]).end();
        } else if (id.equals("433")) {
            if (!this._connected) {
                this.nickUsed();
                this.register();
            } else if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** That nickname is already in use, please try another one.");
            }
        } else if (id.equals("400")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00032      *** The message could not be sent.");
            }
        } else if (id.equals("401")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** That room or person does not exist.");
            }
        } else if (id.equals("402")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The server you specified does not exist.");
            }
        } else if (id.equals("403")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The room you are trying to set does not exist");
            }
        } else if (id.equals("404")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00032      *** The message could not be sent. The message was either blocked or you may not be allowed to communicate in this room.");
            }
        } else if (id.equals("405")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Unable to join because you have too many rooms open.");
            }
        } else if (id.equals("412")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u001b      *** You must first type a message before sending it.");
            }
        } else if (id.equals("421")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u001b      *** The command you typed is not supported.");
            }
        } else if (id.equals("432")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u001b      *** That nickname is not allowed. Please choose another nickname.");
            }
        } else if (id.equals("433")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u001b      *** That nickname is already in use, please try another one.");
            }
        } else if (id.equals("438")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u001b      *** You are trying to change your nickname too quickly, try again later.");
            }
        } else if (id.equals("440")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u001b      *** Services are currently down. Please try again later.");
            }
        } else if (id.equals("442")) {
            Channel chan = this.getChannel(params[1], false);
            if (chan != null) {
                this._listeners.sendEvent("sourceRemoved", chan, this);
                this.deleteChannel(chan.getName());
            } else if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u001b      *** You must first join the room before doing that.");
            }
        } else if (id.equals("443")) {
            String cname = params[1];
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u001b      *** Your invitation to " + cname + " could not be sent because that user is already in the room.");
            }
        } else if (id.equals("460")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u001c      *** You don't have permission to do that in this chat room.");
            }
        } else if (id.equals("461")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u00032      *** You must specify more parameters for this command.");
            }
        } else if (id.equals("462")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u00034      *** You have already registered, you may not reregister.");
            }
        } else if (id.equals("463")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u00034      *** You are not among the privileged.");
            }
        } else if (id.equals("464")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u00034      *** Your authentication password has failed.");
            }
        } else if (id.equals("465")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u00034      *** You are currently banned completely from the FrostWire Chat service due to violations of the Code of Conduct. This ban is permanent.");
            }
        } else if (id.equals("447")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Nickname changes are not permitted at this time, try again later.");
            }
        } else if (id.equals("467")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The room key has already been set.");
            }
        } else if (id.equals("468")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You must be a Sysop to change that mode.");
            }
        } else if (id.equals("469")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The link is already set for this room.");
            }
        } else if (id.equals("470")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The room you are trying to join is full. Trying next available room...");
            }
        } else if (id.equals("471")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The room you are trying to join is full. You cannot join it.");
            }
        } else if (id.equals("472")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The mode you are trying to set does not exist.");
            }
        } else if (id.equals("473")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Only those who have been invited may enter that room.");
            }
        } else if (id.equals("474")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u0002\u00034      *** You are currently banned by a host in that chat room due to violations of the Code of Conduct. You may be able to rejoin at a later time.");
            }
        } else if (id.equals("475")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The room you are trying to join is protected with a password. You cannot join it.");
            }
        } else if (id.equals("476")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The room mode you are trying to set does not exist");
            }
        } else if (id.equals("477")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Only authenticated users can join that room.");
            }
        } else if (id.equals("478")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The ban list is full. You must remove a current ban before setting a new one.");
            }
        } else if (id.equals("479")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The room you are trying to join has an invalid link set and can't be joined.");
            }
        } else if (id.equals("480")) {
            String cname = params[1];
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** " + cname + " does not allow knocks.");
            }
        } else if (id.equals("481")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Permission Denied. You are not a System Operator.");
            }
        } else if (id.equals("482")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You don't have permission to do that in this chat room.");
            }
        } else if (id.equals("483")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Permission Denied. You are not a System Operator.");
            }
        } else if (id.equals("484")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The user is protected. You don't have permission to do that on this network.");
            }
        } else if (id.equals("485")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You don't have permission to do that on this network.");
            }
        } else if (id.equals("486")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You must be authenticated to message that user.");
            }
        } else if (id.equals("487")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You must be a System Operator to execute that command.");
            }
        } else if (id.equals("488")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Waiting: This option is temporarily disabled.");
            }
        } else if (id.equals("489")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You must be using a secure connection to join that room.");
            }
        } else if (id.equals("490")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** This user has blocked private messages that are not suitable for all audiences.");
            }
        } else if (id.equals("491")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Permission Denied. You are not authorized to access network controls.");
            }
        } else if (id.equals("492")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Your request could not be sent because that user does not allow it.");
            }
        } else if (id.equals("499")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You must be an Owner in the chat room to complete the action you just attempted.");
            }
        } else if (id.equals("500")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Too many join requests. Please wait a while and try again.");
            }
        } else if (id.equals("501")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00032      *** Unknown user mode.");
            }
        } else if (id.equals("502")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Permission Denied. You are not a System Operator.");
            }
        } else if (id.equals("511")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00032      *** You have reached the maximum amount of entries allowed in your silence list.");
            }
        } else if (id.equals("512")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00032      *** You have reached the maximum amount of entries allowed in your watch list.");
            }
        } else if (id.equals("513")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00032      *** To connect, type /QOUTE PONG %lX");
            }
        } else if (id.equals("514")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00032      *** You have reached the maximum amount of entries allowed in your DCC list.");
            }
        } else if (id.equals("518")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** This room does not allow invitations.");
            }
        } else if (id.equals("519")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You must be a System Operator to join that room.");
            }
        } else if (id.equals("520")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You must be an Operator to join that room.");
            }
        } else if (id.equals("524")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You must be a System Operator to join that room.");
            }
        } else if (id.equals("972")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You don't have permission to do that in this chat room.");
            }
        } else if (id.equals("974")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** You don't have permission to do that in this chat room.");
            }
        } else if (id.equals("951")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** The server is too busy to process your authentication at this time.");
            }
        } else if (id.equals("952")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Username and/or password do not match.");
            }
        } else if (id.equals("953")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Username and/or password do not match.");
            }
        } else if (id.equals("954")) {
            if (this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** Username and/or password do not match.");
            }
        } else if (id.equals("955") && this._defaultSource != null) {
            this._defaultSource.report("\u00033      *** Username and/or password do not match.");
        }
    }

    private String extractNick(String full) {
        int pos = full.indexOf(33);
        if (pos == -1) {
            return full;
        }
        return full.substring(0, pos);
    }

    private boolean isChannel(String name) {
        if (name.length() == 0) {
            return false;
        }
        for (int i = 0; i < this._channelPrefixes.length; ++i) {
            if (name.charAt(0) != this._channelPrefixes[i]) continue;
            return true;
        }
        return false;
    }

    private void globalNickRemove(String nick, String reason) {
        Enumeration e = this._channels.elements();
        while (e.hasMoreElements()) {
            Channel c = (Channel)e.nextElement();
            if (!c.hasNick(nick)) continue;
            c.quitNick(nick, reason);
        }
    }

    private void globalNickChange(String oldNick, String newNick) {
        Enumeration e = this._channels.elements();
        while (e.hasMoreElements()) {
            Channel c = (Channel)e.nextElement();
            if (!c.hasNick(oldNick)) continue;
            c.changeNick(oldNick, newNick);
        }
        Query q = (Query)this._queries.get(oldNick.toLowerCase(Locale.ENGLISH));
        if (q != null) {
            this._queries.remove(oldNick.toLowerCase(Locale.ENGLISH));
            q.changeNick(newNick);
            Query existing = (Query)this._queries.get(newNick.toLowerCase(Locale.ENGLISH));
            if (existing != null) {
                existing.leave();
            }
            this._queries.put(newNick.toLowerCase(Locale.ENGLISH), q);
        }
    }

    public synchronized boolean ignore(String nick) {
        return this._ignoreList.get(nick) != null;
    }

    public synchronized void addIgnore(String nick) {
        this._ignoreList.put(nick, nick);
    }

    public synchronized void removeIgnore(String nick) {
        this._ignoreList.remove(nick);
    }

    public void messageReceived(String prefix, String command, String[] params) {
        Object[] b = this._messagelisteners.sendEvent("messageReceived", new Object[]{prefix, command, params, this});
        for (int i = 0; i < b.length; ++i) {
            if (!((Boolean)b[i]).booleanValue()) continue;
            return;
        }
        String toSend = "";
        for (int i = 0; i < params.length; ++i) {
            toSend = toSend + " " + params[i];
        }
        command = command.toLowerCase(Locale.ENGLISH);
        String nick = this.extractNick(prefix);
        if (command.equals("notice")) {
            if (!this.ignore(nick) && !this._filter.performFromNotice(nick, params[1]) && this._defaultSource != null) {
                this._defaultSource.noticeReceived(nick, params[1]);
            }
        } else if (command.equals("privmsg")) {
            if (!this.ignore(nick)) {
                Query q;
                if (this.isChannel(params[0])) {
                    Channel c;
                    if (!this._filter.performFromChannelMessage(params[0], nick, params[1]) && (c = this.getChannel(params[0], false)) != null) {
                        c.messageReceived(nick, params[1]);
                    }
                } else if (!this._filter.performFromNickMessage(nick, params[1]) && (q = this.getQuery(nick, false)) != null) {
                    q.messageReceived(nick, params[1]);
                }
            }
        } else if (command.equals("join")) {
            if (!nick.equals(this.getNick())) {
                Channel c = this.getChannel(params[0], false);
                if (c != null) {
                    c.joinNick(nick, "");
                }
            } else {
                Channel c = this.getChannel(params[0], true);
                if (c != null) {
                    c.resetNicks();
                    this.execute("mode " + params[0]);
                }
            }
        } else if (command.equals("part")) {
            Channel c = this.getChannel(params[0], false);
            if (c != null) {
                if (params.length > 1) {
                    c.partNick(nick, params[1]);
                } else {
                    c.partNick(nick, "");
                }
                if (nick.equals(this.getNick())) {
                    this._listeners.sendEvent("sourceRemoved", c, this);
                    this.deleteChannel(c.getName());
                }
            }
        } else if (command.equals("kick")) {
            Channel c = this.getChannel(params[0], false);
            if (c != null) {
                String target = params[1];
                String reason = "";
                if (params.length > 2) {
                    reason = params[2];
                }
                c.kickNick(target, nick, reason);
                if (target.equals(this.getNick()) && this._ircConfiguration.getB("autorejoin")) {
                    c.report("Attempting to rejoin room " + c.getName() + "...");
                    this.execute("join " + params[0]);
                }
            }
        } else if (command.equals("topic")) {
            Channel c = this.getChannel(params[0], false);
            if (c != null) {
                c.setTopic(params[1], nick);
            }
        } else if (command.equals("mode")) {
            String full = "";
            for (int i = 1; i < params.length; ++i) {
                full = full + params[i] + " ";
            }
            if (this.isChannel(params[0])) {
                Channel c = this.getChannel(params[0], false);
                if (c != null) {
                    MultiModeHandler h = new MultiModeHandler(full, this._globalModes, this._nickModes);
                    while (!h.terminated()) {
                        h.next();
                        if (h.isPrefix() || h.isModeA()) {
                            c.applyUserMode(h.getParameter(), h.getMode(), nick);
                            continue;
                        }
                        if (h.hasParameter()) {
                            c.applyMode(h.getMode() + " " + h.getParameter(), nick);
                            continue;
                        }
                        c.applyMode(h.getMode(), nick);
                    }
                }
            } else if (nick.equals(this.getNick())) {
                this._mode.apply(full);
                if (this._status != null) {
                    this._status.modeChanged(this.getMode());
                }
            }
        } else if (command.equals("nick")) {
            if (nick.equals(this.getNick())) {
                this._nick = params[0];
                if (this._status != null) {
                    this._status.nickChanged(this.getNick());
                }
            }
            this.globalNickChange(nick, params[0]);
        } else if (command.equals("quit")) {
            if (params.length > 0) {
                this.globalNickRemove(nick, params[0]);
            } else {
                this.globalNickRemove(nick, "");
            }
        } else if (command.equals("ping")) {
            this.execute("pong :" + params[0]);
        } else if (command.equals("invite")) {
            String invited = params[0];
            String channel = params[1];
            if (invited.equals(this.getNick()) && this._defaultSource != null) {
                this._defaultSource.report("\u00033      *** " + nick + " has invited you to join " + channel + ". Type /join " + channel + " to accept this invitation.");
            }
        } else if (command.equals("error")) {
            // empty if block
        }
    }

    public String getNick() {
        return this._nick;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getMode() {
        return this._mode.getMode();
    }

    public void say(String destination, String str) {
        this.execute("PRIVMSG " + destination + " :" + str);
    }

    public void execute(String str) {
        String cmd;
        int pos = str.indexOf(32);
        if (pos >= 0) {
            String rem;
            cmd = str.substring(0, pos).toLowerCase(Locale.ENGLISH);
            if (cmd.equals("join")) {
                rem = str.substring(pos + 1);
                if ((pos = rem.indexOf(32)) >= 0) {
                    rem = rem.substring(0, pos);
                }
                if (!this._ircConfiguration.mayJoin(rem)) {
                    return;
                }
            } else if (cmd.equals("part")) {
                rem = str.substring(pos + 1);
                if ((pos = rem.indexOf(32)) >= 0) {
                    rem = rem.substring(0, pos);
                }
                if (!this._ircConfiguration.mayLeave(rem)) {
                    return;
                }
            }
        }
        if ((pos = str.indexOf(32)) > 0) {
            cmd = str.substring(0, pos).toUpperCase(Locale.ENGLISH);
            String param = str.substring(pos + 1);
            str = cmd + " " + param;
        } else {
            str = str.toUpperCase(Locale.ENGLISH);
        }
        this.sendString(str);
    }

    private void sendString(String str) {
        try {
            this._protocol.sendString(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

