/*
 * Decompiled with CFR 0.152.
 */
package irc;

import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class ListHandler {
    private boolean _baseAll;
    private Hashtable _list;
    private String _orig;

    public ListHandler(String list) {
        this._orig = list;
        list = this.convert(list);
        this._baseAll = true;
        this._list = new Hashtable();
        StringTokenizer st = new StringTokenizer(list, "\u0001\u0002", true);
        if (!st.hasMoreTokens()) {
            return;
        }
        String base = st.nextToken();
        if (base.equals("none")) {
            this._baseAll = false;
        }
        while (st.hasMoreTokens()) {
            String mod = st.nextToken();
            if (mod.equals("\u0001")) {
                mod = "-";
            } else if (mod.equals("\u0002")) {
                mod = "+";
            }
            if (!st.hasMoreTokens()) break;
            String token = st.nextToken().toLowerCase(Locale.ENGLISH);
            this._list.put(token, mod);
        }
    }

    private String convert(String txt) {
        String ans = "";
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c == '-') {
                c = '\u0001';
            } else if (c == '+') {
                c = '\u0002';
            } else if (c == '\\' && i != txt.length() - 1) {
                c = txt.charAt(++i);
            }
            ans = ans + c;
        }
        return ans;
    }

    public boolean inList(String item) {
        String mod = (String)this._list.get(item = item.toLowerCase(Locale.ENGLISH));
        if (mod == null) {
            return this._baseAll;
        }
        return mod.equals("+");
    }

    public String toString() {
        return this._orig;
    }
}

