/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.StringParser;
import java.util.Vector;

public class ModeHandler {
    private String _mode;
    private Vector _parameters;
    private char[][] _modes;
    private char[] _prefix;

    public ModeHandler(char[][] modes, char[] prefix) {
        this("", modes, prefix);
    }

    public ModeHandler(String mode, char[][] modes, char[] prefix) {
        this._modes = modes;
        this._prefix = prefix;
        this._mode = "";
        this._parameters = new Vector();
        if (mode.startsWith("+")) {
            mode = mode.substring(1);
        }
        this.apply("+" + mode);
    }

    public void reset() {
        this._mode = "";
    }

    public String getPassword() {
        if (this.hasMode('k')) {
            return this.findParameter('k');
        }
        return "";
    }

    public int getLimit() {
        if (this.hasMode('l')) {
            return new Integer(this.findParameter('l'));
        }
        return 0;
    }

    private boolean inside(char[] list, char c) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != c) continue;
            return true;
        }
        return false;
    }

    private String findParameter(char k) {
        int index = this.getParameterIndex(k);
        if (index >= 0) {
            return (String)this._parameters.elementAt(index);
        }
        return "";
    }

    private boolean hasParameter(boolean positive, char c) {
        if (this.inside(this._prefix, c)) {
            return false;
        }
        if (this.inside(this._modes[0], c)) {
            return true;
        }
        if (this.inside(this._modes[1], c)) {
            return true;
        }
        if (this.inside(this._modes[2], c)) {
            return positive;
        }
        return false;
    }

    private int getParameterIndex(char k) {
        if (this._parameters.size() == 0) {
            return -1;
        }
        int index = 0;
        for (int i = 0; i < this._mode.length(); ++i) {
            char c = this._mode.charAt(i);
            if (this.hasParameter(true, c)) {
                if (c == k) {
                    return index;
                }
                if (++index < this._parameters.size()) continue;
                return -1;
            }
            if (c != k) continue;
            return -1;
        }
        return -1;
    }

    private void addMode(char mode, String param) {
        if (this.hasMode(mode)) {
            this.removeMode(mode, param);
        }
        this._mode = this._mode + mode;
        if (this.hasParameter(true, mode)) {
            this._parameters.insertElementAt(param, this._parameters.size());
        }
    }

    private void removeMode(char mode, String param) {
        if (!this.hasMode(mode)) {
            return;
        }
        if (this.hasParameter(true, mode)) {
            this._parameters.removeElementAt(this.getParameterIndex(mode));
        }
        int pos = this._mode.indexOf(mode);
        this._mode = this._mode.substring(0, pos) + this._mode.substring(pos + 1);
    }

    private void applyOne(boolean positive, char mode, String param) {
        if (positive) {
            this.addMode(mode, param);
        } else {
            this.removeMode(mode, param);
        }
    }

    public void apply(String mode) {
        String[] params = new StringParser().parseString(mode);
        boolean positive = true;
        int index = 0;
        for (int i = 0; i < params[0].length(); ++i) {
            char c = params[0].charAt(i);
            if (c == '+') {
                positive = true;
                continue;
            }
            if (c == '-') {
                positive = false;
                continue;
            }
            String param = "";
            if (this.hasParameter(positive, c)) {
                if (++index >= params.length) {
                    return;
                }
                param = params[index];
            }
            this.applyOne(positive, c, param);
        }
    }

    public boolean hasMode(char mode) {
        return this._mode.indexOf(mode) != -1;
    }

    public String getMode() {
        String ans = this._mode;
        for (int i = 0; i < this._parameters.size(); ++i) {
            ans = ans + " " + this._parameters.elementAt(i);
        }
        return ans;
    }
}

