/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.StringParser;

public class MultiModeHandler {
    private String[] _parameters;
    private char[][] _modes;
    private char[] _prefix;
    private int _paramIndex;
    private int _codeIndex;
    private boolean _positive;
    private String _currentMode;
    private char _currentModeChar;
    private boolean _currentHasParameter;
    private String _currentParameter;
    private boolean _currentPrefix;

    public MultiModeHandler(String code, char[][] modes, char[] prefix) {
        this._modes = modes;
        this._prefix = prefix;
        this._parameters = new StringParser().parseString(code);
        this._paramIndex = 1;
        this._codeIndex = 0;
        this._positive = true;
    }

    public boolean terminated() {
        return this._codeIndex == this._parameters[0].length();
    }

    public void next() {
        char c;
        if (this.terminated()) {
            return;
        }
        if ((c = this._parameters[0].charAt(this._codeIndex++)) == '-') {
            this._positive = false;
            this.next();
            return;
        }
        if (c == '+') {
            this._positive = true;
            this.next();
            return;
        }
        this._currentMode = "-";
        if (this._positive) {
            this._currentMode = "+";
        }
        this._currentMode = this._currentMode + c;
        this._currentModeChar = c;
        if (this.hasParameter(this._positive, c) && this._paramIndex < this._parameters.length) {
            this._currentHasParameter = true;
            this._currentParameter = this._parameters[this._paramIndex++];
        } else {
            this._currentHasParameter = false;
            this._currentParameter = "";
        }
        this._currentPrefix = this.inside(this._prefix, c);
    }

    private boolean inside(char[] list, char c) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != c) continue;
            return true;
        }
        return false;
    }

    public String getMode() {
        return this._currentMode;
    }

    public boolean hasParameter() {
        return this._currentHasParameter;
    }

    public String getParameter() {
        return this._currentParameter;
    }

    public boolean isPrefix() {
        return this._currentPrefix;
    }

    public boolean isModeA() {
        return this.inside(this._modes[0], this._currentModeChar);
    }

    private boolean hasParameter(boolean positive, char c) {
        if (this.inside(this._prefix, c)) {
            return true;
        }
        if (this.inside(this._modes[0], c)) {
            return true;
        }
        if (this.inside(this._modes[1], c)) {
            return true;
        }
        if (this.inside(this._modes[2], c)) {
            return positive;
        }
        return false;
    }
}

