/*
 * Decompiled with CFR 0.152.
 */
package irc;

import java.io.IOException;
import java.io.InputStream;

class MyPushbackStream
extends InputStream {
    private InputStream _is;
    private int _back;
    private boolean _closed;

    public MyPushbackStream(InputStream is) {
        this._is = is;
        this._back = -1;
        this._closed = false;
    }

    public void close() throws IOException {
        this._is.close();
        this._back = -1;
        this._closed = true;
    }

    public int read() throws IOException {
        if (this._back != -1) {
            int res = this._back;
            this._back = -1;
            return res;
        }
        return this._is.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        if (this._back != -1) {
            b[offset] = (byte)this._back;
            this._back = -1;
            return 1;
        }
        return this._is.read(b, offset, length);
    }

    public int available() throws IOException {
        if (this._back != -1) {
            return 1 + this._is.available();
        }
        return this._is.available();
    }

    public void unread(byte b) {
        if (this._closed) {
            return;
        }
        this._back = b;
    }
}

