/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCServer;
import irc.IRCSource;
import irc.ListenerGroup;
import irc.QueryInterpretor;
import irc.QueryListener;
import irc.ReplyServerListener;
import java.util.Locale;

public class Query
extends IRCSource
implements ReplyServerListener {
    private String _nick;
    private String _whois;
    private ListenerGroup _listeners;

    public Query(IRCConfiguration config, String nick, IRCServer s) {
        super(config, s);
        s.addReplyServerListener(this);
        this._listeners = new ListenerGroup();
        this._nick = nick;
        this._whois = "";
        if (this._ircConfiguration.getASLMaster()) {
            this.getIRCServer().execute("WHOIS " + this._nick);
        }
        this.setInterpretor(new QueryInterpretor(config));
    }

    public void release() {
        ((IRCServer)this._server).removeReplyServerListener(this);
        super.release();
    }

    public void addQueryListener(QueryListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeQueryListeners(QueryListener lis) {
        this._listeners.removeListener(lis);
    }

    public String getType() {
        return "Query";
    }

    public String getName() {
        return this._nick;
    }

    public String getWhois() {
        return this._whois;
    }

    public boolean talkable() {
        return true;
    }

    public void leave() {
        this.getIRCServer().leaveQuery(this.getName());
    }

    public void changeNick(String newNick) {
        this._nick = newNick;
        this._listeners.sendEvent("nickChanged", newNick, this);
    }

    public Boolean replyReceived(String prefix, String id, String[] params, IRCServer server) {
        if (id.equals("311") && params[1].toLowerCase(Locale.ENGLISH).equals(this._nick.toLowerCase(Locale.ENGLISH))) {
            String name;
            this._whois = name = params[params.length - 1];
            this._listeners.sendEvent("whoisChanged", this._whois, this);
        }
        return Boolean.FALSE;
    }
}

