/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.Interpretor;
import irc.NotEnoughParametersException;
import irc.Server;
import irc.Source;
import irc.StringParser;
import java.util.Locale;

public abstract class RootInterpretor
extends IRCObject
implements Interpretor {
    protected StringParser _parser;
    protected Interpretor _next;

    public RootInterpretor(IRCConfiguration config) {
        this(config, null);
    }

    public RootInterpretor(IRCConfiguration config, Interpretor next) {
        super(config);
        this.setNextInterpretor(next);
        this._parser = new StringParser();
    }

    public void setNextInterpretor(Interpretor next) {
        this._next = next;
    }

    public Interpretor getNextInterpretor() {
        return this._next;
    }

    public boolean isInside(Interpretor in) {
        while (in != null) {
            if (in == this) {
                return true;
            }
            in = in.getNextInterpretor();
        }
        return false;
    }

    public void addLast(Interpretor in) {
        if (this.isInside(in)) {
            return;
        }
        Interpretor c = this;
        while (c.getNextInterpretor() != null) {
            c = c.getNextInterpretor();
        }
        c.setNextInterpretor(in);
    }

    protected void test(String cmd, String[] parts, int params) throws NotEnoughParametersException {
        if (parts.length <= params) {
            throw new NotEnoughParametersException(cmd);
        }
    }

    protected void handleCommand(Source source, String cmd, String[] parts, String[] cumul) {
        if (this._next == null) {
            Server server = source.getServer();
            if (server.isConnected()) {
                server.execute(cumul[0]);
            } else {
                source.report("\u00032  You are currently not connected...");
            }
        } else {
            this._next.sendString(source, "/" + cumul[0]);
        }
    }

    public void sendString(Source source, String str) {
        if (str.length() == 0) {
            return;
        }
        if (str.startsWith("/")) {
            int i;
            str = str.substring(1);
            String[] parts = this._parser.parseString(str);
            String[] cumul = new String[parts.length];
            for (i = 0; i < cumul.length; ++i) {
                cumul[i] = "";
                for (int j = i; j < parts.length; ++j) {
                    int n = i;
                    cumul[n] = cumul[n] + parts[j] + " ";
                }
                cumul[i] = StringParser.trim(cumul[i]);
            }
            for (i = 0; i < parts.length; ++i) {
                if (parts[i].startsWith("\"") && parts[i].endsWith("\"")) {
                    parts[i] = parts[i].substring(1, parts[i].length() - 1);
                    continue;
                }
                if (!parts[i].startsWith("'") || !parts[i].endsWith("'")) continue;
                parts[i] = parts[i].substring(1, parts[i].length() - 1);
            }
            String cmd = parts[0];
            this.handleCommand(source, cmd.toLowerCase(Locale.ENGLISH), parts, cumul);
        } else {
            this.say(source, str);
        }
    }

    protected void say(Source source, String str) {
        Server server = source.getServer();
        if (source.talkable()) {
            source.messageReceived(server.getNick(), str);
            server.say(source.getName(), str);
        }
    }
}

