/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.CodingHandler;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.IRCObject;
import irc.ListenerGroup;
import irc.ServerProtocolListener;
import irc.StringParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.Socket;
import java.util.Vector;

public class ServerProtocol
extends IRCObject
implements Runnable {
    private ListenerGroup _listeners = new ListenerGroup();
    private String _host;
    private int _port;
    private Socket _socket;
    private CodingHandler _handler;
    private Thread _thread;
    private boolean _connected = false;
    private boolean _connecting = false;

    public ServerProtocol(IRCConfiguration config) {
        super(config);
    }

    public void connect(String host, int port) {
        if (this._connected) {
            this.disconnect();
        }
        this._connecting = true;
        this._host = host;
        this._port = port;
        this._thread = new Thread((Runnable)this, "Read thread");
        this._thread.start();
    }

    public boolean connected() {
        return this._connected;
    }

    public boolean connecting() {
        return this._connecting;
    }

    public synchronized void disconnect() {
        if (!this._connected) {
            return;
        }
        if (this._connecting) {
            return;
        }
        try {
            this._socket.close();
            this._handler.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._connected = false;
        this._listeners.sendEvent("disconnected", this._host);
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    private void decodeLine(String line) {
        Vector<String> res = new Vector<String>();
        while (line.length() != 0) {
            if (line.startsWith(":") && res.size() != 0) {
                res.insertElementAt(line.substring(1), res.size());
                line = "";
                continue;
            }
            int pos = line.indexOf(32);
            if (pos == -1) {
                res.insertElementAt(StringParser.trim(line), res.size());
                line = "";
                continue;
            }
            String part = StringParser.trim(line.substring(0, pos));
            line = StringParser.trim(line.substring(pos + 1));
            res.insertElementAt(part, res.size());
        }
        if (res.size() == 0) {
            return;
        }
        String source = "";
        if (((String)res.elementAt(0)).startsWith(":")) {
            source = (String)res.elementAt(0);
            source = source.substring(1);
            res.removeElementAt(0);
        }
        if (res.size() == 0) {
            return;
        }
        String cmd = (String)res.elementAt(0);
        res.removeElementAt(0);
        String[] param = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            param[i] = (String)res.elementAt(i);
        }
        if (cmd.charAt(0) >= '0' && cmd.charAt(0) <= '9') {
            this._listeners.sendEventAsync("replyReceived", source, cmd, param);
        } else {
            this._listeners.sendEventAsync("messageReceived", source, cmd, param);
        }
    }

    public void run() {
        try {
            this._socket = this._ircConfiguration.getSecurityProvider().getSocket(this._host, this._port);
            this._handler = new CodingHandler(this._ircConfiguration, new BufferedInputStream(this._socket.getInputStream()), new BufferedOutputStream(this._socket.getOutputStream()));
            this._connected = true;
            this._connecting = false;
            this._listeners.sendEventAsync("connected", this._host);
        }
        catch (Exception e) {
            this._connecting = false;
            if (e.getMessage() != null) {
                this._listeners.sendEventAsync("connectionFailed", e.getMessage(), this._host);
            } else {
                this._listeners.sendEventAsync("connectionFailed", e.getClass().getName(), this._host);
            }
            return;
        }
        boolean terminated = false;
        while (!terminated) {
            try {
                String line = this._handler.read();
                if (line == null) {
                    throw new Exception();
                }
                try {
                    if (line == null) continue;
                    this.decodeLine(line);
                }
                catch (Exception e) {
                    this._ircConfiguration.internalError("Internal Error", e, "chat@frostwire.com");
                }
            }
            catch (Exception e) {
                terminated = true;
            }
        }
        EventDispatcher.dispatchEventAsync(this, "disconnect", new Object[0]);
    }

    public void addServerProtocolListener(ServerProtocolListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeServerProtocolListener(ServerProtocolListener lis) {
        this._listeners.removeListener(lis);
    }

    public void sendString(String str) throws Exception {
        if (!this.connected()) {
            throw new Exception("\u00032  You are currently not connected...");
        }
        this._handler.write(str);
    }

    public void sendCommand(String command, String[] params) throws Exception {
        String toSend = command;
        for (int i = 0; i < params.length; ++i) {
            toSend = toSend + " ";
            if (params[i].indexOf(32) != -1) {
                toSend = toSend + ":";
            }
            toSend = toSend + params[i];
        }
        this.sendString(toSend);
    }
}

