/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.Interpretor;
import irc.ListenerGroup;
import irc.NullInterpretor;
import irc.Server;
import irc.SourceListener;
import java.util.Locale;

public abstract class Source
extends IRCObject {
    protected Server _server;
    private ListenerGroup _listeners = new ListenerGroup();
    protected Interpretor _in;

    public Source(IRCConfiguration config, Server s) {
        super(config);
        this._in = new NullInterpretor(config);
        this._server = s;
    }

    public void release() {
        this._in = new NullInterpretor(this._ircConfiguration);
        super.release();
    }

    public abstract String getName();

    public abstract String getType();

    public abstract boolean talkable();

    public abstract void leave();

    public void setInterpretor(Interpretor in) {
        this._in = in;
    }

    public void sendString(String str) {
        this._in.sendString(this, str);
    }

    public void sendUserString(String str) {
        if (!str.startsWith("/")) {
            this.sendString(str);
        } else {
            String cmd = str.substring(1).trim();
            int pos = cmd.indexOf(32);
            if (pos >= 0) {
                cmd = cmd.substring(0, pos);
            }
            if (this._ircConfiguration.mayCommand(cmd)) {
                this.sendString(str);
            }
        }
    }

    public Interpretor getInterpretor() {
        return this._in;
    }

    public void clear() {
        this._listeners.sendEvent("clear", this);
    }

    public void messageReceived(String source, String msg) {
        if (msg.startsWith("\u0001")) {
            msg = msg.substring(1);
            msg = msg.substring(0, msg.length() - 1);
            String cmd = "";
            String param = "";
            int pos = msg.indexOf(32);
            if (pos == -1) {
                cmd = msg.toLowerCase(Locale.ENGLISH);
            } else {
                cmd = msg.substring(0, pos).toLowerCase(Locale.ENGLISH);
                param = msg.substring(pos + 1);
            }
            if (cmd.equals("action")) {
                this.action(source, param);
            } else {
                this.getServer().sendStatusMessage("\u0002\u00034[" + source + " " + cmd.toUpperCase(Locale.ENGLISH) + "]");
            }
        } else {
            this._listeners.sendEvent("messageReceived", source, msg, this);
        }
    }

    public void noticeReceived(String source, String msg) {
        this._listeners.sendEvent("noticeReceived", source, msg, this);
    }

    public void action(String nick, String msg) {
        this._listeners.sendEvent("action", nick, msg, this);
    }

    public void report(String msg) {
        this._listeners.sendEvent("reportReceived", msg, this);
    }

    public void addSourceListener(SourceListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeSourceListener(SourceListener lis) {
        this._listeners.removeListener(lis);
    }

    public Server getServer() {
        return this._server;
    }

    public boolean isConnected() {
        return this.getServer().isConnected();
    }

    public boolean mayDefault() {
        return true;
    }
}

