/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCServer;
import irc.IRCSource;
import irc.ListenerGroup;
import irc.ReplyServerListener;
import irc.StatusInterpretor;
import irc.StatusListener;

public class Status
extends IRCSource
implements ReplyServerListener {
    private ListenerGroup _listeners;

    public Status(IRCConfiguration config, IRCServer s) {
        super(config, s);
        s.addReplyServerListener(this);
        this._listeners = new ListenerGroup();
        this.setInterpretor(new StatusInterpretor(config));
    }

    public void release() {
        ((IRCServer)this._server).removeReplyServerListener(this);
        super.release();
    }

    public String getType() {
        return "Status";
    }

    public String getName() {
        return this.getServerName();
    }

    public String getServerName() {
        return this.getIRCServer().getServerName();
    }

    public boolean talkable() {
        return false;
    }

    public void leave() {
        if (!this._ircConfiguration.getB("multiserver")) {
            return;
        }
        this.getIRCServer().leaveStatus(this.getName());
    }

    public String getNick() {
        return this._server.getNick();
    }

    public String getMode() {
        return this.getIRCServer().getMode();
    }

    public void addStatusListener(StatusListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeStatusListener(StatusListener lis) {
        this._listeners.removeListener(lis);
    }

    public void nickChanged(String nick) {
        this._listeners.sendEvent("nickChanged", nick, this);
    }

    public void modeChanged(String mode) {
        this._listeners.sendEvent("modeChanged", mode, this);
    }

    public void invited(String channel, String who) {
        this._listeners.sendEvent("invited", channel, who, this);
    }

    public Boolean replyReceived(String prefix, String id, String[] params, IRCServer server) {
        int i;
        if (id.equals("322")) {
            return Boolean.FALSE;
        }
        if (this._ircConfiguration.getB("useinfo") && (i = new Integer(id).intValue()) >= 300 && i != 372) {
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }
}

