/*
 * Decompiled with CFR 0.152.
 */
package irc.dcc;

import irc.IRCConfiguration;
import irc.ListenerGroup;
import irc.Source;
import irc.dcc.DCCFileListener;
import irc.dcc.prv.DCCFileHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DCCFile
extends Source {
    private OutputStream _os;
    private InputStream _is;
    private File _file;
    private ListenerGroup _listeners = new ListenerGroup();
    private boolean _down = false;
    private int _size;
    private int _count;
    private DCCFileHandler _handler;

    public DCCFile(IRCConfiguration config, File f, DCCFileHandler handler) {
        super(config, handler);
        this._handler = handler;
        this._count = 0;
        this._file = f;
    }

    public void addDCCFileListener(DCCFileListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeDCCFileListener(DCCFileListener lis) {
        this._listeners.removeListener(lis);
    }

    public void prepareSend() {
        try {
            this._size = this._ircConfiguration.getSecurityProvider().getFileSize(this._file);
            this._is = new BufferedInputStream(this._ircConfiguration.getSecurityProvider().getFileInputStream(this._file));
            this._down = false;
        }
        catch (Exception e) {
            this._ircConfiguration.internalError("prepareSend failure", e, "bugs@frostwire.com");
        }
    }

    public int readBytes(byte[] buffer, int offset, int length) throws IOException {
        int actual = this._is.read(buffer, offset, length);
        if (actual >= 0) {
            this._count += actual;
            this._listeners.sendEventAsync("transmitted", new Integer(this._count), this);
        }
        return actual;
    }

    public int getSize() {
        return this._size;
    }

    public boolean isUploading() {
        return !this.isDownloading();
    }

    public boolean isDownloading() {
        return this._down;
    }

    public void fileSent() {
        try {
            this._listeners.sendEventAsync("finished", this);
            this._is.close();
        }
        catch (Exception e) {
            this._ircConfiguration.internalError("fileSent failure", e, "bugs@frostwire.com");
        }
    }

    public void fileSentFailed() {
        try {
            this._listeners.sendEventAsync("failed", this);
            this._is.close();
        }
        catch (Exception e) {
            this._ircConfiguration.internalError("fileSentFailed failure", e, "bugs@frostwire.com");
        }
    }

    public void prepareReceive(int size) {
        this._down = true;
        this._size = size;
        try {
            this._os = new BufferedOutputStream(this._ircConfiguration.getSecurityProvider().getFileOutputStream(this._file));
        }
        catch (Exception e) {
            this._os = null;
        }
    }

    public void bytesReceived(byte[] buffer, int offset, int length) throws IOException {
        this._count += length;
        this._os.write(buffer, offset, length);
        this._listeners.sendEventAsync("transmitted", new Integer(this._count), this);
    }

    public void fileReceived() {
        try {
            this._listeners.sendEventAsync("finished", this);
            this._os.close();
        }
        catch (Exception e) {
            this._ircConfiguration.internalError("fileReceived failure", e, "bugs@frostwire.com");
        }
    }

    public void fileReceiveFailed() {
        try {
            this._listeners.sendEventAsync("failed", this);
            this._os.close();
        }
        catch (Exception e) {
            this._ircConfiguration.internalError("fileReceiveFailed failure", e, "bugs@frostwire.com");
        }
    }

    public String getName() {
        return this._file.getName();
    }

    public void leave() {
        this._handler.close();
        this._handler.leave();
    }

    public boolean talkable() {
        return false;
    }

    public String getType() {
        return "DCCFile";
    }
}

