/*
 * Decompiled with CFR 0.152.
 */
package irc.dcc.prv;

import irc.CodingHandler;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.IRCObject;
import irc.ListenerGroup;
import irc.Server;
import irc.ServerListener;
import irc.Source;
import irc.dcc.DCCChat;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class DCCChatServer
extends IRCObject
implements Runnable,
Server {
    private Socket _socket;
    private ServerSocket _serverSocket;
    private CodingHandler _handler;
    private Thread _thread;
    private DCCChat _chat;
    private String _remoteNick;
    private String _thisNick;
    private ListenerGroup _listeners = new ListenerGroup();
    private boolean _listening;
    private int _action = 0;
    private boolean _connected;

    public DCCChatServer(IRCConfiguration config, String thisNick, String remoteNick) {
        super(config);
        this._remoteNick = remoteNick;
        this._thisNick = thisNick;
        this._connected = false;
        this._chat = new DCCChat(this._ircConfiguration, this, this._remoteNick);
    }

    public void addServerListener(ServerListener l) {
        this._listeners.addListener(l);
    }

    public void removeServerListener(ServerListener l) {
        this._listeners.removeListener(l);
    }

    public void connect() {
    }

    public void disconnect() {
        this.close();
    }

    public boolean isConnected() {
        return this._connected;
    }

    public Enumeration getSources() {
        Vector<DCCChat> v = new Vector<DCCChat>();
        if (this._chat != null) {
            v.insertElementAt(this._chat, 0);
        }
        return v.elements();
    }

    public void enumerateSourcesAsCreated(ServerListener lis) {
        if (this._chat != null) {
            lis.sourceCreated(this._chat, this, new Boolean(this._action == 2));
        }
    }

    public void enumerateSourcesAsRemoved(ServerListener lis) {
        if (this._chat != null) {
            lis.sourceRemoved(this._chat, this);
        }
    }

    public void setDefaultSource(Source s) {
    }

    public void release() {
        this.cleanup();
        this._chat = null;
        super.release();
    }

    public void openActive(String ip, String port) {
        this._serverSocket = null;
        this._action = 1;
        long iip = new Long(ip);
        int b1 = (int)(iip & 0xFFL);
        int b2 = (int)(iip >> 8 & 0xFFL);
        int b3 = (int)(iip >> 16 & 0xFFL);
        int b4 = (int)(iip >> 24 & 0xFFL);
        ip = b4 + "." + b3 + "." + b2 + "." + b1;
        try {
            this._socket = this._ircConfiguration.getSecurityProvider().getSocket(ip, new Integer(port));
            this._handler = new CodingHandler(this._ircConfiguration, this._socket.getInputStream(), this._socket.getOutputStream());
            this._thread = new Thread((Runnable)this, "DCCChat thread");
            this._thread.start();
        }
        catch (Exception e) {
            this._ircConfiguration.internalError("openActive failure", e, "bugs@frostwire.com");
        }
    }

    public String openPassive() {
        this._action = 2;
        this._socket = null;
        try {
            int b4;
            int b3;
            int b2;
            this._serverSocket = this._ircConfiguration.getSecurityProvider().getServerSocket(0);
            int port = this._serverSocket.getLocalPort();
            InetAddress addr = this._ircConfiguration.getSecurityProvider().getLocalHost();
            byte[] ip = addr.getAddress();
            int b1 = ip[0];
            if (b1 < 0) {
                b1 += 256;
            }
            if ((b2 = ip[1]) < 0) {
                b2 += 256;
            }
            if ((b3 = ip[2]) < 0) {
                b3 += 256;
            }
            if ((b4 = ip[3]) < 0) {
                b4 += 256;
            }
            long high = (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
            String sip = "" + high;
            this._listening = false;
            this._thread = new Thread((Runnable)this, "DCCChat thread");
            this._thread.start();
            while (!this._listening) {
                Thread.yield();
            }
            return sip + " " + port;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void reportChat(String str) {
        EventDispatcher.dispatchEventAsync(this._chat, "report", new Object[]{str});
    }

    private void messageChat(String src, String str) {
        EventDispatcher.dispatchEventAsync(this._chat, "messageReceived", new Object[]{src, str});
    }

    public void run() {
        boolean terminated = false;
        if (this._action == 2) {
            try {
                this._listening = true;
                this.reportChat(this.getText(257));
                this._serverSocket.setSoTimeout(30000);
                this._socket = this._serverSocket.accept();
                this._handler = new CodingHandler(this._ircConfiguration, this._socket.getInputStream(), this._socket.getOutputStream());
            }
            catch (Exception e) {
                this.reportChat(this.getText(258, e.getMessage()));
                return;
            }
        }
        this.reportChat(this.getText(259));
        this._connected = true;
        this._listeners.sendEventAsync("serverConnected", this);
        while (!terminated) {
            try {
                String line = this._handler.read();
                if (line == null) {
                    throw new Exception(this.getText(260));
                }
                try {
                    this.messageChat(this._remoteNick, line);
                }
                catch (Exception e) {
                    this._ircConfiguration.internalError("internal error", e, "bugs@frostwire.com");
                }
            }
            catch (Exception e) {
                terminated = true;
                this.reportChat(this.getText(261, e.getMessage()));
            }
        }
        this._connected = false;
        this._listeners.sendEventAsync("serverDisconnected", this);
        this.cleanup();
    }

    public void say(String destination, String str) {
        if (destination.equals(this._remoteNick)) {
            this.sendString(str);
        } else {
            this._chat.report(this.getText(261, this.getText(262, destination)));
        }
    }

    public void execute(String str) {
        this._chat.report(this.getText(263));
    }

    private void sendString(String str) {
        try {
            if (this._handler == null || !this._connected) {
                throw new Exception(this.getText(264));
            }
            this._handler.write(str);
        }
        catch (Exception e) {
            this._chat.report(this.getText(261, e.getMessage()));
        }
    }

    public void sendStatusMessage(String str) {
        if (this._chat != null) {
            this._chat.report(str);
        }
    }

    private void cleanup() {
        try {
            if (this._socket != null) {
                this._socket.close();
            }
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
            this._handler.close();
        }
        catch (Exception e) {
            this._ircConfiguration.internalError("cleanup failure", e, "bugs@frostwire.com");
        }
    }

    public void close() {
        this.cleanup();
    }

    public void leave() {
        this.disconnect();
        long time = System.currentTimeMillis();
        while (this.isConnected()) {
            try {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - time <= 10000L) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this._listeners.sendEvent("sourceRemoved", this._chat, this);
        this._listeners.sendEvent("serverLeft", this);
        this._chat.release();
    }

    public String getNick() {
        return this._thisNick;
    }

    public String getUserName() {
        return "";
    }

    public String getServerName() {
        return this.getNick();
    }
}

