/*
 * Decompiled with CFR 0.152.
 */
package irc.dcc.prv;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.ListenerGroup;
import irc.Server;
import irc.ServerListener;
import irc.Source;
import irc.dcc.DCCFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class DCCFileHandler
extends IRCObject
implements Server,
Runnable {
    private Socket _socket;
    private ServerSocket _serverSocket;
    private Thread _thread;
    private OutputStream _os;
    private InputStream _is;
    private DCCFile _file;
    private int _action = 0;
    private int _size = 0;
    private boolean _listening;
    private boolean _connected = false;
    private ListenerGroup _listeners;

    public DCCFileHandler(IRCConfiguration config, String remoteNick, File f) {
        super(config);
        this._file = new DCCFile(config, f, this);
        this._listeners = new ListenerGroup();
    }

    public void release() {
        this.cleanup();
        this._file = null;
        super.release();
    }

    public void receive(String ip, String port, String size) {
        this._size = new Integer(size);
        this._file.prepareReceive(this._size);
        this._serverSocket = null;
        this._action = 1;
        long iip = new Long(ip);
        int b1 = (int)(iip & 0xFFL);
        int b2 = (int)(iip >> 8 & 0xFFL);
        int b3 = (int)(iip >> 16 & 0xFFL);
        int b4 = (int)(iip >> 24 & 0xFFL);
        ip = b4 + "." + b3 + "." + b2 + "." + b1;
        try {
            this._socket = this._ircConfiguration.getSecurityProvider().getSocket(ip, new Integer(port));
            this._is = new BufferedInputStream(this._socket.getInputStream());
            this._os = new BufferedOutputStream(this._socket.getOutputStream());
            this._thread = new Thread((Runnable)this, "DCCFile thread");
            this._thread.start();
        }
        catch (Exception e) {
            this._ircConfiguration.internalError("receive failure", e, "bugs@frostwire.com");
        }
    }

    public String send() {
        this._action = 2;
        this._socket = null;
        try {
            int b4;
            int b3;
            int b2;
            this._serverSocket = this._ircConfiguration.getSecurityProvider().getServerSocket(0);
            int port = this._serverSocket.getLocalPort();
            InetAddress addr = this._ircConfiguration.getSecurityProvider().getLocalHost();
            byte[] ip = addr.getAddress();
            int b1 = ip[0];
            if (b1 < 0) {
                b1 += 256;
            }
            if ((b2 = ip[1]) < 0) {
                b2 += 256;
            }
            if ((b3 = ip[2]) < 0) {
                b3 += 256;
            }
            if ((b4 = ip[3]) < 0) {
                b4 += 256;
            }
            long high = (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
            this._file.prepareSend();
            int size = this._file.getSize();
            String sip = "" + high;
            this._listening = false;
            this._thread = new Thread((Runnable)this, "DCCFile thread");
            this._thread.start();
            while (!this._listening) {
                Thread.yield();
            }
            return sip + " " + port + " " + size;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void writeConf(OutputStream os, int v) throws IOException {
        os.write(v >> 24 & 0xFF);
        os.write(v >> 16 & 0xFF);
        os.write(v >> 8 & 0xFF);
        os.write(v & 0xFF);
        os.flush();
    }

    private int readConf(InputStream is) throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = is.read();
        if (b1 < 0) {
            b1 += 256;
        }
        if ((b2 = is.read()) < 0) {
            b2 += 256;
        }
        if ((b3 = is.read()) < 0) {
            b3 += 256;
        }
        if ((b4 = is.read()) < 0) {
            b4 += 256;
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    private void connected() {
        this._connected = true;
        this._listeners.sendEventAsync("serverConnected", this);
    }

    private void disconnected() {
        this._connected = false;
        this._listeners.sendEventAsync("serverDisconnected", this);
    }

    public void run() {
        byte[] buffer = new byte[4096];
        if (this._action == 1) {
            try {
                this.connected();
                int read = 0;
                while (this._size - read > 0) {
                    int r = this._is.read(buffer, 0, buffer.length);
                    if (r == -1) {
                        throw new Exception(this.getText(267));
                    }
                    this._file.bytesReceived(buffer, 0, r);
                    Thread.yield();
                    this.writeConf(this._os, read += r);
                }
                this.writeConf(this._os, this._size);
                this._file.fileReceived();
            }
            catch (Exception e) {
                e.printStackTrace();
                this._file.fileReceiveFailed();
            }
            this.disconnected();
            this.cleanup();
        } else if (this._action == 2) {
            this._listening = true;
            try {
                int size;
                int r;
                this._serverSocket.setSoTimeout(30000);
                this._socket = this._serverSocket.accept();
                this._os = new BufferedOutputStream(this._socket.getOutputStream());
                this._is = new BufferedInputStream(this._socket.getInputStream());
                this.connected();
                int rec = 0;
                for (int toread = size = this._file.getSize(); toread > 0; toread -= r) {
                    r = this._file.readBytes(buffer, 0, buffer.length);
                    if (r < 0) {
                        throw new Exception(this.getText(267));
                    }
                    this._os.write(buffer, 0, r);
                    if (this._is.available() <= 0) continue;
                    rec = this.readConf(this._is);
                }
                this._os.flush();
                while (rec != size) {
                    rec = this.readConf(this._is);
                }
                this._os.close();
                this._file.fileSent();
            }
            catch (Exception e) {
                e.printStackTrace();
                this._file.fileSentFailed();
            }
            this.disconnected();
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            if (this._socket != null) {
                this._socket.close();
            }
            if (this._serverSocket != null) {
                this._serverSocket.close();
            }
            this._is.close();
            this._os.close();
        }
        catch (Exception e) {
            this._ircConfiguration.internalError("cleanup failure", e, "bugs@frostwire.com");
        }
    }

    public void close() {
        this.cleanup();
    }

    public void say(String destination, String str) {
    }

    public void execute(String str) {
    }

    public void sendStatusMessage(String str) {
    }

    public String getNick() {
        return "";
    }

    public String getUserName() {
        return "";
    }

    public void connect() {
    }

    public void disconnect() {
        this.close();
    }

    public boolean isConnected() {
        return this._connected;
    }

    public Enumeration getSources() {
        Vector<DCCFile> v = new Vector<DCCFile>();
        if (this._file != null) {
            v.insertElementAt(this._file, v.size());
        }
        return v.elements();
    }

    public void enumerateSourcesAsCreated(ServerListener l) {
        if (this._file != null) {
            l.sourceCreated(this._file, this, new Boolean(true));
        }
    }

    public void enumerateSourcesAsRemoved(ServerListener l) {
        if (this._file != null) {
            l.sourceRemoved(this._file, this);
        }
    }

    public void setDefaultSource(Source source) {
    }

    public void addServerListener(ServerListener l) {
        this._listeners.addListener(l);
    }

    public void removeServerListener(ServerListener l) {
        this._listeners.removeListener(l);
    }

    public void leave() {
        this.disconnect();
        long time = System.currentTimeMillis();
        while (this.isConnected()) {
            try {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - time <= 10000L) continue;
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this._listeners.sendEvent("sourceRemoved", this._file, this);
        this._listeners.sendEvent("serverLeft", this);
        this._file.release();
    }

    public String getServerName() {
        return this.getNick();
    }
}

