/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.common;

import irc.EventDispatcher;
import irc.ListenerGroup;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Vector;

public class AWTIrcTextField
extends Container
implements ActionListener,
KeyListener,
FocusListener {
    private int _index;
    private int _tabCount;
    private String _completing;
    private String[] _completeList;
    private Vector _historic;
    private ListenerGroup _listeners;
    private TextField _field;
    private boolean _useEnterTextHere = false;
    private String _enterTextHere;

    public AWTIrcTextField() {
        this.setLayout(new GridLayout(1, 1));
        this._field = new TextField();
        this.add(this._field);
        this._completeList = new String[0];
        this._field.setFont(new Font("SanSerif", 0, 13));
        this._tabCount = 0;
        this._completing = "";
        this._index = 0;
        this._listeners = new ListenerGroup();
        this._historic = new Vector();
        this._field.addActionListener(this);
        this._field.addKeyListener(this);
        try {
            Class<?> c = this._field.getClass();
            Method m = c.getMethod("setFocusTraversalKeysEnabled", Boolean.TYPE);
            m.invoke((Object)this._field, new Boolean(false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addFocusListener(this);
    }

    public void release() {
        this.removeFocusListener(this);
        this._field.removeActionListener(this);
        this._field.removeKeyListener(this);
        this._historic = new Vector();
        this._field = null;
        this.removeAll();
    }

    public void setEnterTextHere(boolean b, String text) {
        this._useEnterTextHere = b;
        this._enterTextHere = text;
        if (this._useEnterTextHere) {
            this._field.setText(this._enterTextHere);
            this._field.setSelectionStart(0);
            this._field.setSelectionEnd(this._field.getText().length() + 1);
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this._field.setBackground(c);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this._field.setForeground(c);
    }

    public void focusGained(FocusEvent e) {
        this._field.requestFocus();
    }

    public void focusLost(FocusEvent e) {
    }

    public void addActionListener(ActionListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeActionListener(ActionListener lis) {
        this._listeners.removeListener(lis);
    }

    public void setCompleteList(String[] list) {
        this._completeList = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            this._completeList[i] = list[i];
        }
    }

    public void setText(String txt) {
        this._field.setText(txt);
    }

    public String getText() {
        return this._field.getText();
    }

    public int getCaretPosition() {
        return this._field.getCaretPosition();
    }

    public void setCaretPosition(int pos) {
        this._field.setCaretPosition(pos);
    }

    private void type(int c) {
        int selA = this._field.getSelectionStart();
        int selB = this._field.getSelectionEnd();
        String t = this._field.getText();
        if (selA != selB) {
            t = t.substring(0, selA) + t.substring(selB);
            this._field.setCaretPosition(selA);
        }
        int p = this._field.getCaretPosition();
        String before = t.substring(0, p);
        String after = t.substring(p);
        this._field.setText(before + (char)c + after);
        this._field.setCaretPosition(p + 1);
    }

    private void getCompleting() {
        this._completing = "";
        String t = this._field.getText();
        if (this._field.getCaretPosition() == t.length() || t.charAt(this._field.getCaretPosition()) == ' ') {
            for (int i = this._field.getCaretPosition() - 1; i >= 0 && t.charAt(i) != ' '; --i) {
                this._completing = t.charAt(i) + this._completing;
            }
        }
    }

    private void complete() {
        if (this._completing.length() == 0) {
            return;
        }
        String begin = this._completing.toLowerCase(Locale.ENGLISH);
        Vector<String> match = new Vector<String>();
        for (int i = 0; i < this._completeList.length; ++i) {
            if (!this._completeList[i].toLowerCase(Locale.ENGLISH).startsWith(begin)) continue;
            match.insertElementAt(this._completeList[i], match.size());
        }
        if (match.size() > 0) {
            String completeItem = (String)match.elementAt(this._tabCount % match.size());
            int p = this._field.getCaretPosition();
            String t = this._field.getText();
            String before = t.substring(0, p);
            String after = t.substring(p);
            int space = before.lastIndexOf(32);
            before = space == -1 ? "" : before.substring(0, space + 1);
            before = before + completeItem;
            this._field.setText(before + after);
            this._field.setCaretPosition(before.length());
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 9 || e.getKeyCode() == 34) {
            if (this._tabCount == 0) {
                this.getCompleting();
            }
            this.complete();
            ++this._tabCount;
            e.consume();
        } else {
            this._tabCount = 0;
        }
        if (e.getKeyCode() == 38) {
            if (this._historic.size() > 0) {
                --this._index;
                if (this._index == -1) {
                    this._index = 0;
                }
                this._field.setText((String)this._historic.elementAt(this._index));
                this.setCaretPosition(this.getText().length());
            }
            e.consume();
        } else if (e.getKeyCode() == 40) {
            if (this._historic.size() > 0) {
                ++this._index;
                if (this._index > this._historic.size()) {
                    this._index = this._historic.size();
                }
                if (this._index < this._historic.size()) {
                    this._field.setText((String)this._historic.elementAt(this._index));
                } else {
                    this._field.setText("");
                }
                this.setCaretPosition(this.getText().length());
            }
            e.consume();
        } else if (e.getKeyCode() == 75 && e.isControlDown()) {
            this.type(3);
            e.consume();
        } else if (e.getKeyCode() == 66 && e.isControlDown()) {
            this.type(2);
            e.consume();
        } else if (e.getKeyCode() == 85 && e.isControlDown()) {
            this.type(31);
            e.consume();
        } else if (e.getKeyCode() == 82 && e.isControlDown()) {
            this.type(22);
            e.consume();
        } else if (e.getKeyCode() == 79 && e.isControlDown()) {
            this.type(15);
            e.consume();
        } else if (e.getKeyCode() == 87 && e.isControlDown()) {
            this.type(30);
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void validateText() {
        if (this.getText().length() > 0) {
            this._historic.insertElementAt(this.getText(), this._historic.size());
            this._index = this._historic.size();
        }
        this._listeners.sendEvent("actionPerformed", new Object[]{new ActionEvent(this, 0, "validate")});
    }

    public void actionPerformed(ActionEvent e) {
        EventDispatcher.dispatchEventAsync(this, "validateText", new Object[0]);
    }
}

