/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.common;

import irc.EventDispatcher;
import irc.ListenerGroup;
import irc.gui.common.DockablePanelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class DockablePanel
extends Panel
implements WindowListener,
Runnable {
    private Component _comp;
    private boolean _docked;
    private Frame _frame;
    private int _behaviour;
    private ListenerGroup _listeners;
    public static final int DOCK_ON_CLOSE = 0;
    public static final int DO_NOTHING_ON_CLOSE = 1;

    public DockablePanel(Component c, Color col) {
        this.setBackground(col);
        this.setLayout(new BorderLayout());
        this._comp = c;
        this._docked = true;
        this.add(this._comp, "Center");
        this.validate();
        this._frame = new Frame();
        this._frame.setLayout(new BorderLayout());
        this._frame.addWindowListener(this);
        this._behaviour = 0;
        this._listeners = new ListenerGroup();
    }

    public void addDockablePanelListener(DockablePanelListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeDockablePanelListener(DockablePanelListener lis) {
        this._listeners.removeListener(lis);
    }

    public void setClosingBehaviour(int behaviour) {
        this._behaviour = behaviour;
    }

    public int getClosingBehaviour() {
        return this._behaviour;
    }

    public Component getComponent() {
        return this._comp;
    }

    public void undock(String windowTitle) {
        if (this._comp == null) {
            return;
        }
        if (!this._docked) {
            return;
        }
        this._docked = false;
        this._comp.setVisible(true);
        this.remove(this._comp);
        this.validate();
        this._frame.add(this._comp, "Center");
        this._frame.pack();
        this._frame.setTitle(windowTitle);
        this._frame.setVisible(true);
    }

    public void dock() {
        if (this._comp == null) {
            return;
        }
        if (this._docked) {
            return;
        }
        this._docked = true;
        this._comp.setVisible(false);
        this._frame.setVisible(false);
        this._frame.remove(this._comp);
        this.add(this._comp, "Center");
        this._comp.setVisible(this.isVisible());
        this.validate();
    }

    public boolean isDocked() {
        return this._docked;
    }

    public void bring() {
        this._frame.toFront();
    }

    public void run() {
        if (this._frame != null) {
            this._frame.dispose();
        }
        this._frame = null;
    }

    public void release() {
        if (this._frame == null) {
            return;
        }
        this.dock();
        this._frame.removeAll();
        this.removeAll();
        this._frame.removeWindowListener(this);
        Thread t = new Thread((Runnable)this, "Frame disposal thread");
        t.start();
        this._comp = null;
    }

    public void setVisible(boolean b) {
        if (this._comp == null) {
            return;
        }
        if (this._docked) {
            this._comp.setVisible(b);
        }
        super.setVisible(b);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this._listeners.sendEventAsync("DockablePanelWindowClosed", this);
    }

    public void windowClosing(WindowEvent e) {
        this._listeners.sendEventAsync("DockablePanelWindowClosing", this);
        if (this._behaviour == 0) {
            EventDispatcher.dispatchEventAsync(this, "dock", new Object[0]);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

