/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.ChanList;
import irc.ChanListListener;
import irc.ChannelInfo;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxHorizontalScrollBar;
import irc.gui.pixx.PixxScrollBar;
import irc.style.StyledList;
import java.awt.Component;

public class AWTChanList
extends BaseAWTSource
implements ChanListListener {
    protected PixxHorizontalScrollBar _hscroll;

    public AWTChanList(PixxConfiguration config, ChanList list) {
        super(config, list, true);
        list.addChanListListener(this);
        this._hscroll = new PixxHorizontalScrollBar(this._pixxConfiguration, 0, 0, 0.1);
        this._hscroll.addPixxScrollBarListener(this);
        this._list.setWrap(false);
        this.remove(this._textField);
        this.add((Component)this._hscroll, "South");
        this.setTitle("Available Chat Rooms... Double click the chatroom to join it or you can type /join <roomname>.");
        this._list.clear(1024);
    }

    public void release() {
        ((ChanList)this._source).removeChanListListeners(this);
        this._hscroll.removePixxScrollBarListener(this);
        this._hscroll.release();
        this._hscroll = null;
        super.release();
    }

    public String getShortTitle() {
        return "Chat Rooms";
    }

    public void setFieldText(String txt) {
    }

    public String getFieldText() {
        return "";
    }

    public void validateText() {
    }

    public ChanList getChanList() {
        return (ChanList)this.getSource();
    }

    public void channelBegin(ChanList list) {
        this.clear(this.getSource());
        this.print("Retrieving available rooms...");
        this._list.setFirst(0);
    }

    private void sort(ChannelInfo[] info, int begin, int end, int deep) {
        if (deep < 50) {
            if (begin < end) {
                int f = (begin + end) / 2;
                ChannelInfo tmp = info[f];
                info[f] = info[begin];
                info[begin] = tmp;
                int p_pos = begin;
                ChannelInfo pivot = info[p_pos];
                for (int i = begin; i <= end; ++i) {
                    if (info[i].userCount <= pivot.userCount) continue;
                    tmp = info[++p_pos];
                    info[p_pos] = info[i];
                    info[i] = tmp;
                }
                tmp = info[p_pos];
                info[p_pos] = info[begin];
                info[begin] = tmp;
                this.sort(info, begin, p_pos - 1, deep + 1);
                this.sort(info, p_pos + 1, end, deep + 1);
            }
        } else {
            for (int i = begin; i <= end; ++i) {
                ChannelInfo little = info[i];
                int littleindex = i;
                int littleuser = little.userCount;
                for (int j = i + 1; j <= end; ++j) {
                    if (info[j].userCount <= littleuser) continue;
                    little = info[j];
                    littleindex = j;
                    littleuser = little.userCount;
                }
                ChannelInfo tmp = info[i];
                info[i] = info[littleindex];
                info[littleindex] = tmp;
            }
        }
    }

    private void sort(ChannelInfo[] info) {
        this.sort(info, 0, info.length - 1, 0);
    }

    public void channelEnd(ChanList list) {
        ChannelInfo[] info = this.getChanList().getChannels();
        this.sort(info);
        int count = info.length;
        if (count > 1024) {
            count = 1024;
        }
        String[] lines = new String[count];
        for (int i = 0; i < count; ++i) {
            lines[i] = this.format(info[i]);
        }
        this.clear(this.getSource());
        this._list.addLines(lines);
        this._list.setFirst(0);
        this._scroll.setMaximum(this._list.getLineCount() - 1);
        this._scroll.setValue(this._list.getLast());
        this._hscroll.setMaximum(this._list.getLogicalWidth() / 10);
    }

    private String format(ChannelInfo item) {
        int i;
        String msg = item.name;
        String count = "" + item.userCount;
        for (i = 0; i < 20 - item.name.length(); ++i) {
            msg = msg + " ";
        }
        msg = msg + "   " + item.userCount;
        for (i = 0; i < 5 - count.length(); ++i) {
            msg = msg + " ";
        }
        msg = msg + "   " + item.topic;
        return msg;
    }

    public void channelAdded(ChannelInfo item, ChanList list) {
        int count = this.getChanList().getChannelCount();
        int total = this.getChanList().getIgnoredChannelCount() + count;
        if (total % 100 == 0) {
            this.clear(this.getSource());
            this.print("Retrieving available rooms... (" + count + "/" + total + ")");
            this._list.setFirst(0);
        }
    }

    public void valueChanged(PixxScrollBar pixScrollBar) {
        if (pixScrollBar == this._hscroll) {
            this._list.setLeft(this._hscroll.getValue() * 10);
        } else {
            super.valueChanged(pixScrollBar);
        }
    }

    public void virtualSizeChanged(StyledList lis) {
        this._hscroll.setMaximum(this._list.getLogicalWidth() / 10);
        super.virtualSizeChanged(lis);
    }
}

