/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.Channel;
import irc.ChannelListener2;
import irc.ModeHandler;
import irc.Source;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.NickMenuHandler;
import irc.gui.pixx.NickNameComparator;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxNickListListener;
import irc.gui.pixx.PixxSeparator;
import irc.gui.pixx.ScrollablePixxNickList;
import irc.style.StyledList;
import irc.tree.SortedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;

public class AWTChannel
extends BaseAWTSource
implements ChannelListener2,
PixxNickListListener {
    private ScrollablePixxNickList _nicks;
    private Label _label;
    private SortedList _sortedList;
    private Hashtable _modeMapping;
    private NickMenuHandler _menu;

    public AWTChannel(PixxConfiguration config, Channel c) {
        super(config, c);
        this._menu = new NickMenuHandler(config, this, c);
        this._nicks = new ScrollablePixxNickList(this._pixxConfiguration, c.getIRCServer().getNickPrefixes());
        c.addChannelListener2(this);
        this._nicks.addPixxNickListListener(this);
        this._sortedList = new SortedList(new NickNameComparator(c.getIRCServer().getNickPrefixes()));
        this._modeMapping = new Hashtable();
        this._label = new Label("");
        this._label.setBackground(this._pixxConfiguration.getColor(6));
        this._label.setForeground(this._pixxConfiguration.getColor(1));
        if (this._pixxConfiguration.getIRCConfiguration().getB("asl")) {
            Panel right = new Panel();
            right.setLayout(new BorderLayout());
            right.add((Component)this._nicks, "Center");
            Panel outlabel = new Panel();
            outlabel.setLayout(new BorderLayout());
            outlabel.add((Component)new PixxSeparator(2), "West");
            outlabel.add((Component)new PixxSeparator(3), "East");
            outlabel.add((Component)new PixxSeparator(0), "North");
            outlabel.add((Component)new PixxSeparator(1), "South");
            outlabel.add((Component)this._label, "Center");
            right.add((Component)outlabel, "South");
            this.add((Component)right, "East");
        } else {
            this.add((Component)this._nicks, "East");
        }
        this.doLayout();
        this.title();
        this.print("  Please wait, joining chat room...", 3);
        this.print("  Connected!", 4);
        this.print("  Welcome to FrostWire Chat! FrostWire does not control or endorse the content, messages or information found in this chat. FrostWire specifically disclaims any liability with regard to these areas. To review the FrostWire Chat guidelines, go to \u000312\u001fhttp://www.frostwire.com/chat/conduct\u001f\u0003", 1);
        this.print("");
        if (this._pixxConfiguration.getB("showchannelyoujoin")) {
            this.print("      *** Now chatting in room " + c.getName() + " as " + c.getServer().getNick() + ".", 3);
            this.print("");
        }
    }

    public void release() {
        this._menu.release();
        ((Channel)this._source).removeChannelListener2(this);
        this._nicks.removePixxNickListListener(this);
        this._nicks.release();
        this._menu = null;
        super.release();
    }

    public void doLayout() {
        this._label.setText("");
        super.doLayout();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this._nicks.dispose();
        }
    }

    public void messageReceived(String nick, String str, Source source) {
        this.checkSound(str);
        String full = (String)this._modeMapping.get(nick);
        if (full != null && !full.equals(nick)) {
            if (full.startsWith("~")) {
                nick = "\u00034" + nick + "\u0003";
            } else if (full.startsWith("&")) {
                nick = "\u00034" + nick + "\u0003";
            } else if (full.startsWith("@")) {
                nick = "\u000312" + nick + "\u0003";
            } else if (full.startsWith("%")) {
                nick = "\u000312" + nick + "\u0003";
            } else if (full.startsWith("+")) {
                nick = "\u000310" + nick + "\u0003";
            }
        }
        super.messageReceived(nick, str, source);
    }

    private String getFullModeNick(String nick, String mode) {
        Channel c = (Channel)this.getSource();
        char[] _prefixes = c.getIRCServer().getNickPrefixes();
        char[] _modes = c.getIRCServer().getNickModes();
        char[][] chanmodes = c.getIRCServer().getChannelModes();
        ModeHandler h = new ModeHandler(mode, chanmodes, _modes);
        for (int i = 0; i < _modes.length; ++i) {
            if (!h.hasMode(_modes[i])) continue;
            return _prefixes[i] + nick;
        }
        return nick;
    }

    private String getUnprefixedNick(String nick) {
        if (nick.length() == 0) {
            return nick;
        }
        Channel c = (Channel)this.getSource();
        char[] _prefixes = c.getIRCServer().getNickPrefixes();
        for (int i = 0; i < _prefixes.length; ++i) {
            if (nick.charAt(0) != _prefixes[i]) continue;
            return nick.substring(1);
        }
        return nick;
    }

    private void setNicks(String[] nicks) {
        for (int i = 0; i < nicks.length; ++i) {
            this.addNick(nicks[i]);
        }
    }

    private void addNick(String nick) {
        String mode = ((Channel)this._source).getNickMode(nick);
        if (mode != null) {
            String full = this.getFullModeNick(nick, mode);
            this._sortedList.add(full);
            this._modeMapping.put(nick, full);
        }
    }

    private void removeNick(String nick) {
        String full = (String)this._modeMapping.get(nick);
        if (full != null) {
            this._sortedList.remove(full);
            this._modeMapping.remove(nick);
        }
    }

    private void updateNick(String nick) {
        this.removeNick(nick);
        this.addNick(nick);
    }

    private void update() {
        String nick;
        String[] n = new String[this._modeMapping.size()];
        Enumeration e = this._modeMapping.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            n[i++] = (String)e.nextElement();
        }
        this._textField.setCompleteList(n);
        n = new String[this._modeMapping.size()];
        e = this._modeMapping.keys();
        i = 0;
        while (e.hasMoreElements()) {
            nick = (String)e.nextElement();
            n[i++] = nick + ":" + ((Channel)this._source).whois(this.getUnprefixedNick(nick));
        }
        this._list.setNickList(n);
        n = new String[this._sortedList.getSize()];
        e = this._sortedList.getItems();
        i = 0;
        while (e.hasMoreElements()) {
            nick = (String)e.nextElement();
            String whois = ((Channel)this._source).whois(this.getUnprefixedNick(nick));
            n[i++] = nick + ":" + whois;
        }
        this._nicks.set(n);
        this.title();
    }

    public synchronized void nickSet(String[] nicks, String[] modes, Channel channel) {
        this.setNicks(nicks);
        this.update();
    }

    public synchronized void nickReset(Channel channel) {
        this._sortedList.clear();
        this._modeMapping.clear();
        this._nicks.removeAll();
        this.update();
    }

    public synchronized void nickJoin(String nick, String mode, Channel channel) {
        this.addNick(nick);
        this.update();
        if (this._sortedList.getSize() <= 100) {
            this.print("      *** " + nick + " has joined the conversation.", 14);
        }
    }

    public synchronized void nickPart(String nick, String reason, Channel channel) {
        this.removeNick(nick);
        this.update();
        if (this._sortedList.getSize() <= 100) {
            this.print("      *** " + nick + " has left the conversation.", 14);
        }
    }

    public synchronized void nickKick(String nick, String by, String reason, Channel channel) {
        this.removeNick(nick);
        this.update();
        if (this._pixxConfiguration.getB("showchannelnickkick")) {
            if (nick.equals(this._source.getServer().getNick())) {
                this.print("\u0002 You have been kicked out of the chat room by Host " + by + ": " + reason, 4);
                this._nicks.removeAll();
                this.kicktitle();
            } else if (reason.length() > 0) {
                this.print("\u0002 Host " + by + " kicked " + nick + " out of the chat room" + ": " + reason, 4);
            } else {
                this.print("\u0002 Host " + by + " kicked " + nick + " out of the chat room.", 4);
            }
        }
    }

    public synchronized void nickQuit(String nick, String reason, Channel channel) {
        this.removeNick(nick);
        this.update();
        if (this._sortedList.getSize() <= 100) {
            this.print("      *** " + nick + " has left the conversation.", 14);
        }
    }

    private void title() {
        int count = this._sortedList.getSize();
        String title = " Welcome to FrostWire Live Chat!";
        if (this._pixxConfiguration.getB("displaychannelcount")) {
            if (this._sortedList.getSize() == 1) {
                title = title + " There is " + count + " person chatting in " + this._source.getName() + ".";
            } else if (this._sortedList.getSize() <= 0) {
                title = title + " There is nobody chatting in " + this._source.getName() + ".";
            } else if (this._sortedList.getSize() >= 2) {
                title = title + " There are " + count + " people chatting in " + this._source.getName() + ".";
            }
        }
        if (this._pixxConfiguration.getB("displaychannelname")) {
            title = title + " Chat Room: " + this._source.getName();
        }
        if (this._pixxConfiguration.getB("displaychannelmode")) {
            title = title + " Room Modes: " + ((Channel)this._source).getMode();
        }
        if (this._pixxConfiguration.getB("displaychanneltopic")) {
            title = title.length() != 0 ? title + ": " + ((Channel)this._source).getTopic() : ((Channel)this._source).getTopic();
        }
        this.setTitle(title.trim());
    }

    private void kicktitle() {
        String title = " You were kicked out of the chat room.";
        this.setTitle(title.trim());
    }

    public synchronized void topicChanged(String topic, String by, Channel channel) {
        if (this._pixxConfiguration.getB("showchanneltopicchanged")) {
            if (by.length() == 0) {
                this.print("\u000310 The chat's topic is: \u0003" + topic);
                this.print("");
            } else {
                this.print("\u000310 The chat's topic has changed to: \u0003" + topic);
            }
            this.title();
        }
    }

    public synchronized void modeApply(String mode, String from, Channel channel) {
        if (from.length() > 0) {
            if (mode.equals("+X")) {
                this.print("      *** " + channel + " is now an official room.", 14);
            } else if (mode.equals("+G")) {
                this.print("      *** This room is now Rated G for all audiences.", 14);
            }
        }
        this.title();
    }

    public synchronized void nickModeApply(String nick, String mode, String from, Channel channel) {
        if (!nick.equals(this._source.getServer().getNick())) {
            if (mode.equals("+q")) {
                this.print("      *** " + from + " has made " + nick + " an Owner.", 14);
            } else if (mode.equals("+a")) {
                this.print("      *** " + from + " has made " + nick + " an Admin.", 14);
            } else if (mode.equals("+o")) {
                this.print("      *** " + from + " has made " + nick + " a Host.", 14);
            } else if (mode.equals("+h")) {
                this.print("      *** " + from + " has made " + nick + " a Helper.", 14);
            } else if (mode.equals("-v")) {
                this.print("      *** " + from + " has made " + nick + " a Spectator.", 14);
            }
        } else if (nick.equals(this._source.getServer().getNick())) {
            if (mode.equals("+q")) {
                this.print("      *** " + from + " has made you an Owner.", 3);
            } else if (mode.equals("+a")) {
                this.print("      *** " + from + " has made you an Admin.", 3);
            } else if (mode.equals("+o")) {
                this.print("      *** " + from + " has made you a Host.", 3);
            } else if (mode.equals("+h")) {
                this.print("      *** " + from + " has made you a Helper.", 3);
            } else if (mode.equals("+v")) {
                this.print("      *** " + from + " has made you a Participant.", 3);
            } else if (mode.equals("-v")) {
                this.print("      *** " + from + " has made you a Spectator.", 3);
            }
        }
        this.updateNick(nick);
        this.update();
    }

    public synchronized void nickChanged(String oldNick, String newNick, Channel channel) {
        if (!newNick.equals(this._source.getServer().getNick())) {
            this.print("      *** " + oldNick + " is now known as " + newNick + ".", 14);
        }
        this.removeNick(oldNick);
        this.addNick(newNick);
        this.update();
    }

    public void nickWhoisUpdated(String nick, String whois, Channel channel) {
        this.update();
    }

    public void eventOccured(String nick, MouseEvent e) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickpopup", e)) {
            this._menu.popup(nick, ((Channel)this._source).whois(nick), this._nicks, e.getX(), e.getY());
        } else if (this._pixxConfiguration.matchMouseConfiguration("nickquery", e) && this._pixxConfiguration.getB("automaticqueries") && !nick.equals(this._source.getServer().getNick())) {
            this._source.sendString("/focus Query " + nick);
            this._source.sendString("/query " + nick);
        }
    }

    public void ASLEventOccured(String nick, String info) {
        this._label.setText(this._pixxConfiguration.getIRCConfiguration().formatASL(info));
    }

    public void nickEvent(StyledList lis, String nick, MouseEvent e) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickpopup", e)) {
            this._menu.popup(nick, ((Channel)this._source).whois(nick), this._list, e.getX(), e.getY());
        } else {
            super.nickEvent(lis, nick, e);
        }
    }
}

