/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.NotEnoughParametersException;
import irc.RootInterpretor;
import irc.Source;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxMDIInterface;
import java.util.Enumeration;
import java.util.Locale;

public class AWTInterpretor
extends RootInterpretor {
    private PixxMDIInterface _mdi;
    private PixxConfiguration _config;

    public AWTInterpretor(PixxConfiguration config, PixxMDIInterface mdi) {
        super(config.getIRCConfiguration());
        this._mdi = mdi;
        this._config = config;
    }

    protected void handleCommand(Source source, String cmd, String[] parts, String[] cumul) {
        block29: {
            try {
                if (cmd.equals("dock")) {
                    BaseAWTSource asource = this._mdi.findBaseAWTSource(source);
                    if (asource != null) {
                        this._mdi.dock(asource);
                    }
                    break block29;
                }
                if (cmd.equals("undock")) {
                    BaseAWTSource asource = this._mdi.findBaseAWTSource(source);
                    if (asource != null) {
                        this._mdi.undock(asource);
                    }
                    break block29;
                }
                if (cmd.equals("color")) {
                    int c;
                    this.test(cmd, parts, 1);
                    BaseAWTSource asource = this._mdi.findBaseAWTSource(source);
                    if (asource == null) break block29;
                    String front = parts[1];
                    String back = "";
                    int pos = front.indexOf(",");
                    if (pos >= 0) {
                        back = front.substring(pos + 1);
                        front = front.substring(0, pos);
                    }
                    try {
                        c = Integer.parseInt(front);
                        asource.setFrontColor(c);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        c = Integer.parseInt(back);
                        asource.setBackColor(c);
                    }
                    catch (Exception ex) {}
                    break block29;
                }
                if (cmd.equals("bold")) {
                    this.test(cmd, parts, 1);
                    BaseAWTSource asource = this._mdi.findBaseAWTSource(source);
                    if (asource != null) {
                        if (parts[1].equals("1")) {
                            asource.setBold(true);
                        } else if (parts[1].equals("0")) {
                            asource.setBold(false);
                        }
                    }
                    break block29;
                }
                if (cmd.equals("underline")) {
                    this.test(cmd, parts, 1);
                    BaseAWTSource asource = this._mdi.findBaseAWTSource(source);
                    if (asource != null) {
                        if (parts[1].equals("1")) {
                            asource.setUnderline(true);
                        } else if (parts[1].equals("0")) {
                            asource.setUnderline(false);
                        }
                    }
                    break block29;
                }
                if (cmd.equals("highlight")) {
                    this.test(cmd, parts, 1);
                    for (int i = 1; i < parts.length; ++i) {
                        this._config.addHighLightWord(parts[i]);
                    }
                    break block29;
                }
                if (cmd.equals("unhighlight")) {
                    this.test(cmd, parts, 1);
                    for (int i = 1; i < parts.length; ++i) {
                        this._config.removeHighLightWord(parts[i]);
                    }
                    break block29;
                }
                if (cmd.equals("focus")) {
                    this.test(cmd, parts, 2);
                    Enumeration e = source.getServer().getSources();
                    while (e.hasMoreElements()) {
                        Source s = (Source)e.nextElement();
                        if (!s.getType().equals(parts[1]) || !s.getName().toLowerCase(Locale.ENGLISH).equals(parts[2].toLowerCase(Locale.ENGLISH))) continue;
                        BaseAWTSource asource = this._mdi.findBaseAWTSource(s);
                        if (asource != null) {
                            this._mdi.setActive(asource);
                        }
                        break block29;
                    }
                    break block29;
                }
                super.handleCommand(source, cmd, parts, cumul);
            }
            catch (NotEnoughParametersException ex) {
                source.report(" *** Invalid command format: " + ex.getMessage());
            }
        }
    }
}

