/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.IRCServer;
import irc.Query;
import irc.QueryListener;
import irc.ReplyServerListener;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.NickMenuHandler;
import irc.gui.pixx.PixxConfiguration;
import irc.style.StyledList;
import java.awt.event.MouseEvent;
import java.util.Locale;

public class AWTQuery
extends BaseAWTSource
implements QueryListener,
ReplyServerListener {
    private NickMenuHandler _menu;

    public AWTQuery(PixxConfiguration config, Query query) {
        super(config, query);
        this._menu = new NickMenuHandler(config, this, query);
        query.addQueryListener(this);
        query.getIRCServer().addReplyServerListener(this);
        this.update();
        this.print("  This is a private conversation with " + this._source.getName() + ".", 3);
        this.print("  We caution you against giving out any personally identifiable information (such as your social security number, credit card number, name, address, telephone number, driver's license number, password(s), etc.) online. This information can easily be used for illegal or harmful purposes.", 4);
        this.print("");
    }

    public void release() {
        ((Query)this._source).removeQueryListeners(this);
        ((Query)this._source).getIRCServer().removeReplyServerListener(this);
        this._menu.release();
        this._menu = null;
        super.release();
    }

    private void update() {
        String whois = ((Query)this._source).getWhois();
        String[] nick = new String[]{this._source.getName() + ":" + this._pixxConfiguration.getIRCConfiguration().formatASL(whois), this._source.getServer().getNick() + ":" + this._pixxConfiguration.getIRCConfiguration().formatASL(this._source.getServer().getUserName())};
        this._list.setNickList(nick);
        this.title();
    }

    private void title() {
        String whois = ((Query)this._source).getWhois();
        if (whois.length() > 0) {
            this.setTitle(this._source.getName() + " (" + this._pixxConfiguration.getIRCConfiguration().formatASL(whois) + ")");
        } else {
            this.setTitle(" FrostWire Chat: Private conversation with " + this._source.getName() + ".");
        }
    }

    public void nickChanged(String newNick, Query query) {
        this.update();
    }

    public void whoisChanged(String whois, Query query) {
        this.update();
    }

    private String whois(String nick) {
        if ((nick = nick.toLowerCase(Locale.ENGLISH)).equals(this._source.getName().toLowerCase(Locale.ENGLISH))) {
            return ((Query)this._source).getWhois();
        }
        if (nick.equals(this._source.getServer().getNick().toLowerCase(Locale.ENGLISH))) {
            return this._source.getServer().getUserName();
        }
        return "";
    }

    public void nickEvent(StyledList lis, String nick, MouseEvent e) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickpopup", e)) {
            this._menu.popup(nick, this.whois(nick), this._list, e.getX(), e.getY());
        } else {
            super.nickEvent(lis, nick, e);
        }
    }

    public Boolean replyReceived(String prefix, String id, String[] params, IRCServer server) {
        if (id.equals("301") && params[1].toLowerCase(Locale.ENGLISH).equals(this._source.getName().toLowerCase(Locale.ENGLISH))) {
            String toSend = "\u000314      *** " + params[1] + " is currently away.";
            for (int i = 2; i < params.length; ++i) {
                toSend = toSend + " Away message: " + params[i];
            }
            this._source.report(toSend);
        }
        return Boolean.FALSE;
    }
}

