/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.IRCServer;
import irc.ReplyServerListener;
import irc.Status;
import irc.StatusListener;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.PixxConfiguration;

public class AWTStatus
extends BaseAWTSource
implements StatusListener,
ReplyServerListener {
    public AWTStatus(PixxConfiguration config, Status s) {
        super(config, s);
        s.addStatusListener(this);
        s.getIRCServer().addReplyServerListener(this);
        this.title();
        this.print("  Press the \"Connect\" button to join the community...", 3);
    }

    public void release() {
        ((Status)this._source).removeStatusListener(this);
        ((Status)this._source).getIRCServer().removeReplyServerListener(this);
        super.release();
    }

    private String getSourceName() {
        if (!this._pixxConfiguration.getIRCConfiguration().getB("multiserver")) {
            if (this._pixxConfiguration.getIRCConfiguration().getB("useinfo")) {
                return "Information";
            }
            return "Status";
        }
        return ((Status)this._source).getServerName();
    }

    private void title() {
        this.setTitle(" Welcome to The FrostWire Chat Network " + ((Status)this._source).getNick() + "!");
    }

    public String getShortTitle() {
        return this.getSourceName();
    }

    public void noticeReceived(String from, String msg) {
        this.print("-" + from + "- " + msg, 6);
    }

    public void nickChanged(String nick, Status status) {
        status.getIRCServer().getDefaultSource().report("\u000303      *** You are now known as " + nick + ".");
        this.title();
    }

    public void modeChanged(String mode, Status status) {
    }

    public void invited(String channel, String who, Status status) {
        if (status.getIRCServer().getDefaultSource() != null) {
            // empty if block
        }
    }

    public Boolean replyReceived(String prefix, String id, String[] params, IRCServer server) {
        return Boolean.FALSE;
    }
}

