/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.StyleContext;
import irc.gui.pixx.PixxConfiguration;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class AWTStyleSelector
extends Panel
implements MouseListener {
    private PixxConfiguration _pixxConfiguration;
    private StyleContext _ct;
    private int _color;
    private int _backColor;
    private boolean _bold;
    private boolean _underline;

    public AWTStyleSelector(PixxConfiguration config) {
        this._pixxConfiguration = config;
        this._color = 1;
        this._backColor = 0;
        this._bold = false;
        this._underline = false;
        this.addMouseListener(this);
        this._ct = this._pixxConfiguration.getIRCConfiguration().getDefaultStyleContext();
    }

    public void release() {
        this.removeMouseListener(this);
        this._pixxConfiguration = null;
    }

    public void setStyleContext(StyleContext ct) {
        this._ct = ct;
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    private void drawSelect(Graphics g, int i, int j) {
        int x = (int)((double)i * this.getItemWidth());
        int y = (int)((double)j * this.getItemHeight());
        int w = (int)this.getItemWidth();
        int h = (int)this.getItemHeight();
        g.setColor(Color.black);
        g.drawRect(x + 1, y + 1, w - 2, h - 2);
        g.setColor(Color.white);
        g.drawRect(x, y, w - 2, h - 2);
    }

    private void drawColor(Graphics g, int i, int j, Color c) {
        int x = (int)((double)i * this.getItemWidth());
        int y = (int)((double)j * this.getItemHeight());
        int w = (int)this.getItemWidth();
        int h = (int)this.getItemHeight();
        g.setColor(c);
        g.fillRect(x, y, w, h);
    }

    private void drawBold(Graphics g, int i, int j) {
        int x = (int)((double)i * this.getItemWidth());
        int y = (int)((double)j * this.getItemHeight());
        int w = (int)this.getItemWidth();
        int h = (int)this.getItemHeight();
        int tw = g.getFontMetrics().stringWidth("a");
        g.drawString("a", x + (w - tw) / 2, y + h - (h - g.getFont().getSize()) / 2 - 2);
        g.drawString("a", x + (w - tw) / 2 + 1, y + h - (h - g.getFont().getSize()) / 2 - 2);
    }

    private void drawUnderline(Graphics g, int i, int j) {
        int x = (int)((double)i * this.getItemWidth());
        int y = (int)((double)j * this.getItemHeight());
        int w = (int)this.getItemWidth();
        int h = (int)this.getItemHeight();
        int tw = g.getFontMetrics().stringWidth("a");
        g.drawString("a", x + (w - tw) / 2, y + h - (h - g.getFont().getSize()) / 2 - 2);
        g.drawLine(x + w / 2 - tw / 2, y + h - 1, x + w / 2 + tw / 2, y + h - 1);
    }

    public void update(Graphics g) {
        Graphics gra;
        Image buffer;
        int w = this.getSize().width;
        int h = this.getSize().height;
        try {
            buffer = this.createImage(w, h);
            gra = buffer.getGraphics();
        }
        catch (Throwable e) {
            return;
        }
        Color[] cols = this._pixxConfiguration.getIRCConfiguration().getStyleColors(this._ct);
        int c = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = 1; x < 9; ++x) {
                this.drawColor(gra, x, y, cols[c]);
                if (c == this._color) {
                    this.drawSelect(gra, x, y);
                }
                ++c;
            }
        }
        gra.setColor(cols[this._backColor]);
        gra.fillRect(0, 0, (int)this.getItemWidth(), h);
        gra.setColor(cols[this._color]);
        this.drawBold(gra, 0, 0);
        this.drawUnderline(gra, 0, 1);
        if (this._bold) {
            this.drawSelect(gra, 0, 0);
        }
        if (this._underline) {
            this.drawSelect(gra, 0, 1);
        }
        g.drawImage(buffer, 0, 0, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(90, 10);
    }

    private double getItemWidth() {
        return (double)this.getSize().width / 9.0;
    }

    private double getItemHeight() {
        return (double)this.getSize().height / 2.0;
    }

    public void setFrontColor(int c) {
        this._color = c;
        this.repaint();
    }

    public void setBackColor(int c) {
        this._backColor = c;
        this.repaint();
    }

    public void setBold(boolean bold) {
        this._bold = bold;
        this.repaint();
    }

    public void setUnderline(boolean underline) {
        this._underline = underline;
        this.repaint();
    }

    public String getPrefix() {
        String pre = "";
        if (this._color != 1 || this._backColor != 0) {
            String c1 = "";
            if (this._color != 1) {
                c1 = c1 + this._color;
                if (this._color < 10) {
                    c1 = "0" + c1;
                }
            }
            String c2 = "";
            if (this._backColor != 0) {
                c2 = "" + this._backColor;
                if (this._backColor < 10) {
                    c2 = "0" + c2;
                }
                c2 = "," + c2;
            }
            if (c2.length() > 0 && c1.length() == 0) {
                c1 = "1";
            }
            pre = pre + '\u0003' + c1 + c2;
        }
        if (this._bold) {
            pre = pre + '\u0002';
        }
        if (this._underline) {
            pre = pre + '\u001f';
        }
        return pre;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int x = (int)((double)e.getX() / this.getItemWidth());
        int y = (int)((double)e.getY() / this.getItemHeight());
        if (x == 0) {
            if (y == 0) {
                boolean bl = this._bold = !this._bold;
            }
            if (y == 1) {
                this._underline = !this._underline;
            }
        } else {
            --x;
            if ((e.getModifiers() & 0x10) != 0) {
                this._color = x + y * 8;
            } else {
                this._backColor = x + y * 8;
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
    }
}

