/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.EventDispatcher;
import irc.ListenerGroup;
import irc.StyleContext;
import irc.gui.pixx.AWTStyleSelector;
import irc.gui.pixx.AWTStyleSelectorExListener;
import irc.gui.pixx.FontSelector;
import irc.gui.pixx.FontSelectorListener;
import irc.gui.pixx.NonFocusableButton;
import irc.gui.pixx.PixxConfiguration;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class AWTStyleSelectorEx
extends Panel
implements ActionListener,
FontSelectorListener {
    private ListenerGroup _lis;
    private AWTStyleSelector _selector;
    private FontSelector _fs;
    private Button _b;

    public AWTStyleSelectorEx(PixxConfiguration config) {
        this._fs = new FontSelector(config);
        this._selector = new AWTStyleSelector(config);
        this.setLayout(new BorderLayout());
        this.add((Component)this._selector, "Center");
        this._b = new NonFocusableButton("Font");
        this._b.setForeground(config.getColor(1));
        this._b.setBackground(config.getColor(5));
        this._b.addActionListener(this);
        if (config.getB("setfontonstyle")) {
            this.add((Component)this._b, "East");
        }
        this._lis = new ListenerGroup();
    }

    public void release() {
        this.removeAll();
        this._b.removeActionListener(this);
        this._selector.release();
        this._fs.release();
        this._selector = null;
        this._fs = null;
    }

    public void setStyleContext(StyleContext ct) {
        this._selector.setStyleContext(ct);
    }

    public String getPrefix() {
        return this._selector.getPrefix();
    }

    public AWTStyleSelector getStyleSelector() {
        return this._selector;
    }

    public void addAWTStyleSelectorExListener(AWTStyleSelectorExListener lis) {
        this._lis.addListener(lis);
    }

    public void removeAWTStyleSelectorExListener(AWTStyleSelectorExListener lis) {
        this._lis.removeListener(lis);
    }

    public void actionPerformed(ActionEvent e) {
        EventDispatcher.dispatchEventAsync(this._fs, "selectFont", new Object[]{this});
    }

    public void fontSelected(Font f) {
        if (f != null) {
            this._lis.sendEvent("fontSelected", f);
        }
    }
}

