/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import com.limegroup.gnutella.gui.GUIMediator;
import irc.AudioConfiguration;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.ListenerGroup;
import irc.Source;
import irc.SourceListener;
import irc.StringParser;
import irc.StyleContext;
import irc.gui.GUISource;
import irc.gui.common.AWTIrcTextField;
import irc.gui.common.MouseWheelPanelListener;
import irc.gui.common.MouseWheelPanelWrapper;
import irc.gui.pixx.AWTStyleSelectorEx;
import irc.gui.pixx.AWTStyleSelectorExListener;
import irc.gui.pixx.BaseAWTSourceListener;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxScrollBar;
import irc.gui.pixx.PixxScrollBarListener;
import irc.gui.pixx.PixxSeparator;
import irc.gui.pixx.PixxVerticalScrollBar;
import irc.style.FormattedStringDrawer;
import irc.style.StyledList;
import irc.style.StyledListListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;

public class BaseAWTSource
extends Panel
implements GUISource,
SourceListener,
ActionListener,
PixxScrollBarListener,
FocusListener,
StyledListListener,
WindowListener,
MouseWheelPanelListener,
AWTStyleSelectorExListener {
    protected Source _source;
    protected PixxVerticalScrollBar _scroll;
    protected Panel _panel;
    protected StyledList _list;
    protected AWTIrcTextField _textField;
    protected FormattedStringDrawer _styler;
    protected String _title;
    protected String _strippedTitle;
    private ListenerGroup _listeners;
    protected PixxConfiguration _pixxConfiguration;
    protected AWTStyleSelectorEx _selector;
    protected boolean _topToBottom;
    private MouseWheelPanelWrapper _wrapper;

    public BaseAWTSource(PixxConfiguration config, Source source) {
        this(config, source, false);
    }

    public BaseAWTSource(PixxConfiguration config, Source source, boolean topToBottom) {
        this._topToBottom = topToBottom;
        this._pixxConfiguration = config;
        this._listeners = new ListenerGroup();
        this._source = source;
        this.addFocusListener(this);
        this._source.addSourceListener(this);
        this._panel = new Panel();
        this._panel.addFocusListener(this);
        this._panel.setBackground(Color.white);
        this._scroll = new PixxVerticalScrollBar(this._pixxConfiguration, 0, 0, 0.1);
        this._scroll.addPixxScrollBarListener(this);
        this.setLayout(new BorderLayout());
        IRCConfiguration ircConfiguration = this._pixxConfiguration.getIRCConfiguration();
        Color aslMale = this._pixxConfiguration.getColor(13);
        Color aslFemeale = this._pixxConfiguration.getColor(14);
        Color aslUndef = this._pixxConfiguration.getColor(15);
        this._list = new StyledList(ircConfiguration, true, ircConfiguration.getStyleContext(source.getType(), source.getName()), aslMale, aslFemeale, aslUndef);
        this._list.addFocusListener(this);
        this._list.addStyledListListener(this);
        this._styler = new FormattedStringDrawer(ircConfiguration, this.getStyleContext());
        this._textField = new AWTIrcTextField();
        boolean b = this._pixxConfiguration.getB("displayentertexthere");
        if (b) {
            this._textField.setEnterTextHere(true, "Enter text here...");
        }
        Color[] c = ircConfiguration.getStyleColors(this.getStyleContext());
        this._textField.setBackground(c[0]);
        this._textField.setForeground(c[1]);
        this._textField.addFocusListener(this);
        Panel p = new Panel();
        p.setLayout(new BorderLayout());
        this._wrapper = new MouseWheelPanelWrapper(this._panel);
        this._wrapper.addMouseWheelPanelListener(this);
        p.add((Component)this._wrapper, "Center");
        p.add((Component)new PixxSeparator(2), "West");
        p.add((Component)new PixxSeparator(3), "East");
        p.add((Component)new PixxSeparator(0), "North");
        p.add((Component)new PixxSeparator(1), "South");
        this.add((Component)p, "Center");
        this._panel.setLayout(new BorderLayout());
        this._panel.add((Component)this._scroll, "East");
        this._selector = new AWTStyleSelectorEx(this._pixxConfiguration);
        this._selector.setStyleContext(this.getStyleContext());
        this._selector.addAWTStyleSelectorExListener(this);
        if (this._pixxConfiguration.getB("styleselector")) {
            p = new Panel(new BorderLayout());
            p.add((Component)this._textField, "Center");
            p.add((Component)this._selector, "East");
            this.add((Component)p, "South");
        } else {
            this.add((Component)this._textField, "South");
        }
        if (this._topToBottom) {
            this._list.setFirst(0);
        } else {
            this._list.setLast(0);
        }
        this._textField.addActionListener(this);
        this.setTitle(this._source.getName());
        this._panel.add((Component)this._list, "Center");
    }

    public void release() {
        this._wrapper.removeMouseWheelPanelListener(this);
        this._source.removeSourceListener(this);
        this._panel.removeFocusListener(this);
        this._scroll.removePixxScrollBarListener(this);
        this._scroll.release();
        this._list.removeFocusListener(this);
        this._list.removeStyledListListener(this);
        this._textField.removeFocusListener(this);
        this._selector.removeAWTStyleSelectorExListener(this);
        this._selector.release();
        this._textField.removeActionListener(this);
        this._textField.release();
        this._list.release();
        this.removeAll();
    }

    public void setFrontColor(int color) {
        this._selector.getStyleSelector().setFrontColor(color);
    }

    public void setBackColor(int color) {
        this._selector.getStyleSelector().setBackColor(color);
    }

    public void setBold(boolean bold) {
        this._selector.getStyleSelector().setBold(bold);
    }

    public void setUnderline(boolean underline) {
        this._selector.getStyleSelector().setUnderline(underline);
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 300);
    }

    public void setFieldText(String txt) {
        this._textField.setText(txt);
        this._textField.setCaretPosition(txt.length());
    }

    public String getFieldText() {
        return this._textField.getText();
    }

    public void validateText() {
        this._textField.validateText();
    }

    public StyleContext getStyleContext() {
        return this._pixxConfiguration.getIRCConfiguration().getStyleContext(this._source.getType(), this._source.getName());
    }

    public String getText(int code) {
        return this._pixxConfiguration.getText(code);
    }

    public String getText(int code, String p1) {
        return this._pixxConfiguration.getText(code, p1);
    }

    public String getText(int code, String p1, String p2) {
        return this._pixxConfiguration.getText(code, p1, p2);
    }

    public String getText(int code, String p1, String p2, String p3) {
        return this._pixxConfiguration.getText(code, p1, p2, p3);
    }

    public void addBaseAWTSourceListener(BaseAWTSourceListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeBaseAWTSourceListener(BaseAWTSourceListener lis) {
        this._listeners.removeListener(lis);
    }

    public void setTitle(String title) {
        if (title.equals(this._title)) {
            return;
        }
        this._title = title;
        this._strippedTitle = this._styler.getStripped(title);
        this._listeners.sendEvent("titleChanged", this);
    }

    public String getStrippedTitle() {
        return this._strippedTitle;
    }

    public String getTitle() {
        return this._title;
    }

    public String getShortTitle() {
        return this._source.getName();
    }

    public Source getSource() {
        return this._source;
    }

    public void actionPerformed(ActionEvent e) {
        EventDispatcher.dispatchEventAsync(this, "actionPerformedEff", new Object[]{e});
    }

    public void actionPerformedEff(ActionEvent e) {
        if (this._textField.getText().length() == 0) {
            return;
        }
        String prefix = "";
        prefix = this._selector.getPrefix();
        if (!this._textField.getText().startsWith("/")) {
            this._source.sendUserString(prefix + this._textField.getText());
        } else {
            StringParser parser = new StringParser();
            String[] parts = parser.parseString(StringParser.trim(this._textField.getText()));
            if (parts.length >= 2 && parts[0].toLowerCase(Locale.ENGLISH).equals("/join")) {
                this._source.sendString("/focus Channel " + parts[1]);
            }
            this._source.sendUserString(this._textField.getText());
        }
        if (this._textField != null) {
            this._textField.setText("");
        }
    }

    public void fontSelected(Font fnt) {
        this._list.setFont(fnt);
    }

    public void clear(Source source) {
        this._list.clear();
        this._scroll.setMaximum(this._list.getLineCount() - 1);
        this._scroll.setValue(this._list.getLast());
        this._listeners.sendEvent("eventOccured", this);
    }

    protected boolean needHighLight(String msg) {
        String myNick;
        msg = msg.toLowerCase(Locale.ENGLISH);
        if (this._pixxConfiguration.highLightNick() && msg.indexOf(myNick = this._source.getServer().getNick().toLowerCase(Locale.ENGLISH)) != -1) {
            return true;
        }
        Enumeration e = this._pixxConfiguration.getHighLightWords();
        while (e.hasMoreElements()) {
            String word = ((String)e.nextElement()).toLowerCase(Locale.ENGLISH);
            if (msg.indexOf(word) == -1) continue;
            return true;
        }
        return false;
    }

    protected void checkSound(String msg) {
        msg = msg.toLowerCase(Locale.ENGLISH);
        AudioConfiguration ac = this._pixxConfiguration.getIRCConfiguration().getAudioConfiguration();
        Enumeration e = ac.getSoundWords();
        while (e.hasMoreElements()) {
            String word = ((String)e.nextElement()).toLowerCase(Locale.ENGLISH);
            if (msg.indexOf(word) == -1) continue;
            ac.onWord(word);
        }
    }

    protected void print(String msg, int color, boolean bold, boolean underline) {
        if (color != 1) {
            msg = "\u0003" + color + msg;
        }
        if (bold) {
            msg = "\u0002" + msg;
        }
        if (underline) {
            msg = '\u001f' + msg;
        }
        if (this._pixxConfiguration.getB("timestamp")) {
            String min;
            Calendar cal = Calendar.getInstance();
            String hour = "" + cal.get(11);
            if (hour.length() == 1) {
                hour = "0" + hour;
            }
            if ((min = "" + cal.get(12)).length() == 1) {
                min = "0" + min;
            }
            msg = "(" + hour + ":" + min + ") " + msg;
        }
        this._list.addLine(msg);
        this._scroll.setMaximum(this._list.getLineCount() - 1);
        this._scroll.setValue(this._list.getLast());
        this._listeners.sendEvent("eventOccured", this);
    }

    protected void print(String msg, int color) {
        this.print(msg, color, false, false);
    }

    protected void print(String msg) {
        this.print(msg, 1, false, false);
    }

    private String formatNick(String nick) {
        return " \u00032" + nick + " \u0003: ";
    }

    private String formatMyNick(String nick) {
        return " \u0002\u00032" + nick + " \u0003\u0002: ";
    }

    public void messageReceived(String nick, String str, Source source) {
        this.checkSound(str);
        if (this.needHighLight(str)) {
            this.print(this.formatNick(nick) + str, this._pixxConfiguration.getI("highlightcolor"));
        } else if (!nick.equals(this._source.getServer().getNick())) {
            this.print(this.formatNick(nick) + str);
        } else if (nick.equals(this._source.getServer().getNick())) {
            this.print(this.formatMyNick(nick) + str);
        }
    }

    public void reportReceived(String msg, Source source) {
        this.print(msg);
    }

    public void noticeReceived(String from, String msg, Source source) {
        if (from.equals("Global")) {
            this.print("  \u0002\u00034Global broadcast message:\u0003\u0002 " + msg);
        } else {
            this.print("      *** Whisper from " + from + ": " + msg, 6);
        }
    }

    public void action(String nick, String msg, Source source) {
        this.print(" * " + nick + " " + msg, 6);
    }

    public void leave() {
        this._source.leave();
    }

    public void mouseWheelMoved(Integer amount) {
        int i = amount;
        this._scroll.setValue(this._scroll.getValue() + i);
        if (this._topToBottom) {
            this._list.setFirst(this._scroll.getValue());
        } else {
            this._list.setLast(this._scroll.getValue());
        }
    }

    public void valueChanged(PixxScrollBar pixScrollBar) {
        if (this._topToBottom) {
            this._list.setFirst(this._scroll.getValue());
        } else {
            this._list.setLast(this._scroll.getValue());
        }
    }

    public void focusGained(FocusEvent e) {
        if (e.getComponent() != this._textField) {
            this._textField.requestFocus();
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void channelEvent(StyledList lis, String chan, MouseEvent e) {
        if (this._pixxConfiguration.matchMouseConfiguration("channeljoin", e)) {
            this._source.sendString("/focus Channel " + chan);
            this._source.sendString("/join " + chan);
        }
    }

    public void URLEvent(StyledList lis, String url, MouseEvent e) {
        GUIMediator.openURL(url);
        if (this._pixxConfiguration.matchMouseConfiguration("urlopen", e)) {
            this._source.sendString("/url " + url);
        }
    }

    public void nickEvent(StyledList lis, String nick, MouseEvent e) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickquery", e)) {
            if (nick.equals(this.getSource().getServer().getNick())) {
                return;
            }
            if (this._pixxConfiguration.getB("automaticqueries")) {
                this._source.sendString("/focus Query " + nick);
                this._source.sendString("/query " + nick);
            }
        }
    }

    public String toString() {
        return "AWTSource : " + this.getStrippedTitle();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this._list.dispose();
        }
    }

    public void copyEvent(StyledList lis, String txt, MouseEvent e) {
    }

    public void virtualSizeChanged(StyledList lis) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        e.getWindow().setVisible(false);
        e.getWindow().dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

