/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.EventDispatcher;
import irc.Source;
import irc.gui.pixx.PixxConfiguration;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class NickMenuHandler
implements ActionListener {
    private String _selectedNick;
    private String _whoisNick;
    private PopupMenu _menu;
    private Source _source;
    private Component _parent;
    private PixxConfiguration _pixxConfiguration;

    public NickMenuHandler(PixxConfiguration config, Component parent, Source source) {
        this._pixxConfiguration = config;
        this._parent = parent;
        this._source = source;
        this._menu = new PopupMenu();
        this._menu.addActionListener(this);
        this._parent.add(this._menu);
    }

    public void release() {
        this._menu.removeActionListener(this);
        this._parent.remove(this._menu);
        this._menu = null;
        this._parent = null;
        this._source = null;
        this._pixxConfiguration = null;
    }

    private String parameters(String on, String[] params) {
        for (int i = 0; i < on.length() - 1; ++i) {
            int c;
            if (on.charAt(i) != '%') continue;
            char next = on.charAt(i + 1);
            if (next == '%') {
                String before = on.substring(0, i);
                String after = on.substring(i + 2);
                on = before + "%" + after;
                continue;
            }
            if (next < '1' || next > '9' || (c = next - 49) >= params.length) continue;
            String before = on.substring(0, i);
            String after = on.substring(i + 2);
            on = before + params[c] + after;
        }
        return on;
    }

    public void actionPerformed(ActionEvent e) {
        EventDispatcher.dispatchEventAsync(this, "actionPerformedEff", new Object[]{e});
    }

    public void actionPerformedEff(ActionEvent e) {
        String cmd = e.getActionCommand();
        String[] params = new String[]{this._selectedNick, this._source.getName(), this._pixxConfiguration.getIRCConfiguration().formatASL(this._whoisNick), this._whoisNick};
        for (int j = 0; j < this._pixxConfiguration.getNickMenuVector().size(); ++j) {
            String[] cmds = (String[])this._pixxConfiguration.getNickMenuVector().elementAt(j);
            if (!cmds[0].equals(cmd)) continue;
            for (int i = 1; i < cmds.length; ++i) {
                this._source.sendString(this.parameters(cmds[i], params));
            }
        }
    }

    public void popup(String nick, String whois, Component c, int x, int y) {
        if (this._pixxConfiguration.getNickMenuVector().size() == 0) {
            return;
        }
        this._selectedNick = nick;
        this._whoisNick = whois;
        this._menu.removeAll();
        Enumeration keys = this._pixxConfiguration.getNickMenuVector().elements();
        while (keys.hasMoreElements()) {
            String[] v = (String[])keys.nextElement();
            if (v[0].equals("--")) {
                this._menu.addSeparator();
                continue;
            }
            this._menu.add(new MenuItem(v[0]));
        }
        this._menu.show(c, x, y);
    }
}

