/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.tree.Comparator;
import java.util.Locale;

class NickNameComparator
implements Comparator {
    private char[] _prefixes;

    public NickNameComparator(char[] prefixes) {
        this._prefixes = prefixes;
    }

    private int getPrefixCompareIndex(String nick) {
        if (nick.length() == 0) {
            return this._prefixes.length;
        }
        for (int i = this._prefixes.length - 1; i >= 0; --i) {
            if (nick.charAt(0) != this._prefixes[i]) continue;
            return i;
        }
        return this._prefixes.length;
    }

    public int compare(Object i1, Object i2) {
        String n1 = (String)i1;
        String n2 = (String)i2;
        n1 = n1.toLowerCase(Locale.ENGLISH).toUpperCase(Locale.ENGLISH);
        n2 = n2.toLowerCase(Locale.ENGLISH).toUpperCase(Locale.ENGLISH);
        int prefixCmp = this.getPrefixCompareIndex(n1) - this.getPrefixCompareIndex(n2);
        if (prefixCmp < 0) {
            return -1;
        }
        if (prefixCmp > 0) {
            return 1;
        }
        return n1.compareTo(n2);
    }
}

