/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import java.awt.Color;

public class PixxColorModel {
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_WHITE = 1;
    public static final int COLOR_DARK_GRAY = 2;
    public static final int COLOR_GRAY = 3;
    public static final int COLOR_LIGHT_GRAY = 4;
    public static final int COLOR_FRONT = 5;
    public static final int COLOR_BACK = 6;
    public static final int COLOR_SELECTED = 7;
    public static final int COLOR_EVENT = 8;
    public static final int COLOR_CLOSE = 9;
    public static final int COLOR_VOICE = 10;
    public static final int COLOR_OP = 11;
    public static final int COLOR_SEMIOP = 12;
    public static final int COLOR_MALE = 13;
    public static final int COLOR_FEMEALE = 14;
    public static final int COLOR_UNDEF = 15;
    private Color[] _colors;

    public PixxColorModel() {
        Color[] cols = new Color[]{new Color(5477077), new Color(0xFFFFFF), new Color(10864361), new Color(12178414), new Color(12178414), new Color(10864361), new Color(12178414), new Color(9484772), new Color(12178414), new Color(12178414), new Color(10864361), new Color(10864361), new Color(10864361), new Color(10864361), new Color(10864361), new Color(10864361)};
        this.init(cols);
    }

    public void setColor(int i, Color c) {
        if (i >= 0 && i < this._colors.length) {
            this._colors[i] = c;
        }
    }

    public int getColorCount() {
        return this._colors.length;
    }

    private Color computeColor(int r, int g, int b, int i) {
        r *= i;
        g *= i;
        b *= i;
        g /= 256;
        b /= 256;
        if ((r /= 256) > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public PixxColorModel(int r, int g, int b) {
        Color[] cols = new Color[16];
        cols[0] = Color.black;
        cols[1] = Color.white;
        cols[2] = new Color(0x868686);
        cols[3] = Color.gray;
        cols[4] = new Color(0xD0D0D0);
        cols[8] = new Color(0xA40000);
        cols[10] = new Color(32768);
        cols[13] = new Color(0x4040FF);
        cols[14] = new Color(0xFF40FF);
        cols[5] = this.computeColor(r, g, b, 102);
        cols[6] = this.computeColor(r, g, b, 85);
        cols[7] = this.computeColor(r, g, b, 75);
        cols[9] = this.computeColor(r, g, b, 128);
        cols[11] = this.computeColor(r, g, b, 102);
        cols[12] = this.computeColor(r, g, b, 102);
        cols[15] = this.computeColor(r, g, b, 102);
        this.init(cols);
    }

    public PixxColorModel(Color[] cols) {
        this.init(cols);
    }

    private void init(Color[] cols) {
        this._colors = new Color[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            this._colors[i] = cols[i];
        }
    }

    public Color getColor(int i) {
        return this._colors[i];
    }
}

