/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.IRCConfiguration;
import irc.RuleList;
import irc.TextProvider;
import irc.gui.pixx.MouseEventConfiguration;
import irc.gui.pixx.NullItem;
import irc.gui.pixx.PixxColorModel;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class PixxConfiguration {
    private IRCConfiguration _config;
    private PixxColorModel _colorModel = new PixxColorModel();
    private TextProvider _textProvider;
    private RuleList _dockingRules;
    private Hashtable _htable;
    private Hashtable _mouseConfig;
    private Vector _highLightWords;
    private Vector _nickMenuVector;
    private NullItem NULL_ITEM = new NullItem();

    public PixxConfiguration(IRCConfiguration config) {
        this._config = config;
        this._htable = new Hashtable();
        this._mouseConfig = new Hashtable();
        this._dockingRules = new RuleList();
        this._dockingRules.setDefaultValue(new Boolean(false));
        this._highLightWords = new Vector();
        this._nickMenuVector = new Vector();
    }

    public synchronized Vector getNickMenuVector() {
        return this._nickMenuVector;
    }

    public void setTextProvider(TextProvider txt) {
        this._textProvider = txt;
    }

    public synchronized void setMouseConfiguration(String eventName, int button, int count) {
        int mask;
        switch (button) {
            case 1: {
                mask = 16;
                break;
            }
            case 2: {
                mask = 8;
                break;
            }
            case 3: {
                mask = 4;
                break;
            }
            default: {
                mask = 16;
            }
        }
        this._mouseConfig.put(eventName.toLowerCase(Locale.ENGLISH), new MouseEventConfiguration(mask, count));
    }

    public synchronized boolean matchMouseConfiguration(String eventName, MouseEvent event) {
        if (this.getB("ignoreallmouseevents")) {
            return false;
        }
        MouseEventConfiguration config = (MouseEventConfiguration)this._mouseConfig.get(eventName.toLowerCase(Locale.ENGLISH));
        if (config == null) {
            throw new Error(eventName + " : unknown mouse event name");
        }
        if (config.ClickCount != event.getClickCount()) {
            return false;
        }
        return (event.getModifiers() & config.Mask) != 0;
    }

    public synchronized void set(String key, Object obj) {
        if (obj == null) {
            obj = this.NULL_ITEM;
        }
        this._htable.put(key.toLowerCase(Locale.ENGLISH), obj);
    }

    public synchronized void set(String key, int val) {
        this.set(key, new Integer(val));
    }

    public synchronized void set(String key, boolean val) {
        this.set(key, new Boolean(val));
    }

    public synchronized Object get(String key) {
        Object v = this._htable.get(key.toLowerCase(Locale.ENGLISH));
        if (v == null) {
            throw new RuntimeException("Unknown configuration property " + key);
        }
        if (v == this.NULL_ITEM) {
            v = null;
        }
        return v;
    }

    public synchronized int getI(String key) {
        Integer i = (Integer)this.get(key);
        return i;
    }

    public synchronized boolean getB(String key) {
        Boolean b = (Boolean)this.get(key);
        return b;
    }

    public synchronized String getS(String key) {
        return (String)this.get(key);
    }

    public synchronized void setHighLightConfig(int color, boolean nick, Vector words) {
        this.set("highlightcolor", color);
        this.set("highlightnick", nick);
        this._highLightWords = new Vector();
        for (int i = 0; i < words.size(); ++i) {
            this._highLightWords.insertElementAt(words.elementAt(i), this._highLightWords.size());
        }
    }

    public synchronized boolean highLightNick() {
        return this.getB("highlightnick") && this.getB("highlight");
    }

    public synchronized Enumeration getHighLightWords() {
        if (!this.getB("highlight")) {
            return new Vector().elements();
        }
        return this._highLightWords.elements();
    }

    public synchronized void addHighLightWord(String word) {
        this._highLightWords.insertElementAt(word, this._highLightWords.size());
    }

    public synchronized void removeHighLightWord(String word) {
        for (int i = 0; i < this._highLightWords.size(); ++i) {
            if (!((String)this._highLightWords.elementAt(i)).equals(word)) continue;
            this._highLightWords.removeElementAt(i);
            --i;
        }
    }

    public void setColorModel(PixxColorModel model) {
        this._colorModel = model;
    }

    public IRCConfiguration getIRCConfiguration() {
        return this._config;
    }

    public PixxColorModel getColorModel() {
        return this._colorModel;
    }

    public Color getColor(int i) {
        return this._colorModel.getColor(i);
    }

    public synchronized void setDockingPolicy(String type, String name, boolean action) {
        this._dockingRules.addRule(new String[]{type, name}, new Boolean(action));
    }

    public synchronized boolean getDockingPolicy(String type, String name) {
        return (Boolean)this._dockingRules.findValue(new String[]{type, name});
    }

    public synchronized String getText(int code) {
        if (code < 32768) {
            return this._config.getText(code);
        }
        return this._textProvider.getString(code);
    }

    public synchronized String getText(int code, String p1) {
        if (code < 32768) {
            return this._config.getText(code, p1);
        }
        return this._textProvider.getString(code, p1);
    }

    public synchronized String getText(int code, String p1, String p2) {
        if (code < 32768) {
            return this._config.getText(code, p1, p2);
        }
        return this._textProvider.getString(code, p1, p2);
    }

    public synchronized String getText(int code, String p1, String p2, String p3) {
        if (code < 32768) {
            return this._config.getText(code, p1, p2, p3);
        }
        return this._textProvider.getString(code, p1, p2, p3);
    }
}

