/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.FileTextProvider;
import irc.IRCConfiguration;
import irc.ParameterProvider;
import irc.StringParser;
import irc.TextProvider;
import irc.gui.pixx.PixxColorModel;
import irc.gui.pixx.PixxConfiguration;
import java.awt.Color;
import java.util.Locale;
import java.util.Vector;

public class PixxConfigurationLoader {
    private IRCConfiguration _config;
    private ParameterProvider _provider;

    public PixxConfigurationLoader(IRCConfiguration config) {
        this._config = config;
        this._provider = this._config.getInterfaceParameterProvider();
    }

    public PixxConfiguration loadPixxConfiguration() throws Exception {
        return this.getPixxConfiguration();
    }

    private String getParameter(String key) {
        return this._provider.getParameter(key);
    }

    private boolean getBoolean(String key, boolean def) {
        String v = this.getParameter(key);
        if (v == null) {
            return def;
        }
        return (v = v.toLowerCase(Locale.ENGLISH).trim()).equals("true") || v.equals("on") || v.equals("1");
    }

    private String getString(String key, String def) {
        String v = this.getParameter(key);
        if (v == null) {
            return def;
        }
        return v;
    }

    private int getInt(String key, int def) {
        String v = this.getParameter(key);
        if (v == null) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            return def;
        }
    }

    private TextProvider getTextProvider() {
        String lang = this.getString("language", "gui-english");
        String encoding = this.getString("languageencoding", "");
        String extension = this.getString("lngextension", "lng");
        String backlang = this.getString("backuplanguage", "pixx-english");
        String backencoding = this.getString("backuplanguageencoding", "");
        return new FileTextProvider(lang + "." + extension, encoding, backlang + "." + extension, backencoding, this._config.getFileHandler());
    }

    private String[] getArray(String name) {
        String cmd;
        Vector<String> v = new Vector<String>();
        int i = 1;
        do {
            if ((cmd = this.getParameter(name + i)) != null) {
                v.insertElementAt(cmd, v.size());
            }
            ++i;
        } while (cmd != null);
        String[] ans = new String[v.size()];
        for (i = 0; i < v.size(); ++i) {
            ans[i] = (String)v.elementAt(i);
        }
        return ans;
    }

    private void readDocking(PixxConfiguration config) {
        StringParser parser = new StringParser();
        String[] arr = this.getArray("dockingconfig");
        for (int i = 0; i < arr.length; ++i) {
            String cmd = arr[i];
            String[] back = parser.parseString(cmd);
            if (back.length < 3) continue;
            String type = back[0].toLowerCase(Locale.ENGLISH);
            String name = back[1].toLowerCase(Locale.ENGLISH);
            String action = back[2].toLowerCase(Locale.ENGLISH);
            boolean undock = false;
            if (action.equals("undock")) {
                undock = true;
            }
            config.setDockingPolicy(type, name, undock);
        }
    }

    private void readMouse(PixxConfiguration config, String name, int button, int click) throws Exception {
        String s = this.getString("mouse" + name.toLowerCase(Locale.ENGLISH), button + " " + click);
        int pos = s.indexOf(32);
        if (pos < 0) {
            throw new Exception("mouse" + name.toLowerCase(Locale.ENGLISH) + " parameter syntax error");
        }
        String before = s.substring(0, pos).trim();
        String after = s.substring(pos + 1).trim();
        config.setMouseConfiguration(name, new Integer(before), new Integer(after));
    }

    private String[] getHighLightWords() {
        String words = this.getParameter("highlightwords");
        if (words == null) {
            return new String[0];
        }
        return new StringParser().parseString(words);
    }

    private void add(Vector v, Object o) {
        v.insertElementAt(o, v.size());
    }

    public void loadDefaultPopup(PixxConfiguration config) {
        Vector v = config.getNickMenuVector();
        this.add(v, new String[]{"Private Message", "/query %1"});
        this.add(v, new String[]{"--"});
        this.add(v, new String[]{"Ignore", "/ignore %1"});
        this.add(v, new String[]{"Unignore", "/unignore %1"});
        this.add(v, new String[]{"--"});
        this.add(v, new String[]{"Host", "/mode %2 +o %1"});
        this.add(v, new String[]{"Participant", "/mode %2 +v %1"});
        this.add(v, new String[]{"Spectator", "/mode %2 -qaohv %1 %1 %1 %1 %1"});
        this.add(v, new String[]{"--"});
        this.add(v, new String[]{"Kick User", "/kick %2 %1 Disruptive Behavior"});
        this.add(v, new String[]{"Ban User", "/mode %2 +b %1!*@*", "/kick %2 %1 Disruptive Behavior [Access Ban]"});
        this.add(v, new String[]{"--"});
        this.add(v, new String[]{"Local Time", "/CTCP TIME %1"});
    }

    private void readPopup(PixxConfiguration config) {
        if (!this.getBoolean("configurepopup", false)) {
            this.loadDefaultPopup(config);
            return;
        }
        Vector v = config.getNickMenuVector();
        String[] str = this.getArray("popupmenustring");
        for (int i = 0; i < str.length; ++i) {
            String[] cmd = this.getArray("popupmenucommand" + (i + 1) + "_");
            String[] fin = new String[1 + cmd.length];
            fin[0] = str[i];
            for (int j = 0; j < cmd.length; ++j) {
                fin[j + 1] = cmd[j];
            }
            this.add(v, fin);
        }
    }

    private PixxColorModel getColorModel() {
        PixxColorModel model = new PixxColorModel();
        for (int i = 0; i < model.getColorCount(); ++i) {
            String color = this.getParameter("color" + i);
            try {
                if (color == null) continue;
                model.setColor(i, new Color(Integer.parseInt(color, 16)));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return model;
    }

    private PixxConfiguration getPixxConfiguration() throws Exception {
        PixxConfiguration config = new PixxConfiguration(this._config);
        config.setTextProvider(this.getTextProvider());
        Vector<String> v = new Vector<String>();
        String[] words = this.getHighLightWords();
        for (int i = 0; i < words.length; ++i) {
            v.insertElementAt(words[i], v.size());
        }
        config.setHighLightConfig(this.getInt("highlightcolor", 5), this.getBoolean("highlightnick", false), v);
        config.set("highlight", this.getBoolean("highlight", false));
        config.set("timestamp", this.getBoolean("timestamp", false));
        config.set("showclose", this.getBoolean("showclose", true));
        config.set("showconnect", this.getBoolean("showconnect", true));
        config.set("showchanlist", this.getBoolean("showchanlist", true));
        config.set("showabout", this.getBoolean("showabout", false));
        config.set("showhelp", this.getBoolean("showhelp", false));
        config.set("nicklistwidth", this.getInt("nicklistwidth", 150));
        config.set("nickfield", this.getBoolean("nickfield", false));
        config.set("showstatus", this.getBoolean("showstatus", true));
        config.set("styleselector", this.getBoolean("styleselector", true));
        config.set("setfontonstyle", this.getBoolean("setfontonstyle", false));
        config.set("helppage", this.getString("helppage", "http://www.frostwire.com/chat/help"));
        config.set("showchannelnickchanged", this.getBoolean("showchannelnickchanged", false));
        config.set("showchannelnickmodeapply", this.getBoolean("showchannelnickmodeapply", false));
        config.set("showchannelmodeapply", this.getBoolean("showchannelmodeapply", false));
        config.set("showchanneltopicchanged", this.getBoolean("showchanneltopicchanged", true));
        config.set("showchannelnickquit", this.getBoolean("showchannelnickquit", true));
        config.set("showchannelnickkick", this.getBoolean("showchannelnickkick", true));
        config.set("showchannelnickpart", this.getBoolean("showchannelnickpart", true));
        config.set("showchannelnickjoin", this.getBoolean("showchannelnickjoin", true));
        config.set("showdock", this.getBoolean("showdock", false));
        config.set("prefixops", this.getBoolean("prefixops", true));
        config.set("automaticqueries", this.getBoolean("automaticqueries", true));
        config.set("leftnickalign", this.getBoolean("leftnickalign", false));
        config.set("taskbaritemwidth", this.getInt("taskbaritemwidth", 100));
        config.set("scrollspeed", this.getInt("scrollspeed", 0));
        config.set("leaveonundockedwindowclose", this.getBoolean("leaveonundockedwindowclose", true));
        config.set("showchannelyoujoin", this.getBoolean("showchannelyoujoin", false));
        config.set("displayentertexthere", this.getBoolean("displayentertexthere", false));
        config.set("ignoreallmouseevents", this.getBoolean("ignoreallmouseevents", false));
        config.set("hideundockedsources", this.getBoolean("hideundockedsources", true));
        config.set("displaychannelname", this.getBoolean("displaychannelname", false));
        config.set("displaychannelmode", this.getBoolean("displaychannelmode", false));
        config.set("displaychannelcount", this.getBoolean("displaychannelcount", true));
        config.set("displaychanneltopic", this.getBoolean("displaychanneltopic", false));
        config.setColorModel(this.getColorModel());
        this.readMouse(config, "nickquery", 1, 2);
        this.readMouse(config, "urlopen", 1, 2);
        this.readMouse(config, "channeljoin", 1, 2);
        this.readMouse(config, "nickpopup", 3, 1);
        this.readMouse(config, "taskbarpopup", 3, 1);
        this.readPopup(config);
        this.readDocking(config);
        return config;
    }
}

