/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.ListenerGroup;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxPanel;
import irc.gui.pixx.PixxScrollBar;
import irc.gui.pixx.PixxScrollBarListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class PixxHorizontalScrollBar
extends PixxPanel
implements PixxScrollBar,
MouseListener,
MouseMotionListener,
Runnable {
    private double _min;
    private double _max;
    private double _val;
    private boolean _mouseDown = false;
    private boolean _mouseDownUp;
    private boolean _mouseDownDown;
    private int _base;
    private final int _arrow = 10;
    private double _view;
    private MouseEvent _repeatEvent;
    private int _repeatEventCount;
    private Thread _repeatThread;
    private ListenerGroup _listeners;

    public PixxHorizontalScrollBar(PixxConfiguration config, int min, int max, double view) {
        super(config);
        this._view = view;
        this._listeners = new ListenerGroup();
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValue(min);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void run() {
        boolean terminated = false;
        this._repeatEventCount = 0;
        while (!terminated) {
            try {
                if (this._repeatEventCount++ == 0) {
                    Thread.sleep(500L);
                } else {
                    Thread.sleep(50L);
                }
                this.mousePressed(this._repeatEvent);
            }
            catch (InterruptedException ex) {
                terminated = true;
            }
        }
    }

    public void release() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        super.release();
    }

    public void addPixxScrollBarListener(PixxScrollBarListener lis) {
        this._listeners.addListener(lis);
    }

    public void removePixxScrollBarListener(PixxScrollBarListener lis) {
        this._listeners.removeListener(lis);
    }

    private Color[] getColors(boolean invert) {
        Color[] c = new Color[5];
        if (!invert) {
            c[0] = this.getColor(5);
            c[1] = this.getColor(0);
            c[2] = this.getColor(3);
            c[3] = this.getColor(4);
            c[4] = this.getColor(1);
        } else {
            c[0] = this.getColor(7);
            c[1] = this.getColor(0);
            c[2] = this.getColor(3);
            c[3] = this.getColor(4);
            c[4] = this.getColor(1);
        }
        return c;
    }

    private void drawA(Graphics g, int pos, boolean invert) {
        int h = this.getSize().height;
        int x = pos;
        Color[] c = this.getColors(invert);
        g.setColor(c[0]);
        for (int i = 0; i < h - 5; ++i) {
            g.drawLine(x - 1, i + 3, x - 1 - i, i + 3);
        }
        g.setColor(c[1]);
        g.drawLine(x - 1, 0, x - h + 1, h - 2);
        g.setColor(c[2]);
        g.drawLine(x - 1, 1, x - h + 2, h - 2);
        g.setColor(c[4]);
        g.drawLine(x - 1, 2, x - h + 3, h - 2);
        g.setColor(c[1]);
        g.drawLine(x - 1, h - 1, x - h, h - 1);
        g.setColor(c[4]);
        g.drawLine(x - 1, h - 2, x + 3 - h, h - 2);
    }

    private void drawB(Graphics g, int pos, boolean invert) {
        int h = this.getSize().height;
        int x = pos;
        Color[] c = this.getColors(invert);
        g.setColor(c[0]);
        for (int i = 0; i < h - 5; ++i) {
            g.drawLine(x, h - 1 - i - 3, x + i, h - 1 - i - 3);
        }
        g.setColor(c[1]);
        g.drawLine(x + h - 1, 0, x, h - 1);
        g.setColor(c[2]);
        g.drawLine(x + h - 3, 1, x, h - 2);
        g.setColor(c[4]);
        g.drawLine(x + h - 4, 1, x, h - 3);
        g.setColor(c[3]);
        g.drawLine(x, 0, x + h - 2, 0);
        g.setColor(c[4]);
        g.drawLine(x, 1, x + h - 4, 1);
    }

    private void drawInside(Graphics g, int pos, int lng, boolean invert) {
        int h = this.getSize().height;
        Color[] c = this.getColors(invert);
        int x = pos;
        g.setColor(c[3]);
        g.drawLine(x, 0, x + lng - 1, 0);
        g.setColor(c[4]);
        g.drawLine(x, 1, x + lng - 1, 1);
        g.drawLine(x, h - 2, x + lng - 1, h - 2);
        g.setColor(c[1]);
        g.drawLine(x, h - 1, x + lng - 1, h - 1);
        g.setColor(c[0]);
        g.fillRect(x, 2, lng, h - 4);
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 16);
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    private int getMargin() {
        return 10 + this.getSize().height;
    }

    private int getCursorLong() {
        int h = this.getSize().width;
        int margin = this.getMargin();
        if (this._min == this._max) {
            return h - 2 * margin;
        }
        double iSee = (double)(h - 2 * margin) * this._view;
        int cursorLong = (int)(iSee / (this._max - this._min + 1.0) * (double)(h - 2 * margin));
        if (cursorLong > (h - 2 * margin) / 3) {
            cursorLong = (h - 2 * margin) / 3;
        }
        return cursorLong;
    }

    private int getPos() {
        int h;
        int lng = h = this.getSize().width;
        int margin = this.getMargin();
        int cursorLong = this.getCursorLong();
        return (int)((this._val * (double)(lng - margin - cursorLong) + (this._max - this._val) * (double)margin) / this._max - (double)margin);
    }

    public void update(Graphics g) {
        Graphics gra;
        Image buffer;
        int w = this.getSize().width;
        int h = this.getSize().height;
        int margin = this.getMargin();
        int cursorLong = this.getCursorLong();
        try {
            buffer = this.createImage(w, h);
            gra = buffer.getGraphics();
        }
        catch (Throwable e) {
            return;
        }
        gra.setColor(this.getColor(6));
        gra.fillRect(0, 0, w, h);
        this.drawInside(gra, 2, 8, this._mouseDownUp);
        this.drawB(gra, margin - h, this._mouseDownUp);
        Color[] c = this.getColors(this._mouseDownUp);
        gra.setColor(c[3]);
        gra.drawLine(0, 1, 0, h - 2);
        gra.drawLine(0, 0, 1, 0);
        gra.setColor(c[4]);
        gra.drawLine(1, 1, 1, h - 2);
        gra.setColor(c[1]);
        gra.drawLine(0, h - 1, 1, h - 1);
        gra.setColor(c[4]);
        gra.drawLine(4, h / 2, 4 + h / 4 - 1, h / 4 + 1);
        gra.drawLine(4, h / 2, 4 + h / 4 - 1, 3 * h / 4 - 1);
        this.drawInside(gra, w - 10, 8, this._mouseDownDown);
        this.drawA(gra, w - margin + h, this._mouseDownDown);
        c = this.getColors(this._mouseDownDown);
        gra.setColor(c[3]);
        gra.drawLine(w - 2, 0, w - 1, 0);
        gra.setColor(c[1]);
        gra.drawLine(w - 2, h - 1, w - 1, h - 1);
        gra.drawLine(w - 1, 1, w - 1, h - 2);
        gra.setColor(c[4]);
        gra.drawLine(w - 2, 1, w - 2, h - 2);
        gra.setColor(c[4]);
        gra.drawLine(w - 5, h / 2, w - 5 - h / 4 + 1, h / 4 + 1);
        gra.drawLine(w - 5, h / 2, w - 5 - h / 4 + 1, 3 * h / 4 - 1);
        int pos = this.getPos() + margin;
        this.drawInside(gra, pos, cursorLong, this._mouseDown);
        this.drawA(gra, pos, this._mouseDown);
        this.drawB(gra, pos + cursorLong, this._mouseDown);
        g.drawImage(buffer, 0, 0, this);
    }

    public void setMinimum(int v) {
        this._min = v;
        if (this._min > this._max) {
            this._min = this._max;
        }
        if (this._val < this._min) {
            this.updateValue(this._min);
        }
        this.repaint();
    }

    public void setMaximum(int v) {
        this._max = v;
        if (this._max < this._min) {
            this._max = this._min;
        }
        if (this._val > this._max) {
            this.updateValue(this._max);
        }
        this.repaint();
    }

    public void setValue(int v) {
        this._val = v;
        if (this._val < this._min) {
            this._val = this._min;
        }
        if (this._val > this._max) {
            this._val = this._max;
        }
        this.repaint();
    }

    public int getValue() {
        return (int)(this._val + 0.5);
    }

    private boolean inCursor(int x, int y) {
        int h = this.getSize().height;
        int l = this.getCursorLong();
        x -= this.getMargin();
        return (x -= this.getPos()) + y >= -1 && y + x - l - h <= -1;
    }

    private boolean inSubArrow(int x, int y) {
        return (x -= this.getMargin()) + y <= -1;
    }

    private boolean inAddArrow(int x, int y) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        return y + x - w + this.getMargin() - h >= -1;
    }

    private double getValue(int x, int y) {
        int w;
        int lng = w = this.getSize().width;
        int margin = this.getMargin();
        int px = x - margin - this._base;
        return (this._max - this._min) * (double)px / (double)(lng -= margin * 2 + this.getCursorLong()) + this._min;
    }

    private void updateValue(double v) {
        int oldVal = this.getValue();
        this._val = v;
        if (this._val < this._min) {
            this._val = this._min;
        }
        if (this._val > this._max) {
            this._val = this._max;
        }
        this.repaint();
        if (this.getValue() != oldVal) {
            this._listeners.sendEventAsync("valueChanged", this);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void beginRepeat(MouseEvent e) {
        this._repeatEvent = e;
        this._repeatThread = new Thread((Runnable)this, "Scrolling thread");
        this._repeatThread.start();
    }

    private void endRepeat() {
        if (this._repeatThread != null) {
            try {
                this._repeatThread.interrupt();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this._repeatThread.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._repeatThread = null;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.inCursor(e.getX(), e.getY())) {
            this._base = e.getX() - this.getMargin() - this.getPos();
            this._mouseDown = true;
            this.repaint();
            return;
        }
        if (this.inSubArrow(e.getX(), e.getY())) {
            this._mouseDownUp = true;
            this.updateValue(this._val - 1.0);
            this.repaint();
        } else if (this.inAddArrow(e.getX(), e.getY())) {
            this._mouseDownDown = true;
            this.updateValue(this._val + 1.0);
            this.repaint();
        } else if (this.getValue(e.getX(), e.getY()) < this._val) {
            this.updateValue(this._val - 10.0);
            this.repaint();
        } else if (this.getValue(e.getX(), e.getY()) > this._val) {
            this.updateValue(this._val + 10.0);
            this.repaint();
        }
        if (this._repeatThread == null) {
            this.beginRepeat(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.endRepeat();
        this._mouseDown = false;
        this._mouseDownUp = false;
        this._mouseDownDown = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        this._repeatEvent = e;
        if (this._mouseDown) {
            this.updateValue(this.getValue(e.getX(), e.getY()));
        }
    }
}

