/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.ChanList;
import irc.Channel;
import irc.DefaultSource;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.Interpretor;
import irc.Query;
import irc.Server;
import irc.Source;
import irc.Status;
import irc.StyleContext;
import irc.dcc.DCCChat;
import irc.dcc.DCCFile;
import irc.gui.GUISource;
import irc.gui.IRCInterface;
import irc.gui.common.DockablePanel;
import irc.gui.common.DockablePanelListener;
import irc.gui.common.MouseWheelPanelListener;
import irc.gui.pixx.AWTChanList;
import irc.gui.pixx.AWTChannel;
import irc.gui.pixx.AWTDCCChat;
import irc.gui.pixx.AWTDCCFile;
import irc.gui.pixx.AWTDefaultSource;
import irc.gui.pixx.AWTInterpretor;
import irc.gui.pixx.AWTQuery;
import irc.gui.pixx.AWTStatus;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.BaseAWTSourceListener;
import irc.gui.pixx.MDILayout;
import irc.gui.pixx.NonFocusableTextField;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxConfigurationLoader;
import irc.gui.pixx.PixxMenuBar;
import irc.gui.pixx.PixxMenuBarListener;
import irc.gui.pixx.PixxPanel;
import irc.gui.pixx.PixxSeparator;
import irc.gui.pixx.PixxTaskBar;
import irc.gui.pixx.PixxTaskBarListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class PixxMDIInterface
extends IRCInterface
implements PixxTaskBarListener,
PixxMenuBarListener,
ActionListener,
MouseWheelPanelListener,
BaseAWTSourceListener,
DockablePanelListener {
    private PixxPanel _panel;
    private PixxMenuBar _menu;
    private PixxTaskBar _task;
    private Panel _mdi;
    private PopupMenu _popMenu;
    private TextField _nickField;
    private Hashtable _awt2Dock;
    private AWTInterpretor _interpretor;
    private PixxConfiguration _pixxConfiguration;
    private Hashtable _status;
    private Hashtable _channels;
    private Hashtable _queries;
    private Hashtable _dccChats;
    private Hashtable _dccFiles;
    private Hashtable _lists;
    private DefaultSource _defaultSource;
    private AWTDefaultSource _awtDefaultSource;

    public PixxMDIInterface(IRCConfiguration config) throws Exception {
        super(config);
    }

    public void load() {
        super.load();
        try {
            this._ircConfiguration.setGUIInfoString("Pixx's designed interface");
            this._pixxConfiguration = new PixxConfigurationLoader(this._ircConfiguration).loadPixxConfiguration();
            this._panel = new PixxPanel(this._pixxConfiguration);
            this._defaultSource = null;
            this._task = new PixxTaskBar(this._pixxConfiguration);
            this._interpretor = new AWTInterpretor(this._pixxConfiguration, this);
            this._awt2Dock = new Hashtable();
            this._popMenu = new PopupMenu();
            this._panel.setLayout(new BorderLayout());
            this._mdi = new Panel();
            this._mdi.setLayout(new MDILayout());
            this._mdi.setBackground(Color.white);
            this._task.add(this._popMenu);
            this._popMenu.addActionListener(this);
            this._task.addPixxTaskBarListener(this);
            this._menu = new PixxMenuBar(this._pixxConfiguration, true);
            this._menu.addPixxMenuBarListener(this);
            this._panel.add((Component)this._menu, "North");
            this._panel.add((Component)this._mdi, "Center");
            this._nickField = new NonFocusableTextField("");
            this._nickField.addActionListener(this);
            this._nickField.setBackground(this._pixxConfiguration.getColor(1));
            if (!this._pixxConfiguration.getB("nickfield")) {
                this._panel.add((Component)this._task, "South");
            } else {
                Panel bottom = new Panel();
                bottom.setLayout(new BorderLayout());
                bottom.add((Component)this._task, "Center");
                Panel nickConfig = new Panel();
                nickConfig.setLayout(new BorderLayout());
                Label label = new Label("Change nickname to:");
                label.setBackground(this._pixxConfiguration.getColor(6));
                label.setForeground(this._pixxConfiguration.getColor(1));
                Panel outerNickLabel = new Panel();
                outerNickLabel.setLayout(new BorderLayout());
                outerNickLabel.add((Component)label, "Center");
                outerNickLabel.add((Component)new PixxSeparator(2), "West");
                outerNickLabel.add((Component)new PixxSeparator(3), "East");
                outerNickLabel.add((Component)new PixxSeparator(0), "North");
                outerNickLabel.add((Component)new PixxSeparator(1), "South");
                nickConfig.add((Component)outerNickLabel, "North");
                nickConfig.add((Component)this._nickField, "Center");
                bottom.add((Component)nickConfig, "East");
                this._panel.add((Component)bottom, "South");
            }
            this._channels = new Hashtable();
            this._queries = new Hashtable();
            this._dccChats = new Hashtable();
            this._dccFiles = new Hashtable();
            this._lists = new Hashtable();
            this._status = new Hashtable();
            this._panel.validate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Error(ex.getMessage());
        }
    }

    public Component getComponent() {
        return this._panel;
    }

    public void unload() {
        this.removeAWTDefault();
        this._popMenu.removeActionListener(this);
        this._task.removePixxTaskBarListener(this);
        this._menu.removePixxMenuBarListener(this);
        this._nickField.removeActionListener(this);
        this._task = null;
        this._menu = null;
        this._popMenu = null;
        this._awt2Dock = null;
        this._panel.release();
        this._panel = null;
        this._pixxConfiguration = null;
        super.unload();
    }

    private void addAWTDefault() {
        if (this._defaultSource == null) {
            return;
        }
        if (this._awtDefaultSource == null) {
            this._awtDefaultSource = new AWTDefaultSource(this._pixxConfiguration, this._defaultSource);
            this._task.addDefaultSource(this._awtDefaultSource, true);
        }
    }

    private void removeAWTDefault() {
        if (this._awtDefaultSource == null) {
            return;
        }
        this._task.removeDefaultSource(this._awtDefaultSource);
        this._awtDefaultSource.release();
        this._awtDefaultSource = null;
    }

    private void channelCreated(Channel chan, Boolean bring) {
        AWTChannel awt = new AWTChannel(this._pixxConfiguration, chan);
        awt.addBaseAWTSourceListener(this);
        this._task.addChannel(awt, bring);
        this._channels.put(chan, awt);
    }

    private void channelRemoved(Channel chan) {
        AWTChannel s = (AWTChannel)this._channels.get(chan);
        s.removeBaseAWTSourceListener(this);
        this._task.removeChannel(s);
        this._channels.remove(chan);
    }

    private void queryCreated(Query query, Boolean bring) {
        AWTQuery awt = new AWTQuery(this._pixxConfiguration, query);
        awt.addBaseAWTSourceListener(this);
        this._task.addQuery(awt, bring);
        this._queries.put(query, awt);
        if (!bring.booleanValue()) {
            this._pixxConfiguration.getIRCConfiguration().getAudioConfiguration().onQuery();
        }
    }

    private void queryRemoved(Query query) {
        AWTQuery q = (AWTQuery)this._queries.get(query);
        q.removeBaseAWTSourceListener(this);
        this._task.removeQuery(q);
        this._queries.remove(query);
    }

    private void statusCreated(Status status, Boolean bring) {
        AWTStatus awt = new AWTStatus(this._pixxConfiguration, status);
        this._task.addStatus(awt, bring);
        awt.addBaseAWTSourceListener(this);
        this._status.put(status, awt);
    }

    private void statusRemoved(Status status) {
        AWTStatus s = (AWTStatus)this._status.get(status);
        s.removeBaseAWTSourceListener(this);
        this._task.removeStatus(s);
        this._status.remove(status);
    }

    private void chanListCreated(ChanList list, Boolean bring) {
        AWTChanList cl = new AWTChanList(this._pixxConfiguration, list);
        this._task.addChanList(cl, bring);
        cl.addBaseAWTSourceListener(this);
        this._lists.put(list, cl);
    }

    private void chanListRemoved(ChanList list) {
        AWTChanList l = (AWTChanList)this._lists.get(list);
        l.removeBaseAWTSourceListener(this);
        this._task.removeChanList(l);
        this._lists.remove(list);
    }

    private void DCCChatCreated(DCCChat chat, Boolean bbring) {
        boolean bring = bbring;
        AWTDCCChat awt = new AWTDCCChat(this._pixxConfiguration, chat);
        awt.addBaseAWTSourceListener(this);
        this._task.addDCCChat(awt, bring);
        this._dccChats.put(chat, awt);
    }

    private void DCCChatRemoved(DCCChat chat) {
        AWTDCCChat c = (AWTDCCChat)this._dccChats.get(chat);
        c.removeBaseAWTSourceListener(this);
        this._task.removeDCCChat(c);
        this._dccChats.remove(chat);
    }

    public void DCCFileCreated(DCCFile file, Boolean bring) {
        this._dccFiles.put(file, new AWTDCCFile(this._pixxConfiguration, file));
    }

    public void DCCFileRemoved(DCCFile file) {
        AWTDCCFile f = (AWTDCCFile)this._dccFiles.get(file);
        this._dccFiles.remove(file);
        f.close();
        f.release();
    }

    public void sourceCreated(Source source, Boolean bring) {
        if (source instanceof DefaultSource) {
            this._defaultSource = (DefaultSource)source;
            if (this._pixxConfiguration.getIRCConfiguration().getB("multiserver")) {
                this.addAWTDefault();
            }
        }
        if (source instanceof Channel) {
            this.channelCreated((Channel)source, bring);
        }
        if (source instanceof Query) {
            this.queryCreated((Query)source, bring);
        }
        if (source instanceof Status && this._pixxConfiguration.getB("showstatus")) {
            this.statusCreated((Status)source, bring);
        }
        if (source instanceof ChanList) {
            this.chanListCreated((ChanList)source, bring);
        }
        if (source instanceof DCCChat) {
            this.DCCChatCreated((DCCChat)source, bring);
        }
        if (source instanceof DCCFile) {
            this.DCCFileCreated((DCCFile)source, bring);
        }
    }

    public void sourceRemoved(Source source) {
        if (source instanceof DefaultSource) {
            this._defaultSource = null;
            this.removeAWTDefault();
        }
        if (source instanceof Channel) {
            this.channelRemoved((Channel)source);
        }
        if (source instanceof Query) {
            this.queryRemoved((Query)source);
        }
        if (source instanceof Status && this._pixxConfiguration.getB("showstatus")) {
            this.statusRemoved((Status)source);
        }
        if (source instanceof ChanList) {
            this.chanListRemoved((ChanList)source);
        }
        if (source instanceof DCCChat) {
            this.DCCChatRemoved((DCCChat)source);
        }
        if (source instanceof DCCFile) {
            this.DCCFileRemoved((DCCFile)source);
        }
    }

    public void serverCreated(Server s) {
    }

    public void serverConnected(Server s) {
        this.updateConnect();
    }

    public void serverDisconnected(Server s) {
        this.updateConnect();
    }

    public void serverRemoved(Server s) {
    }

    public void setTitle(String title, StyleContext context) {
        this._menu.setTitle(title, context);
    }

    public void setConnected(boolean b) {
        this._menu.setConnected(b);
    }

    private void test() {
        this.updateConnect();
        if (this._task.getActive() != null) {
            this.setTitle(this._task.getActive().getTitle(), this._task.getActive().getStyleContext());
        } else {
            this.setTitle("", this._pixxConfiguration.getIRCConfiguration().getDefaultStyleContext());
        }
        this.triggerActiveChanged(this._task.getActive());
    }

    public GUISource getActive() {
        return this._task.getActive();
    }

    public void setActive(GUISource source) {
        this._task.activate((BaseAWTSource)source);
    }

    public GUISource getGUISource(Source source) {
        if (source instanceof DefaultSource) {
            return this._awtDefaultSource;
        }
        if (source instanceof Channel) {
            return (GUISource)this._channels.get(source);
        }
        if (source instanceof Query) {
            return (GUISource)this._queries.get(source);
        }
        if (source instanceof Status) {
            return (GUISource)this._status.get(source);
        }
        if (source instanceof ChanList) {
            return (GUISource)this._lists.get(source);
        }
        if (source instanceof DCCChat) {
            return (GUISource)this._dccChats.get(source);
        }
        if (source instanceof DCCFile) {
            return (GUISource)this._dccFiles.get(source);
        }
        return null;
    }

    private DockablePanel createSource(BaseAWTSource asource) {
        DockablePanel source = new DockablePanel(asource, this._panel.getColor(6));
        source.addDockablePanelListener(this);
        source.setClosingBehaviour(1);
        this._awt2Dock.put(asource, source);
        return source;
    }

    private DockablePanel getSource(BaseAWTSource source) {
        return (DockablePanel)this._awt2Dock.get(source);
    }

    private void deleteSource(BaseAWTSource source) {
        DockablePanel panel = this.getSource(source);
        if (panel != null) {
            panel.removeDockablePanelListener(this);
        }
        this._awt2Dock.remove(source);
    }

    public void dock(BaseAWTSource source) {
        this.getSource(source).dock();
        source.requestFocus();
        if (this._pixxConfiguration.getB("hideundockedsources")) {
            this._task.show(source);
        }
    }

    public void undock(BaseAWTSource source) {
        DockablePanel todock = this.getSource(source);
        BaseAWTSource[] srcs = this._task.getZOrderedSources();
        for (int i = 0; i < srcs.length; ++i) {
            DockablePanel dock = this.getSource(srcs[i]);
            if (!dock.isDocked() || dock == todock) continue;
            this._task.activate(srcs[i]);
            break;
        }
        todock.undock(source.getShortTitle());
        source.requestFocus();
        if (this._pixxConfiguration.getB("hideundockedsources")) {
            this._task.hide(source);
        }
    }

    public boolean isDocked(BaseAWTSource source) {
        return this.getSource(source).isDocked();
    }

    public Interpretor getInterpretor() {
        return this._interpretor;
    }

    public BaseAWTSource findBaseAWTSource(Source src) {
        Enumeration e = this._awt2Dock.keys();
        while (e.hasMoreElements()) {
            BaseAWTSource asrc = (BaseAWTSource)e.nextElement();
            if (asrc.getSource() != src) continue;
            return asrc;
        }
        return null;
    }

    public void AWTSourceAdded(PixxTaskBar bar, BaseAWTSource asource) {
        DockablePanel source = this.createSource(asource);
        this._mdi.add(source);
        source.setVisible(false);
        this._panel.validate();
        this.test();
        if (this._pixxConfiguration.getDockingPolicy(asource.getSource().getType().toLowerCase(Locale.ENGLISH), asource.getSource().getName().toLowerCase(Locale.ENGLISH))) {
            this.undock(asource);
        }
    }

    public void AWTSourceRemoved(PixxTaskBar bar, BaseAWTSource asource) {
        DockablePanel source = this.getSource(asource);
        source.dock();
        this.deleteSource(asource);
        this._mdi.remove(source);
        source.release();
        this._panel.validate();
        this.test();
    }

    public void AWTSourceDesactivated(PixxTaskBar bar, BaseAWTSource asource) {
        DockablePanel source = this.getSource(asource);
        this._panel.setBackground(this._ircConfiguration.getStyleColors(asource.getStyleContext())[0]);
        source.setVisible(false);
        this._panel.validate();
        this.test();
    }

    public void AWTSourceActivated(PixxTaskBar bar, BaseAWTSource asource) {
        if (asource != null) {
            DockablePanel source = this.getSource(asource);
            source.setVisible(true);
            this._panel.validate();
            source.requestFocus();
            source.bring();
        }
        this.test();
    }

    public void eventOccured(PixxTaskBar bar, BaseAWTSource asource, MouseEvent e) {
        DockablePanel source = this.getSource(asource);
        if (this._pixxConfiguration.matchMouseConfiguration("taskbarpopup", e)) {
            bar.activate(asource);
            this._popMenu.removeAll();
            this._popMenu.add(new MenuItem("Close"));
            this._popMenu.show(this._task, e.getX(), e.getY());
        }
        source.requestFocus();
    }

    public void actionPerformed(ActionEvent e) {
        EventDispatcher.dispatchEventAsync(this, "actionPerformedEff", new Object[]{e});
    }

    public void actionPerformedEff(ActionEvent e) {
        if (e.getActionCommand().equals("Close")) {
            BaseAWTSource src = this._task.getActive();
            if (src != null) {
                src.leave();
            }
        } else if (e.getSource() == this._nickField) {
            BaseAWTSource src = this._task.getActive();
            if (src == null) {
                return;
            }
            src.getSource().sendString("/nick " + this._nickField.getText());
        }
    }

    public void connectionClicked(PixxMenuBar bar) {
        GUISource current = this.getActiveSource();
        if (current == null) {
            return;
        }
        Server currentServer = current.getSource().getServer();
        if (currentServer == null) {
            return;
        }
        if (currentServer.isConnected()) {
            currentServer.disconnect();
        } else {
            currentServer.connect();
        }
    }

    public void chanListClicked(PixxMenuBar bar) {
        BaseAWTSource src = this._task.getActive();
        if (src == null) {
            return;
        }
        src.getSource().sendString("/list");
    }

    public void aboutClicked(PixxMenuBar bar) {
        this._pixxConfiguration.getIRCConfiguration().displayAboutPage();
    }

    public void helpClicked(PixxMenuBar bar) {
        IRCConfiguration cfg = this._pixxConfiguration.getIRCConfiguration();
        if (this._pixxConfiguration.getS("helppage") != null) {
            cfg.getURLHandler().openURL(this._pixxConfiguration.getS("helppage"));
        }
    }

    public void closeClicked(PixxMenuBar bar) {
        BaseAWTSource src = this._task.getActive();
        if (src == null) {
            return;
        }
        src.leave();
    }

    public void dockClicked(PixxMenuBar bar) {
        BaseAWTSource src = this._task.getActive();
        if (src == null) {
            return;
        }
        if (this.isDocked(src)) {
            this.undock(src);
        } else {
            this.dock(src);
        }
    }

    public void mouseWheelMoved(Integer amount) {
        BaseAWTSource src = this._task.getActive();
        if (src == null) {
            return;
        }
        src.mouseWheelMoved(amount);
    }

    private void updateConnect() {
        BaseAWTSource active = this._task.getActive();
        if (active == null) {
            return;
        }
        Server currentServer = active.getSource().getServer();
        this.setConnected(currentServer.isConnected());
    }

    public GUISource getActiveSource() {
        return this._task.getActive();
    }

    public void titleChanged(BaseAWTSource source) {
        if (source != this.getActive()) {
            return;
        }
        this.setTitle(source.getTitle(), source.getStyleContext());
    }

    public void eventOccured(BaseAWTSource source) {
    }

    public void DockablePanelWindowClosing(DockablePanel panel) {
        Enumeration e = this._awt2Dock.keys();
        while (e.hasMoreElements()) {
            BaseAWTSource source = (BaseAWTSource)e.nextElement();
            if (this._awt2Dock.get(source) != panel) continue;
            if (this._pixxConfiguration.getB("leaveonundockedwindowclose")) {
                source.leave();
            } else {
                panel.dock();
            }
            this._task.show(source);
        }
    }

    public void DockablePanelWindowClosed(DockablePanel panel) {
    }
}

