/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.IRCConfiguration;
import irc.ListenerGroup;
import irc.StyleContext;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxMenuBarListener;
import irc.gui.pixx.PixxPanel;
import irc.style.DecodedLine;
import irc.style.DrawResult;
import irc.style.FormattedStringDrawer;
import irc.style.FormattedStringDrawerListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class PixxMenuBar
extends PixxPanel
implements MouseListener,
MouseMotionListener,
Runnable,
FormattedStringDrawerListener {
    private int _pressedIndex;
    private boolean _closePressed;
    private boolean _dockPressed;
    private ListenerGroup _listeners;
    private boolean _connected;
    private boolean _title;
    private Image _buffer;
    private FormattedStringDrawer _drawer;
    private String _titleString;
    private DecodedLine _decodedTitle;
    private int _connectIndex;
    private int _chanlistIndex;
    private int _aboutIndex;
    private int _helpIndex;
    private int _titleLeft = 0;
    private int _mouseDownX;
    private boolean _mouseScroll;
    private DrawResult _drawResult;
    private boolean _terminated;
    private boolean _redrawTitle;
    private Thread _scrollThread;
    private Object _scrollLock;
    private boolean _freeze;
    private int _scrollDelay;

    public PixxMenuBar(PixxConfiguration config) {
        this(config, false);
    }

    public PixxMenuBar(PixxConfiguration config, boolean title) {
        super(config);
        this._title = title;
        this._mouseScroll = false;
        this._titleString = "";
        IRCConfiguration _ircConfiguration = config.getIRCConfiguration();
        this._drawer = new FormattedStringDrawer(_ircConfiguration, _ircConfiguration.getDefaultStyleContext(), this);
        this._decodedTitle = this._drawer.decodeLine(this._titleString);
        this._connected = false;
        this._pressedIndex = -1;
        this._closePressed = false;
        this._dockPressed = false;
        this._listeners = new ListenerGroup();
        int currentIndex = 0;
        if (config.getB("showconnect")) {
            this._connectIndex = currentIndex++;
        }
        if (config.getB("showchanlist")) {
            this._chanlistIndex = currentIndex++;
        }
        if (config.getB("showabout")) {
            this._aboutIndex = currentIndex++;
        }
        if (config.getB("showhelp")) {
            this._helpIndex = currentIndex++;
        }
        this._scrollDelay = config.getI("scrollspeed");
        if (this._scrollDelay != 0) {
            this._scrollDelay = 1000 / this._scrollDelay;
        }
        this._drawResult = new DrawResult();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._terminated = false;
        this._redrawTitle = false;
        this._scrollLock = new Object();
        if (this._scrollDelay > 0) {
            this._scrollThread = new Thread(this);
            this._scrollThread.start();
        }
    }

    public void release() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        super.release();
    }

    public void setTitle(String title, StyleContext context) {
        this._drawer.setStyleContext(context);
        this._titleString = title;
        this._decodedTitle = this._drawer.decodeLine(this._titleString);
        this._buffer = null;
        this.repaint();
    }

    public void addPixxMenuBarListener(PixxMenuBarListener lis) {
        this._listeners.addListener(lis);
    }

    public void removePixxMenuBarListener(PixxMenuBarListener lis) {
        this._listeners.removeListener(lis);
    }

    public void setConnected(boolean b) {
        this._connected = b;
        this._buffer = null;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this._title) {
            return new Dimension(16, this.getItemHeight() + this.getTitleHeight() + 4);
        }
        return new Dimension(16, this.getItemHeight() + 4);
    }

    private int getClosePositionX() {
        int w = this.getSize().width;
        return w - 18;
    }

    private int getClosePositionY() {
        return this.getY(0) + 1;
    }

    private int getDockPositionX() {
        int w = this.getSize().width;
        if (!this._pixxConfiguration.getB("showclose")) {
            return w - 18;
        }
        return w - 18 - 18;
    }

    private int getDockPositionY() {
        return this.getY(0) + 1;
    }

    private boolean isClosePressed(int x, int y) {
        if (!this._pixxConfiguration.getB("showclose")) {
            return false;
        }
        if ((x -= this.getClosePositionX()) < 0) {
            return false;
        }
        if (x >= 16) {
            return false;
        }
        if ((y -= this.getClosePositionY()) < 0) {
            return false;
        }
        return y < 16;
    }

    private boolean isDockPressed(int x, int y) {
        if (!this._pixxConfiguration.getB("showdock")) {
            return false;
        }
        if ((x -= this.getDockPositionX()) < 0) {
            return false;
        }
        if (x >= 16) {
            return false;
        }
        if ((y -= this.getDockPositionY()) < 0) {
            return false;
        }
        return y < 16;
    }

    private int getItemWidth() {
        return 100;
    }

    private int getItemHeight() {
        return 17;
    }

    private int getIconWidth() {
        return 16;
    }

    private int getIconHeight() {
        return this.getItemHeight() - 4;
    }

    private int getX(int pos) {
        return pos * (this.getItemWidth() + 8) + 2;
    }

    private int getPos(int x) {
        return (x - 2) / (this.getItemWidth() + 8);
    }

    private int getY(int pos) {
        if (!this._title) {
            return 2;
        }
        return 2 + this.getTitleHeight() * 0;
    }

    private int getTitleY() {
        return this.getItemHeight() + 4;
    }

    private int getTitleHeight() {
        return 18;
    }

    private int getIndex(int x) {
        int pos = this.getPos(x);
        if (pos < 0) {
            return -1;
        }
        if (pos > 4) {
            return -1;
        }
        if ((x -= this.getX(pos)) >= this.getItemWidth()) {
            return -1;
        }
        return pos;
    }

    private int getIndex(int x, int y) {
        if (y < this.getY(0)) {
            return -1;
        }
        if ((y -= this.getY(0)) >= this.getItemHeight()) {
            return -1;
        }
        return this.getIndex(x);
    }

    private void drawTitle(Graphics g, int y) {
        int w = this.getSize().width;
        g.setColor(this._drawer.getColor(0));
        g.fillRect(0, y, w, this.getTitleHeight());
        g.setClip(0, y, w, this.getTitleHeight());
        this._drawer.draw(this._decodedTitle, g, 5 + this._titleLeft, w - 5 + this._titleLeft, y + this.getTitleHeight() - 2, 0, w - 1, false, false, this._drawResult);
        g.setClip(0, 0, this.getSize().width, this.getSize().height);
        this.drawSeparator(g, 0, y, w, this.getTitleHeight());
    }

    private void drawDisconnectIcon(Graphics g, int x, int y) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        g.setColor(new Color(0xEFEFEF));
        g.fillRect(x, y, w, h);
        g.setColor(new Color(0xAFAFAF));
        g.drawLine(x, y + h / 2 - 1, x + 5, y + h / 2 - 1);
        g.drawLine(x + w - 1, y + h / 2 - 1, x + w - 5, y + h / 2 - 1);
        g.setColor(Color.black);
        g.drawLine(x, y + h / 2, x + 4, y + h / 2);
        g.drawLine(x + w - 1, y + h / 2, x + w - 6, y + h / 2);
        g.drawLine(x + 4, y + h / 2 + 1, x + 7, y + h / 2 - 2);
        g.drawLine(x + 8, y + h / 2 + 1, x + 11, y + h / 2 - 2);
    }

    private void drawConnectIcon(Graphics g, int x, int y) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        g.setColor(new Color(0xEFEFEF));
        g.fillRect(x, y, w, h);
        g.setColor(new Color(0xA2A2A2));
        g.drawLine(x, y + h / 2 - 1, x + w - 1, y + h / 2 - 1);
        g.setColor(Color.black);
        g.drawLine(x, y + h / 2, x + w - 1, y + h / 2);
        g.setColor(new Color(0x960000));
        g.drawLine(x + 2, y + 2, x + 14, y + 2);
        g.drawLine(x + 12, y, x + 14, y + 2);
        g.drawLine(x + 12, y + 4, x + 14, y + 2);
        g.setColor(new Color(2775952));
        g.drawLine(x + 2, y + 9, x + 14, y + 9);
        g.drawLine(x + 2, y + 9, x + 4, y + 7);
        g.drawLine(x + 2, y + 9, x + 4, y + 11);
    }

    private void drawChanListIcon(Graphics g, int x, int y) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        g.setColor(new Color(0xEFEFEF));
        g.fillRect(x, y, w, h);
        g.setColor(Color.black);
        g.drawLine(++x, y + 1, x + 9, y + 1);
        g.drawLine(x, y + 3, x + 5, y + 3);
        g.drawLine(x, y + 5, x + 12, y + 5);
        g.drawLine(x, y + 7, x + 11, y + 7);
        g.drawLine(x, y + 9, x + 9, y + 9);
        g.drawLine(x, y + 11, x + 13, y + 11);
    }

    private void drawHelpIcon(Graphics g, int x, int y) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        g.setColor(new Color(0xEFEFEF));
        g.fillRect(x, y, w, h);
        g.setColor(Color.black);
        g.fillRect((x += 4) + 0, ++y + 0, 2, 3);
        g.fillRect(x + 2, y + 0, 4, 2);
        g.fillRect(x + 6, y + 0, 2, 6);
        g.fillRect(x + 3, y + 4, 3, 2);
        g.fillRect(x + 3, y + 6, 2, 2);
        g.fillRect(x + 3, y + 9, 2, 2);
    }

    private void drawAboutIcon(Graphics g, int x, int y) {
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        g.setColor(new Color(0xEFEFEF));
        g.fillRect(x, y, w, h);
        g.setColor(Color.black);
        g.drawLine(x + 5, y + 4, x + 8, y + 4);
        g.drawLine(x + 5, y + 11, x + 10, y + 11);
        g.fillRect(x + 7, y + 4, 2, 7);
        g.fillRect(x + 7, y + 1, 2, 2);
    }

    private void drawCloseButtonCross(Graphics g, int x, int y) {
        int w = 13;
        int h = 11;
        g.setColor(this.getColor(9));
        g.fillRect(x, y, w, h);
        g.setColor(this.getColor(0));
        for (int i = 0; i < 4; ++i) {
            g.drawLine(x + 3 + i, y + 2 + i, x + 4 + i, y + 2 + i);
            g.drawLine(x + 9 - i, y + 2 + i, x + 10 - i, y + 2 + i);
            g.drawLine(x + 3 + i, y + 8 - i, x + 4 + i, y + 8 - i);
            g.drawLine(x + 9 - i, y + 8 - i, x + 10 - i, y + 8 - i);
        }
    }

    private void drawDockButtonInternal(Graphics g, int x, int y) {
        int w = 13;
        int h = 11;
        g.setColor(this.getColor(9));
        g.fillRect(x, y, w, h);
        g.setColor(this.getColor(0));
        int ox = 4;
        int oy = 1;
        g.drawRect(x + ox, y + oy, 6, 5);
        g.drawLine(x + ox + 1, y + oy + 1, x + ox + 6, y + oy + 1);
        ox = 2;
        oy = 4;
        g.setColor(this.getColor(0));
        g.drawRect(x + ox, y + oy, 6, 5);
        g.drawLine(x + ox + 1, y + oy + 1, x + ox + 6, y + oy + 1);
        g.setColor(this.getColor(9));
        g.fillRect(x + ox + 1, y + oy + 2, 5, 3);
    }

    private void drawItem(Graphics g, int x, int y, boolean selected, String s) {
        int w = this.getItemWidth();
        int h = this.getItemHeight();
        int iw = this.getIconWidth();
        g.setColor(this.getColor(5));
        if (selected) {
            g.setColor(this.getColor(7));
        }
        g.fillRect(x, y, w, h);
        g.setColor(this.getColor(0));
        g.drawRect(x, y, w - 1, h - 1);
        g.setColor(this.getColor(1));
        g.drawRect(x + 1, y + 1, w - 3, h - 3);
        g.drawLine(x + iw + 2, y + 1, x + iw + 2, y + h - 2);
        int sw = g.getFontMetrics().stringWidth(s);
        g.drawString(s, x + iw + 3 + ((w -= 5 + iw) - sw) / 2, y + h - 4);
    }

    private void drawDisconnectItem(Graphics g, int x, int y, boolean pressed) {
        this.drawItem(g, x, y, pressed, "Disconnect");
        this.drawDisconnectIcon(g, x + 2, y + 2);
    }

    private void drawConnectItem(Graphics g, int x, int y, boolean pressed) {
        this.drawItem(g, x, y, pressed, "Connect");
        this.drawConnectIcon(g, x + 2, y + 2);
    }

    private void drawChanListItem(Graphics g, int x, int y, boolean pressed) {
        this.drawItem(g, x, y, pressed, "Chat Rooms");
        this.drawChanListIcon(g, x + 2, y + 2);
    }

    private void drawAboutItem(Graphics g, int x, int y, boolean pressed) {
        this.drawItem(g, x, y, pressed, "About");
        this.drawAboutIcon(g, x + 2, y + 2);
    }

    private void drawHelpItem(Graphics g, int x, int y, boolean pressed) {
        this.drawItem(g, x, y, pressed, "Help");
        this.drawHelpIcon(g, x + 2, y + 2);
    }

    private void drawSmallButton(Graphics g, int x, int y, boolean pressed) {
        int w = 16;
        int h = 16;
        if (!pressed) {
            g.setColor(this.getColor(1));
            g.drawLine(x + 0, y + 1, x + w - 2, y + 1);
            g.drawLine(x + 0, y + 1, x + 0, y + h - 2);
            g.setColor(this.getColor(0));
            g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + 1);
            g.drawLine(x + w - 1, y + h - 2, x + 0, y + h - 2);
            g.setColor(this.getColor(2));
            g.drawLine(x + w - 2, y + h - 3, x + w - 2, y + 2);
            g.drawLine(x + w - 2, y + h - 3, x + 1, y + h - 3);
        } else {
            g.setColor(this.getColor(0));
            g.drawLine(x + 0, y + 1, x + w - 2, y + 1);
            g.drawLine(x + 0, y + 1, x + 0, y + h - 2);
            g.setColor(this.getColor(1));
            g.drawLine(x + w - 1, y + h - 2, x + w - 1, y + 1);
            g.drawLine(x + w - 1, y + h - 2, x + 0, y + h - 2);
            g.setColor(this.getColor(2));
            g.drawLine(x + 1, y + 2, x + 1, y + h - 3);
            g.drawLine(x + 1, y + 2, x + w - 2, y + 2);
        }
    }

    private void drawCloseButtonItem(Graphics g, int x, int y, boolean pressed) {
        this.drawSmallButton(g, x, y, pressed);
        if (!pressed) {
            this.drawCloseButtonCross(g, x + 1, y + 2);
        } else {
            this.drawCloseButtonCross(g, x + 2, y + 3);
        }
    }

    private void drawDockButtonItem(Graphics g, int x, int y, boolean pressed) {
        this.drawSmallButton(g, x, y, pressed);
        if (!pressed) {
            this.drawDockButtonInternal(g, x + 1, y + 2);
        } else {
            this.drawDockButtonInternal(g, x + 2, y + 3);
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics ug) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this._buffer != null && (this._buffer.getWidth(this) != w || this._buffer.getHeight(this) != h)) {
            this._buffer = null;
        }
        if (this._buffer == null) {
            Graphics g;
            try {
                this._buffer = this.createImage(w, h);
                g = this._buffer.getGraphics();
            }
            catch (Throwable e) {
                return;
            }
            g.setFont(new Font("Dialog", 0, 12));
            g.setColor(this.getColor(6));
            g.fillRect(0, 0, w, h);
            if (this._pixxConfiguration.getB("showconnect")) {
                if (!this._connected) {
                    this.drawConnectItem(g, this.getX(this._connectIndex), this.getY(0), this._pressedIndex == this._connectIndex);
                } else {
                    this.drawDisconnectItem(g, this.getX(this._connectIndex), this.getY(0), this._pressedIndex == this._connectIndex);
                }
            }
            if (this._pixxConfiguration.getB("showchanlist")) {
                this.drawChanListItem(g, this.getX(this._chanlistIndex), this.getY(0), this._pressedIndex == this._chanlistIndex);
            }
            if (this._pixxConfiguration.getB("showabout")) {
                this.drawAboutItem(g, this.getX(this._aboutIndex), this.getY(0), this._pressedIndex == this._aboutIndex);
            }
            if (this._pixxConfiguration.getB("showhelp")) {
                this.drawHelpItem(g, this.getX(this._helpIndex), this.getY(0), this._pressedIndex == this._helpIndex);
            }
            if (this._pixxConfiguration.getB("showclose")) {
                this.drawCloseButtonItem(g, this.getClosePositionX(), this.getClosePositionY(), this._closePressed);
            }
            if (this._pixxConfiguration.getB("showdock")) {
                this.drawDockButtonItem(g, this.getDockPositionX(), this.getDockPositionY(), this._dockPressed);
            }
            if (this._title) {
                this.drawTitle(g, this.getTitleY());
            }
        } else {
            Graphics g = this._buffer.getGraphics();
            if (this._redrawTitle) {
                this.drawTitle(g, this.getTitleY());
            }
        }
        this._redrawTitle = false;
        if (this._buffer != null) {
            ug.drawImage(this._buffer, 0, 0, this);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this._pressedIndex = this.getIndex(e.getX(), e.getY());
        this._closePressed = this.isClosePressed(e.getX(), e.getY());
        this._dockPressed = this.isDockPressed(e.getX(), e.getY());
        this._buffer = null;
        if (this._title && e.getY() >= this.getTitleY()) {
            this._mouseDownX = e.getX();
            this._mouseScroll = true;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this._mouseScroll = false;
        int index = this.getIndex(e.getX(), e.getY());
        boolean close = this.isClosePressed(e.getX(), e.getY());
        boolean dock = this.isDockPressed(e.getX(), e.getY());
        if (index == this._connectIndex && this._pixxConfiguration.getB("showconnect")) {
            this._listeners.sendEventAsync("connectionClicked", this);
        }
        if (index == this._chanlistIndex && this._pixxConfiguration.getB("showchanlist")) {
            this._listeners.sendEventAsync("chanListClicked", this);
        }
        if (index == this._aboutIndex && this._pixxConfiguration.getB("showabout")) {
            this._listeners.sendEventAsync("aboutClicked", this);
        }
        if (index == this._helpIndex && this._pixxConfiguration.getB("showhelp")) {
            this._listeners.sendEventAsync("helpClicked", this);
        }
        if (close) {
            this._listeners.sendEventAsync("closeClicked", this);
        }
        if (dock) {
            this._listeners.sendEventAsync("dockClicked", this);
        }
        this._closePressed = false;
        this._dockPressed = false;
        this._pressedIndex = -1;
        this._buffer = null;
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        if (this._title && e.getY() >= this.getTitleY()) {
            if (!this.getCursor().equals(new Cursor(0))) {
                this.setCursor(new Cursor(0));
            }
        } else if (!this.getCursor().equals(new Cursor(0))) {
            this.setCursor(new Cursor(0));
        }
    }

    public void dispose() {
        this._terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollTitle(int deltaX) {
        Object object = this._scrollLock;
        synchronized (object) {
            if (this._drawResult.rectangle == null) {
                return;
            }
            this._titleLeft -= deltaX;
            int min = -this._drawResult.rectangle.width;
            int max = this.getSize().width;
            if (this._titleLeft > max) {
                this._titleLeft = min;
            }
            if (this._titleLeft < min) {
                this._titleLeft = max;
            }
            this._redrawTitle = true;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this._mouseScroll) {
            return;
        }
        if (this._drawResult.rectangle == null) {
            return;
        }
        int deltaX = this._mouseDownX - e.getX();
        this.scrollTitle(deltaX);
        this._freeze = true;
        this._mouseDownX = e.getX();
    }

    public void run() {
        while (!this._terminated) {
            if (!this._freeze) {
                this.scrollTitle(4);
            }
            try {
                if (this._freeze) {
                    Thread.sleep(2000L);
                    this._freeze = false;
                    continue;
                }
                Thread.sleep(this._scrollDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Boolean displayUpdated(Object handle, Integer what) {
        if (this._drawResult == null) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < this._drawResult.updateHandles.size(); ++i) {
            if (this._drawResult.updateHandles.elementAt(i) != handle) continue;
            this._redrawTitle = true;
            this.repaint();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

