/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.ListenerGroup;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxNickListListener;
import irc.gui.pixx.PixxPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class PixxNickList
extends PixxPanel
implements MouseListener,
MouseMotionListener {
    private Vector _nicks;
    private Image _buffer;
    private Font _font;
    private int _base;
    private int _selected;
    private int _overindex;
    private int _overX;
    private int _toScroll;
    private Object _scrollLock = new Object();
    private ListenerGroup _listeners;
    private char[] _prefixes;
    private boolean _leftAlign;

    public PixxNickList(PixxConfiguration config, char[] prefixes) {
        super(config);
        this._prefixes = prefixes;
        this._toScroll = 0;
        this._selected = -1;
        this._overindex = -1;
        this._listeners = new ListenerGroup();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._base = 0;
        this._nicks = new Vector();
        this._font = new Font("", 0, 12);
        this._leftAlign = this._pixxConfiguration.getB("leftnickalign");
    }

    public void release() {
        this.dispose();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        super.release();
    }

    public void addPixxNickListListener(PixxNickListListener lis) {
        this._listeners.addListener(lis);
    }

    public void removePixxNickListListener(PixxNickListListener lis) {
        this._listeners.removeListener(lis);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this._pixxConfiguration.getI("nicklistwidth"), 16);
    }

    public void dispose() {
        this.reinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() {
        Object object = this._scrollLock;
        synchronized (object) {
            this._toScroll = 0;
            this._buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scroll(int v) {
        Object object = this._scrollLock;
        synchronized (object) {
            this._toScroll += v;
            this._base += v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getScrollValue() {
        Object object = this._scrollLock;
        synchronized (object) {
            int ans = this._toScroll;
            this._toScroll = 0;
            return ans;
        }
    }

    public void setBase(int b) {
        this.scroll(b - this._base);
        this.repaint();
    }

    public int getBase() {
        return this._base;
    }

    public int getNickCount() {
        return this._nicks.size();
    }

    public void add(String nick) {
        this._nicks.insertElementAt(nick, this._nicks.size());
        this.reinit();
        this.repaint();
    }

    public void remove(String nick) {
        for (int i = 0; i < this._nicks.size(); ++i) {
            String s = (String)this._nicks.elementAt(i);
            if (!s.equals(nick)) continue;
            this._nicks.removeElementAt(i);
            break;
        }
        this.reinit();
        this.repaint();
    }

    public void set(String[] nicks) {
        this._nicks = new Vector();
        for (int i = 0; i < nicks.length; ++i) {
            this._nicks.insertElementAt(nicks[i], this._nicks.size());
        }
        this.reinit();
        this.repaint();
    }

    public void removeAll() {
        this._nicks = new Vector();
        this.reinit();
        this.repaint();
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    private Color findColor(String info) {
        return this._pixxConfiguration.getIRCConfiguration().getASLColor(info, this.getColor(13), this.getColor(14), this.getColor(15));
    }

    private void update(Graphics gra, int ytop, int height) {
        int w = this.getSize().width;
        int fh = this._font.getSize();
        gra.setColor(this.getColor(6));
        gra.fillRect(0, ytop, w, height);
        gra.setColor(this.getColor(0));
        gra.drawLine(w - 1, ytop, w - 1, ytop + height - 1);
        gra.setFont(this._font);
        int y = 8;
        FontMetrics fm = gra.getFontMetrics();
        int i = this._base;
        while (y + fh + 5 < ytop) {
            y += fh + 6;
            ++i;
        }
        if (i > 0) {
            y -= fh + 6;
            --i;
        }
        while (i < this._nicks.size() && y <= ytop + height) {
            String nick = (String)this._nicks.elementAt(i);
            String info = "";
            int pos = nick.indexOf(":");
            Color back = this.getColor(5);
            if (pos != -1) {
                info = nick.substring(pos + 1);
                nick = nick.substring(0, pos);
                back = this.findColor(info);
            }
            if (this._selected == i) {
                back = this.getColor(7);
            }
            char prefix = '\u0000';
            for (int ci = 0; ci < this._prefixes.length; ++ci) {
                if (nick.length() <= 0 || nick.charAt(0) != this._prefixes[ci]) continue;
                prefix = this._prefixes[ci];
            }
            if (prefix > '\u0000') {
                nick = nick.substring(1);
            }
            int sw = fm.stringWidth(nick);
            gra.setColor(back);
            gra.fillRect(20, y - 1, w - 28, fh + 2);
            gra.setColor(this.getColor(1));
            gra.drawRect(20, y - 1, w - 28, fh + 2);
            gra.setColor(this.getColor(1));
            gra.setClip(20, y - 1, w - 28, fh + 2);
            int px = w - sw - 12;
            if (px < 22) {
                px = 22;
            }
            if (this._leftAlign) {
                px = 22;
            }
            gra.drawString(nick, px, y + fh - 1);
            gra.setClip(0, 0, this.getSize().width, this.getSize().height);
            if (prefix > '\u0000') {
                if (prefix == '@') {
                    gra.setColor(this.getColor(11));
                } else if (prefix == '+') {
                    gra.setColor(this.getColor(10));
                } else if (prefix == '%') {
                    gra.setColor(this.getColor(12));
                } else {
                    gra.setColor(this.getColor(5));
                }
                gra.fillRect(20 - fh - 6, y - 1, fh + 2, fh + 2);
                gra.setColor(this.getColor(1));
                gra.drawRect(20 - fh - 6, y - 1, fh + 2, fh + 2);
                gra.setColor(this.getColor(1));
                sw = fm.stringWidth("" + prefix);
                int tx = 20 - fh - 6 + (fh + 2 - sw) / 2 + 1;
                int ty = y + fh - 1;
                if (prefix == '@') {
                    --tx;
                    --ty;
                }
                gra.drawString("" + prefix, tx, ty);
            }
            y += fh + 6;
            ++i;
        }
    }

    public void update(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        int fh = this._font.getSize();
        if (this._buffer != null && (this._buffer.getWidth(this) != w || this._buffer.getHeight(this) != h)) {
            this._buffer = null;
        }
        if (this._buffer == null) {
            try {
                this._buffer = this.createImage(w, h);
                Graphics gra = this._buffer.getGraphics();
                this.update(gra, 0, h);
            }
            catch (Throwable e) {
                return;
            }
        } else {
            int scr = this.getScrollValue();
            if (scr != 0) {
                Graphics gra = this._buffer.getGraphics();
                int dy = -(fh + 6) * scr;
                if (dy < 0) {
                    gra.copyArea(0, -dy, w, h + dy, 0, dy);
                    this.update(gra, h + dy, -dy);
                } else {
                    gra.copyArea(0, 0, w, h - dy, 0, dy);
                    this.update(gra, 0, dy);
                }
            }
        }
        if (this._buffer != null) {
            g.drawImage(this._buffer, 0, 0, this);
        }
        if (this._overindex != -1 && this._pixxConfiguration.getIRCConfiguration().getB("style:floatingasl")) {
            int x = this._overX;
            int y = 8 + (this._overindex - this._base) * (fh + 6) + 2;
            if (y + fh + 5 >= h) {
                y = h - fh - 5;
            }
            String info = this.getInfo(this._overindex);
            String text = this._pixxConfiguration.getIRCConfiguration().formatASL(info);
            if (text.length() > 0) {
                int tw = g.getFontMetrics().stringWidth(text);
                if (x + tw + 5 >= w) {
                    x = w - tw - 5;
                }
                if (x < 0) {
                    x = 0;
                }
                g.setColor(this.getAlphaColor(this.findColor(info), this._pixxConfiguration.getIRCConfiguration().getI("style:floatingaslalpha")));
                g.fillRect(x, y, tw + 4, fh + 4);
                g.setColor(this.getColor(1));
                g.drawRect(x, y, tw + 4, fh + 4);
                g.drawString(text, x + 2, y + fh);
            }
        }
    }

    private Color getAlphaColor(Color c, int alpha) {
        try {
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        catch (Throwable ex) {
            return c;
        }
    }

    private int getIndex(int x, int y) {
        int fh = this._font.getSize();
        y += fh + 6;
        y -= 8;
        y /= fh + 6;
        --y;
        if ((y += this._base) < 0) {
            y = -1;
        }
        if (y >= this._nicks.size()) {
            y = -1;
        }
        return y;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this._overindex != -1) {
            this._overindex = -1;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        int index;
        this._selected = index = this.getIndex(e.getX(), e.getY());
        this.reinit();
        this.repaint();
        if (this._selected != -1) {
            this._listeners.sendEventAsync("eventOccured", this.getNick(this._selected), e);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    private String getUnprefixedNick(String nick) {
        if (nick.length() == 0) {
            return nick;
        }
        for (int i = 0; i < this._prefixes.length; ++i) {
            if (nick.charAt(0) != this._prefixes[i]) continue;
            return nick.substring(1);
        }
        return nick;
    }

    private String getNick(int index) {
        if (index == -1) {
            return "";
        }
        String nick = (String)this._nicks.elementAt(index);
        int pos = (nick = this.getUnprefixedNick(nick)).indexOf(":");
        if (pos != -1) {
            nick = nick.substring(0, pos);
        }
        return nick;
    }

    private String getInfo(int index) {
        if (index == -1) {
            return "";
        }
        String nick = (String)this._nicks.elementAt(index);
        nick = this.getUnprefixedNick(nick);
        int pos = nick.indexOf(":");
        String info = "";
        if (pos != -1) {
            info = nick.substring(pos + 1);
        }
        return info;
    }

    public void mouseMoved(MouseEvent e) {
        if (!this._pixxConfiguration.getIRCConfiguration().getASLMaster()) {
            return;
        }
        int index = this.getIndex(e.getX(), e.getY());
        if (index == this._overindex) {
            return;
        }
        this._overindex = index;
        this._overX = e.getX();
        this.repaint();
        if (index != -1) {
            this._listeners.sendEventAsync("ASLEventOccured", this.getNick(index), this.getInfo(index));
        }
    }
}

