/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.EventDispatcher;
import irc.ListenerGroup;
import irc.gui.pixx.AWTChanList;
import irc.gui.pixx.AWTChannel;
import irc.gui.pixx.AWTDCCChat;
import irc.gui.pixx.AWTDefaultSource;
import irc.gui.pixx.AWTQuery;
import irc.gui.pixx.AWTStatus;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.BaseAWTSourceListener;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxPanel;
import irc.gui.pixx.PixxTaskBarListener;
import irc.gui.pixx.TaskBarItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class PixxTaskBar
extends PixxPanel
implements MouseListener,
MouseMotionListener,
BaseAWTSourceListener {
    private ListenerGroup _listeners;
    private TaskBarItem _active = null;
    private TaskBarItem _pressed = null;
    private Vector _items;
    private int[] _itemCount;
    private int[] _visibleItemCount;
    private Font _font = new Font("", 0, 12);
    private Image _buffer;
    private int _iwidth;
    private int _ileft;
    private int _zorder;
    private boolean _handCursor;
    private int _overX;
    private int _overY;
    private int _maxWidth;

    public PixxTaskBar(PixxConfiguration config) {
        super(config);
        this._listeners = new ListenerGroup();
        this._items = new Vector();
        this._itemCount = new int[2];
        this._visibleItemCount = new int[2];
        this._itemCount[0] = 0;
        this._itemCount[1] = 0;
        this._visibleItemCount[0] = 0;
        this._visibleItemCount[1] = 0;
        this._ileft = 60;
        this._zorder = 0;
        this._handCursor = false;
        this._overX = -1;
        this._overY = -1;
        this.computeWidth();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._maxWidth = config.getI("taskbaritemwidth");
    }

    public void release() {
        this._buffer = null;
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        super.release();
    }

    public void addPixxTaskBarListener(PixxTaskBarListener lis) {
        this._listeners.addListener(lis);
    }

    public void removePixxTaskBarListener(PixxTaskBarListener lis) {
        this._listeners.removeListener(lis);
    }

    private TaskBarItem findItem(BaseAWTSource source) {
        if (source == null) {
            return null;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            if (((TaskBarItem)this._items.elementAt((int)i)).source != source) continue;
            return (TaskBarItem)this._items.elementAt(i);
        }
        return null;
    }

    private void removeFromVector(Vector v, Object o) {
        for (int i = 0; i < v.size(); ++i) {
            if (v.elementAt(i) != o) continue;
            v.removeElementAt(i);
        }
    }

    private synchronized void enter(BaseAWTSource source, int row, boolean bring) {
        TaskBarItem item = new TaskBarItem(source, row, bring);
        source.addBaseAWTSourceListener(this);
        this._items.insertElementAt(item, this._items.size());
        int n = row;
        this._itemCount[n] = this._itemCount[n] + 1;
        int n2 = row;
        this._visibleItemCount[n2] = this._visibleItemCount[n2] + 1;
        this._listeners.sendEvent("AWTSourceAdded", this, source);
        if (bring) {
            this.activate(source);
        }
        this._buffer = null;
        this.repaint();
    }

    private synchronized void leave(BaseAWTSource source, int row) {
        TaskBarItem item = this.findItem(source);
        source.removeBaseAWTSourceListener(this);
        int n = row;
        this._itemCount[n] = this._itemCount[n] - 1;
        int n2 = row;
        this._visibleItemCount[n2] = this._visibleItemCount[n2] - 1;
        boolean change = this.getActive() == source;
        this.removeFromVector(this._items, item);
        if (change) {
            this.activate(null);
        }
        this._listeners.sendEvent("AWTSourceRemoved", this, source);
        this._buffer = null;
        this.repaint();
    }

    public int getCount() {
        return this._itemCount[0] + this._itemCount[1];
    }

    public void addChannel(AWTChannel chan, boolean bring) {
        this.enter(chan, 0, bring);
    }

    public void removeChannel(AWTChannel chan) {
        this.leave(chan, 0);
    }

    public void addStatus(AWTStatus status, boolean bring) {
        this.enter(status, 1, bring);
    }

    public void removeStatus(AWTStatus status) {
        this.leave(status, 1);
    }

    public void addDefaultSource(AWTDefaultSource source, boolean bring) {
        this.enter(source, 1, bring);
    }

    public void removeDefaultSource(AWTDefaultSource source) {
        this.leave(source, 1);
    }

    public void addQuery(AWTQuery query, boolean bring) {
        this.enter(query, 1, bring);
    }

    public void removeQuery(AWTQuery query) {
        this.leave(query, 1);
    }

    public void addChanList(AWTChanList chanlist, boolean bring) {
        this.enter(chanlist, 1, bring);
    }

    public void removeChanList(AWTChanList chanlist) {
        this.leave(chanlist, 1);
    }

    public void addDCCChat(AWTDCCChat chat, boolean bring) {
        this.enter(chat, 1, bring);
    }

    public void removeDCCChat(AWTDCCChat chat) {
        this.leave(chat, 1);
    }

    private BaseAWTSource findFirst() {
        TaskBarItem first = null;
        int maxz = -1;
        for (int i = 0; i < this._items.size(); ++i) {
            TaskBarItem item = (TaskBarItem)this._items.elementAt(i);
            if (item.zorder <= maxz) continue;
            maxz = item.zorder;
            first = item;
        }
        if (first == null) {
            return null;
        }
        return first.source;
    }

    public BaseAWTSource[] getZOrderedSources() {
        int i;
        TaskBarItem[] items = new TaskBarItem[this._items.size()];
        for (i = 0; i < items.length; ++i) {
            items[i] = (TaskBarItem)this._items.elementAt(i);
        }
        for (i = 0; i < items.length - 1; ++i) {
            TaskBarItem item = items[i];
            int max = item.zorder;
            int maxIndex = i;
            for (int j = i + 1; j < items.length; ++j) {
                item = items[j];
                if (item.zorder <= max) continue;
                max = item.zorder;
                maxIndex = j;
            }
            TaskBarItem tmp = items[i];
            items[i] = items[maxIndex];
            items[maxIndex] = tmp;
        }
        BaseAWTSource[] ans = new BaseAWTSource[items.length];
        for (int i2 = 0; i2 < ans.length; ++i2) {
            ans[i2] = items[i2].source;
        }
        return ans;
    }

    public void show(BaseAWTSource source) {
        if (source == null) {
            return;
        }
        TaskBarItem item = this.findItem(source);
        if (item.visible) {
            return;
        }
        item.visible = true;
        int n = item.row;
        this._visibleItemCount[n] = this._visibleItemCount[n] + 1;
        this._buffer = null;
        this.repaint();
    }

    public void hide(BaseAWTSource source) {
        if (source == null) {
            return;
        }
        TaskBarItem item = this.findItem(source);
        if (!item.visible) {
            return;
        }
        item.visible = false;
        int n = item.row;
        this._visibleItemCount[n] = this._visibleItemCount[n] - 1;
        this._buffer = null;
        this.repaint();
    }

    public void activate(BaseAWTSource source) {
        if (source == null) {
            source = this.findFirst();
        }
        if (source == null) {
            return;
        }
        TaskBarItem item = this.findItem(source);
        if (item == this._active) {
            return;
        }
        if (!item.visible) {
            return;
        }
        if (this._active != null) {
            this._listeners.sendEvent("AWTSourceDesactivated", this, this._active.source);
        }
        this._active = item;
        if (this._active != null) {
            this._active.zorder = this._zorder++;
            this._active.eventWaiting = false;
            this._listeners.sendEvent("AWTSourceActivated", this, this._active.source);
        } else {
            this._listeners.sendEvent("AWTSourceActivated", this, null);
        }
        source.requestFocus();
        this._buffer = null;
        this.repaint();
    }

    public BaseAWTSource getActive() {
        if (this._active == null) {
            return null;
        }
        return this._active.source;
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 2 * this.getItemHeight() + 16);
    }

    private int getItemWidth() {
        return this._iwidth;
    }

    private int getItemHeight() {
        return this._font.getSize() + 4;
    }

    private synchronized void computeWidth() {
        int w = this.getSize().width - 63;
        int n = Math.max(this._visibleItemCount[0], this._visibleItemCount[1]);
        this._iwidth = n != 0 ? Math.min(this._maxWidth, (w -= 9 * n) / n) : this._maxWidth;
    }

    private int getX(int col) {
        return col * (this.getItemWidth() + 9) + this._ileft;
    }

    private int getCol(int x) {
        return (x - this._ileft) / (9 + this.getItemWidth());
    }

    private int getY(int row) {
        return 4 + (this.getItemHeight() + 8) * row;
    }

    private int getRow(int y) {
        return (y - 4) / (8 + this.getItemHeight());
    }

    private void drawItem(Graphics g, int col, int row, Color c, String s) {
        int x = this.getX(col);
        int y = this.getY(row);
        int w = this.getItemWidth();
        int h = this.getItemHeight();
        g.setClip(x + 1, y + 1, w - 1, h - 1);
        g.setColor(c);
        g.fillRect(x, y, w, h);
        g.setColor(this.getColor(0));
        g.drawRect(x, y, w, h);
        g.setColor(this.getColor(1));
        g.drawRect(x + 1, y + 1, w - 2, h - 2);
        y += h;
        int strw = g.getFontMetrics().stringWidth(s);
        g.drawString(s, x + (w - strw) / 2, (y -= (h - this._font.getSize()) / 2) - 1);
        g.setClip(0, 0, this.getSize().width, this.getSize().height);
    }

    private void drawItem(Graphics g, TaskBarItem item, int col) {
        int row = item.row;
        Color c = this.getColor(5);
        if (item == this._active || item == this._pressed) {
            c = this.getColor(7);
        }
        if (item != this._active && item.eventWaiting) {
            c = this.getColor(8);
        }
        this.drawItem(g, col++, row, c, item.source.getShortTitle());
    }

    public void update(Graphics ug) {
        TaskBarItem item;
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this._buffer != null && (this._buffer.getWidth(this) != w || this._buffer.getHeight(this) != h)) {
            this._buffer = null;
        }
        if (this._buffer == null) {
            int y;
            Graphics g;
            try {
                this._buffer = this.createImage(w, h);
                g = this._buffer.getGraphics();
            }
            catch (Throwable e) {
                return;
            }
            g.setFont(new Font("", 0, 12));
            int sw = Math.max(g.getFontMetrics().stringWidth("Private Msg's   "), g.getFontMetrics().stringWidth("Chat Rooms"));
            this._ileft = 25 + sw;
            this.computeWidth();
            g.setColor(this.getColor(6));
            g.fillRect(0, 0, w, h);
            int col0 = 0;
            int col1 = 0;
            Enumeration el = this._items.elements();
            while (el.hasMoreElements()) {
                TaskBarItem item2 = (TaskBarItem)el.nextElement();
                if (!item2.visible) continue;
                if (item2.row == 0) {
                    this.drawItem(g, item2, col0++);
                    continue;
                }
                this.drawItem(g, item2, col1++);
            }
            g.setColor(this.getColor(5));
            g.fillRect(4, 5, sw + 2, h - 9);
            for (y = 3; y < h / 4; ++y) {
                g.drawLine(sw + 3 + y, y + 3, sw + 3 + y, h / 2 + 2 - y);
                g.drawLine(sw + 3 + y, h - 3 - y, sw + 3 + y, h / 2 - 1 + y);
            }
            g.setColor(this.getColor(0));
            g.drawLine(4, h / 2 - 1, w - 1, h / 2 - 1);
            g.drawLine(4, h / 2 + 1, w - 1, h / 2 + 1);
            g.setColor(this.getColor(1));
            g.drawLine(4, h / 2, w - 1, h / 2);
            y = this.getY(0) + this.getItemHeight();
            g.drawString("Chat Rooms", 8, (y -= (this.getItemHeight() - this._font.getSize()) / 2) + 1);
            y = this.getY(1) + this.getItemHeight();
            g.drawString("Private Msg's   ", 8, (y -= (this.getItemHeight() - this._font.getSize()) / 2) - 4);
            g.setColor(this.getColor(0));
            g.drawLine(4, 5, 4, h - 5);
            g.drawLine(4, 5, sw + 6, 5);
            g.drawLine(4, h - 5, sw + 6, h - 5);
            g.drawLine(sw + 6, 5, sw + 3 + h / 4, h / 4 + 2);
            g.drawLine(sw + 3 + h / 4, h / 4 + 2, sw + 6, h / 2 - 1);
            g.drawLine(sw + 6, h - 5, sw + 3 + h / 4, h - 1 - h / 4 - 1);
            g.drawLine(sw + 3 + h / 4, h - h / 4 - 2, sw + 6, h - 3 - h / 2 + 4);
            g.setColor(this.getColor(1));
            g.drawLine(5, 6, 5, h - 6);
            g.drawLine(5, 6, sw + 5, 6);
            g.drawLine(5, h - 6, sw + 5, h - 6);
            g.drawLine(sw + 6, 6, sw + 2 + h / 4, h / 4 + 2);
            g.drawLine(sw + 2 + h / 4, h / 4 + 2, sw + 5, h / 2 - 1);
            g.drawLine(sw + 6, h - 6, sw + 2 + h / 4, h - 1 - h / 4 - 1);
            g.drawLine(sw + 2 + h / 4, h - 2 - h / 4, sw + 5, h - 1 - h / 2 + 2);
        }
        if (this._buffer != null) {
            ug.drawImage(this._buffer, 0, 0, this);
        }
        if ((item = this.getItemAt(this._overX, this._overY)) != null) {
            String text = item.source.getShortTitle();
            int tw = ug.getFontMetrics().stringWidth(text);
            int x = this.getX(this.getCol(this._overX)) + (this.getItemWidth() - tw) / 2 - 2;
            int y = this.getY(this.getRow(this._overY)) - (this.getItemHeight() - this._font.getSize()) / 2 - 1;
            int fh = this.getItemHeight();
            if (text.length() > 0 && tw >= this.getItemWidth()) {
                if (x + tw + 5 >= w) {
                    x = w - tw - 5;
                }
                if (x < 0) {
                    x = 0;
                }
                ug.setColor(this.getAlphaColor(this.getColor(5), 200));
                ug.fillRect(x, y, tw + 4, fh + 4);
                ug.setColor(this.getColor(1));
                ug.drawRect(x, y, tw + 4, fh + 4);
                ug.drawString(text, x + 2, y + fh);
            }
        }
    }

    private Color getAlphaColor(Color c, int alpha) {
        try {
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        catch (Throwable ex) {
            return c;
        }
    }

    private TaskBarItem getItemAt(int x, int y) {
        int col;
        int row = this.getRow(y);
        if ((x -= this.getX(col = this.getCol(x))) >= this.getItemWidth() || (y -= this.getY(row)) >= this.getItemHeight()) {
            return null;
        }
        if (x < 0 || y < 0) {
            return null;
        }
        int currentcol = 0;
        Enumeration el = this._items.elements();
        while (el.hasMoreElements()) {
            TaskBarItem item = (TaskBarItem)el.nextElement();
            if (!item.visible || item.row != row) continue;
            if (currentcol == col) {
                return item;
            }
            ++currentcol;
        }
        return null;
    }

    public void mouseMoved(MouseEvent e) {
        TaskBarItem oldItem;
        TaskBarItem item = this.getItemAt(e.getX(), e.getY());
        if (item != null) {
            if (!this._handCursor) {
                this.setCursor(new Cursor(12));
                this._handCursor = true;
            }
        } else if (this._handCursor) {
            this.setCursor(new Cursor(0));
            this._handCursor = false;
        }
        if ((oldItem = this.getItemAt(this._overX, this._overY)) != item) {
            this._overX = e.getX();
            this._overY = e.getY();
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mousePressed(MouseEvent e) {
        TaskBarItem np;
        this._pressed = np = this.getItemAt(e.getX(), e.getY());
        this._buffer = null;
        this.repaint();
        if (this._pressed != null) {
            this._listeners.sendEventAsync("eventOccured", this, this._pressed.source, e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this._pressed = null;
        TaskBarItem src = this.getItemAt(e.getX(), e.getY());
        try {
            if ((e.getModifiers() & 0x10) != 0 && src != null) {
                EventDispatcher.dispatchEventAsyncAndWaitEx(this, "activate", new Object[]{src.source});
            }
        }
        catch (InterruptedException ex) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._buffer = null;
        this.repaint();
    }

    public void titleChanged(BaseAWTSource source) {
        this._buffer = null;
        this.repaint();
    }

    public void eventOccured(BaseAWTSource source) {
        TaskBarItem item = this.findItem(source);
        if (item == null) {
            return;
        }
        if (item == this._active) {
            return;
        }
        item.eventWaiting = true;
        this._buffer = null;
        this.repaint();
    }
}

