/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxNickList;
import irc.gui.pixx.PixxNickListListener;
import irc.gui.pixx.PixxPanel;
import irc.gui.pixx.PixxScrollBar;
import irc.gui.pixx.PixxScrollBarListener;
import irc.gui.pixx.PixxSeparator;
import irc.gui.pixx.PixxVerticalScrollBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;

public class ScrollablePixxNickList
extends PixxPanel
implements PixxScrollBarListener {
    private PixxNickList _list;
    private PixxVerticalScrollBar _scroll;

    public ScrollablePixxNickList(PixxConfiguration config, char[] prefixes) {
        super(config);
        this.setLayout(new BorderLayout());
        Panel p = new Panel();
        p.setLayout(new BorderLayout());
        this._list = new PixxNickList(config, prefixes);
        this._scroll = new PixxVerticalScrollBar(config, 0, 0, 0.1);
        this._scroll.addPixxScrollBarListener(this);
        p.add((Component)this._list, "Center");
        p.add((Component)this._scroll, "East");
        this.add((Component)p, "Center");
        this.add((Component)new PixxSeparator(2), "West");
        this.add((Component)new PixxSeparator(3), "East");
        this.add((Component)new PixxSeparator(0), "North");
        this.add((Component)new PixxSeparator(1), "South");
    }

    public void release() {
        this._scroll.removePixxScrollBarListener(this);
        this._list.release();
        this._scroll.release();
        this._list = null;
        this._scroll = null;
        super.release();
    }

    public void addPixxNickListListener(PixxNickListListener lis) {
        this._list.addPixxNickListListener(lis);
    }

    public void removePixxNickListListener(PixxNickListListener lis) {
        this._list.removePixxNickListListener(lis);
    }

    public void set(String[] nicks) {
        this._list.set(nicks);
        this._scroll.setMaximum(this._list.getNickCount() - 1);
    }

    public void add(String nick) {
        this._list.add(nick);
        this._scroll.setMaximum(this._list.getNickCount() - 1);
    }

    public void removeAll() {
        this._list.removeAll();
        this._scroll.setMaximum(this._list.getNickCount() - 1);
    }

    public void valueChanged(PixxScrollBar pixScrollBar) {
        this._list.setBase(pixScrollBar.getValue());
    }

    public void dispose() {
        this._list.dispose();
    }
}

