/*
 * Decompiled with CFR 0.152.
 */
package irc.ident.prv;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.ListenerGroup;
import irc.ident.IdentListener;
import irc.ident.prv.LocalInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

public class IdentServer
extends IRCObject
implements Runnable {
    private Thread _thread;
    private boolean _running;
    private Hashtable _table;
    private ServerSocket _serverSocket;
    private boolean _defaultUser;
    private String _system;
    private String _id;
    private ListenerGroup _listeners;
    private int _port;

    public IdentServer(IRCConfiguration config) {
        super(config);
        this.resetDefaultUser();
        this._table = new Hashtable();
        this._listeners = new ListenerGroup();
        this._thread = null;
    }

    public void start() throws Exception {
        this.start(113);
    }

    public void resetDefaultUser() {
        this._defaultUser = false;
    }

    public void setDefaultUser(String system, String id) {
        this._defaultUser = true;
        this._system = system;
        this._id = id;
    }

    public void start(int port) throws Exception {
        this._port = port;
        this._running = false;
        this._serverSocket = this._ircConfiguration.getSecurityProvider().getServerSocket(this._port);
        this._thread = new Thread((Runnable)this, "IDENT server");
        this._thread.start();
        while (!this._running) {
            Thread.yield();
        }
    }

    public void stop() {
        if (this._thread == null) {
            return;
        }
        try {
            this._serverSocket.close();
            this._thread.join();
            this._thread = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void registerLocalConnection(int localPort, String system, String id) {
        this._table.put(new Integer(localPort), new LocalInfo(localPort, system, id));
    }

    public synchronized void unregisterLocalConnection(int localPort) {
        this._table.remove(new Integer(localPort));
    }

    private synchronized LocalInfo processRequest(int localPort) {
        return (LocalInfo)this._table.get(new Integer(localPort));
    }

    public synchronized void addIdentListener(IdentListener lis) {
        this._listeners.addListener(lis);
    }

    public synchronized void removeIdentListener(IdentListener lis) {
        this._listeners.removeListener(lis);
    }

    public void run() {
        boolean terminated = false;
        this._running = true;
        this._listeners.sendEventAsync("identRunning", new Integer(this._port));
        while (!terminated) {
            try {
                Socket s = this._serverSocket.accept();
                String from = this.getText(522);
                int result = -1;
                String reply = this.getText(521);
                try {
                    try {
                        from = this._ircConfiguration.getSecurityProvider().resolve(s.getInetAddress());
                    }
                    catch (Exception e) {
                        from = s.getInetAddress().getHostAddress();
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
                    String request = reader.readLine();
                    int pos = request.indexOf(44);
                    String serverSide = request.substring(0, pos).trim();
                    String clientSide = request.substring(pos + 1).trim();
                    LocalInfo info = this.processRequest(new Integer(serverSide));
                    reply = serverSide + " , " + clientSide + " : ";
                    if (info == null) {
                        if (!this._defaultUser) {
                            result = 2;
                            reply = reply + "ERROR : NO-USER";
                        } else {
                            result = 1;
                            reply = reply + "USERID : " + this._system + " : " + this._id;
                        }
                    } else {
                        result = 0;
                        reply = reply + "USERID : " + info.system + " : " + info.id;
                    }
                    writer.write(reply + "\n");
                    writer.flush();
                    reader.close();
                    writer.close();
                    s.close();
                    this._listeners.sendEventAsync("identRequested", from, new Integer(result), reply);
                }
                catch (Exception e) {
                    this._listeners.sendEventAsync("identRequested", from, new Integer(-1), e.getMessage());
                }
            }
            catch (Exception e) {
                this._listeners.sendEventAsync("identLeaving", e.getMessage());
                terminated = true;
            }
        }
    }
}

