/*
 * Decompiled with CFR 0.152.
 */
package irc.plugin.buttons;

import irc.IRCApplication;
import irc.plugin.buttons.SmileyGrayFilter;
import irc.plugin.buttons.SmileyLabel;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.net.URL;

public class SmileyButton
extends SmileyLabel
implements MouseListener {
    protected static final int defaultBorderWidth = 4;
    protected ActionListener actionListener = null;
    private String _smileyID;
    private IRCApplication _appl;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    private boolean mouseIsDown = false;
    private int darkness = -5263441;
    private Image graySmiley = null;

    public SmileyButton() {
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    public SmileyButton(String smileyURLString) {
        super(smileyURLString);
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    public SmileyButton(URL smileyURL) {
        super(smileyURL);
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    public SmileyButton(URL smileyDirectory, String smileyFile) {
        super(smileyDirectory, smileyFile);
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    public SmileyButton(Image smiley) {
        super(smiley);
        this.setBorders();
        this._smileyID = SmileyButton.getDefaultSmileyString();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.graySmiley == null) {
            this.createGraySmiley(g);
        }
        this.drawBorder(true);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void processMouseEvent(MouseEvent e) {
        System.out.println("SmileyButton.processMouseEvent()");
    }

    public void mouseClicked(MouseEvent e) {
        System.out.println("SmileyButton.mouseClicked()");
        this.getIRCApplication().setFieldText(this._appl.getFieldText() + ":)");
        ActionEvent ae = new ActionEvent(this, 0, this.getSmileyID());
        if (this.actionListener != null) {
            System.out.println("it did have an action listener\n");
            this.actionListener.actionPerformed(ae);
        }
        this.mouseIsDown = false;
    }

    public void mouseEntered(MouseEvent e) {
        System.out.println("SmileyButton.mouseEntered");
        this.paint(this.getGraphics());
    }

    public void mouseExited(MouseEvent e) {
        System.out.println("SmileyButton.mouseExited");
        this.paint(this.getGraphics());
    }

    public void mousePressed(MouseEvent e) {
        System.out.println("SmileyButton.mousePressed");
        this.mouseIsDown = true;
        Graphics g = this.getGraphics();
        int border = this.getBorder();
        if (this.hasExplicitSize()) {
            g.drawImage(this.graySmiley, border, border, this.getWidth() - 2 * border, this.getHeight() - 2 * border, this);
        } else {
            g.drawImage(this.graySmiley, border, border, this);
        }
        this.drawBorder(false);
    }

    public void mouseReleased(MouseEvent e) {
        System.out.println("SmileyButton.mouseReleased()");
        this.paint(this.getGraphics());
        this.mouseIsDown = false;
    }

    public String getSmileyID() {
        return this._smileyID;
    }

    public void setSmileyID(String str) {
        this._smileyID = str;
    }

    public IRCApplication getIRCApplication() {
        return this._appl;
    }

    public void setIRCApplication(IRCApplication appl) {
        this._appl = appl;
    }

    public int getDarkness() {
        return this.darkness;
    }

    public void setDarkness(int darkness) {
        this.darkness = darkness;
    }

    public Image getGraySmiley() {
        return this.graySmiley;
    }

    public void setGraySmiley(Image graySmiley) {
        this.graySmiley = graySmiley;
    }

    private void drawBorder(boolean isUp) {
        Graphics g = this.getGraphics();
        g.setColor(this.getBorderColor());
        int left = 0;
        int top = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        int border = this.getBorder();
        for (int i = 0; i < border; ++i) {
            g.draw3DRect(left, top, width, height, isUp);
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    private void setBorders() {
        this.setBorder(4);
        this.setBorderColor(defaultBorderColor);
    }

    private void createGraySmiley(Graphics g) {
        SmileyGrayFilter filter = new SmileyGrayFilter(this.darkness);
        FilteredImageSource producer = new FilteredImageSource(this.getSmiley().getSource(), filter);
        this.graySmiley = this.createImage(producer);
        int border = this.getBorder();
        if (this.hasExplicitSize()) {
            this.prepareImage(this.graySmiley, this.getWidth() - 2 * border, this.getHeight() - 2 * border, this);
        } else {
            this.prepareImage(this.graySmiley, this);
        }
        super.paint(g);
    }
}

