/*
 * Decompiled with CFR 0.152.
 */
package irc.plugin.buttons;

import irc.IRCApplication;
import irc.IRCConfiguration;
import irc.SmileyTable;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class SmileyButtons
extends WindowAdapter
implements ActionListener,
Runnable {
    private Thread _thread = null;
    private Frame _frame;
    private Panel _panel;
    private IRCApplication _appl;
    private IRCConfiguration _config;
    private SmileyTable _smileyTable;
    private static int _width = 18;
    private static int _height = 22;

    public static int getHeight() {
        return _height;
    }

    public static int getWidth() {
        return _width;
    }

    public SmileyButtons(IRCConfiguration config, IRCApplication appl) {
        this._appl = appl;
        this._config = config;
        this._smileyTable = this._config.getSmileyTable();
        this._frame = new Frame();
        this._frame.setVisible(false);
        this._frame.setTitle("Smileys Available");
        this._frame.setLayout(new BorderLayout());
        this._frame.addWindowListener(this);
        if (this._thread == null) {
            this._thread = new Thread((Runnable)this, "Smiley_Picker");
            this._thread.start();
        }
    }

    public void run() {
        Thread myThread = Thread.currentThread();
        this._panel = new Panel();
        int columns = 5;
        int rows = this._smileyTable.getSize() / columns + 1;
        this._panel.setLayout(new GridLayout(rows, columns));
        int s = this._smileyTable.getSize();
        for (int i = 0; i < s; ++i) {
            String str = this._smileyTable.getMatch(i);
            Image img = this._smileyTable.getImage(i);
            JSmileyButton button = new JSmileyButton(img, str);
            button.setSize(_width, _height);
            button.addActionListener(this);
            this._panel.add(button);
        }
        this.addPaneltoFrame(this._panel);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = ((JSmileyButton)e.getSource()).getMatch();
        this._appl.setFieldText(this._appl.getFieldText() + cmd);
    }

    public void addPaneltoFrame(Panel panel) {
        int s = this._smileyTable.getSize();
        this._panel = panel;
        this._frame.add(this._panel);
        this._frame.pack();
    }

    public void show() {
        this._frame.setVisible(true);
        this._frame.toFront();
    }

    public void windowDeactivated(WindowEvent e) {
        this._frame.setVisible(false);
    }

    public void windowClosing(WindowEvent evt) {
        this._frame.setVisible(false);
    }

    class JSmileyButton
    extends JButton {
        private static final long serialVersionUID = 1424L;
        private String _match;

        public void setMatch(String m) {
            this._match = m;
        }

        public String getMatch() {
            return this._match;
        }

        public JSmileyButton(Image icon, String match) {
            super(new ImageIcon(icon));
            this.setMatch(match);
            this.setSize(SmileyButtons.getWidth(), SmileyButtons.getHeight());
        }
    }
}

