/*
 * Decompiled with CFR 0.152.
 */
package irc.plugin.buttons;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;

public class SmileyLabel
extends Canvas {
    private Image smiley;
    private static String defaultSmileyString = "http://localhost/logo.java.color-transp.55x60.gif";
    private String smileyString = "<Existing Smiley>";
    private boolean debug = false;
    private int border = 0;
    private Color borderColor = null;
    private int width;
    private int height;
    private boolean explicitSize = false;
    private int explicitWidth = 0;
    private int explicitHeight = 0;
    private MediaTracker tracker;
    private static int lastTrackerID = 0;
    private int currentTrackerID;
    private boolean doneLoading = false;
    private Container parentContainer;

    public SmileyLabel() {
        this(defaultSmileyString);
    }

    public SmileyLabel(String smileyURLString) {
        this(SmileyLabel.makeURL(smileyURLString));
    }

    public SmileyLabel(URL smileyURL) {
        this(SmileyLabel.loadSmiley(smileyURL));
        this.smileyString = smileyURL.toExternalForm();
    }

    public SmileyLabel(URL smileyDirectory, String file) {
        this(SmileyLabel.makeURL(smileyDirectory, file));
        this.smileyString = file;
    }

    public SmileyLabel(Image smiley) {
        this.smiley = smiley;
        this.tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.tracker.addImage(smiley, this.currentTrackerID);
    }

    public void waitForSmiley(boolean doLayout) {
        if (!this.doneLoading) {
            this.debug("[waitForSmiley] - Resizing and waiting for " + this.smileyString);
            try {
                this.tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException ie) {
            }
            catch (Exception e) {
                System.out.println("Error loading " + this.smileyString + ": " + e.getMessage());
                e.printStackTrace();
            }
            if (this.tracker.isErrorID(0)) {
                new Throwable("Error loading smiley " + this.smileyString).printStackTrace();
            }
            this.doneLoading = true;
            this.width = this.explicitWidth != 0 ? this.explicitWidth : this.smiley.getWidth(this) + 2 * this.border;
            this.height = this.explicitHeight != 0 ? this.explicitHeight : this.smiley.getHeight(this) + 2 * this.border;
            this.setSize(this.width, this.height);
            this.debug("[waitForSmiley] - " + this.smileyString + " is " + this.width + "x" + this.height + ".");
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && doLayout) {
                this.setBackground(this.parentContainer.getBackground());
                this.parentContainer.doLayout();
            }
        }
    }

    public void centerAt(int x, int y) {
        this.debug("Placing center of " + this.smileyString + " at (" + x + "," + y + ")");
        this.setLocation(x - this.width / 2, y - this.height / 2);
    }

    public void paint(Graphics g) {
        if (!this.doneLoading) {
            this.waitForSmiley(true);
        } else {
            if (this.explicitSize) {
                g.drawImage(this.smiley, this.border, this.border, this.width - 2 * this.border, this.height - 2 * this.border, this);
            } else {
                g.drawImage(this.smiley, this.border, this.border, this);
            }
            this.drawRect(g, 0, 0, this.width - 1, this.height - 1, this.border, this.borderColor);
        }
    }

    public Dimension getPreferredSize() {
        if (!this.doneLoading) {
            this.waitForSmiley(false);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (!this.doneLoading) {
            this.waitForSmiley(false);
        }
        return super.getMinimumSize();
    }

    public void setSize(int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.setSize(width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.setBounds(x, y, width, height);
    }

    protected void drawRect(Graphics g, int left, int top, int width, int height, int lineThickness, Color rectangleColor) {
        g.setColor(rectangleColor);
        for (int i = 0; i < lineThickness; ++i) {
            g.drawRect(left, top, width, height);
            if (i >= lineThickness - 1) continue;
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    public boolean isLoaded() {
        return this.doneLoading;
    }

    protected void debug(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    private static URL makeURL(String s) {
        URL u = null;
        try {
            u = new URL(s);
        }
        catch (MalformedURLException mue) {
            System.out.println("Bad URL " + s + ": " + mue);
            mue.printStackTrace();
        }
        return u;
    }

    private static URL makeURL(URL directory, String file) {
        URL u = null;
        try {
            u = new URL(directory, file);
        }
        catch (MalformedURLException mue) {
            System.out.println("Bad URL " + directory.toExternalForm() + ", " + file + ": " + mue);
            mue.printStackTrace();
        }
        return u;
    }

    private static Image loadSmiley(URL url) {
        return Toolkit.getDefaultToolkit().getImage(url);
    }

    public Image getSmiley() {
        return this.smiley;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected boolean hasExplicitSize() {
        return this.explicitSize;
    }

    public static String getDefaultSmileyString() {
        return defaultSmileyString;
    }

    public static void setDefaultSmileyString(String file) {
        defaultSmileyString = file;
    }

    protected String getSmileyString() {
        return this.smileyString;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setIsDebugging(boolean debug) {
        this.debug = debug;
    }
}

