/*
 * Decompiled with CFR 0.152.
 */
package irc.security;

import irc.EventDispatcher;
import irc.security.DefaultSecuredProvider;
import irc.security.SecuredProvider;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class SecurityProvider
implements ActionListener {
    private SecuredProvider _provider = new DefaultSecuredProvider();
    private boolean _answer;

    private boolean tryProvider(String name) {
        SecuredProvider old = this._provider;
        try {
            Class<?> cl = Class.forName("irc.security.prv.Specific" + name + "SecuredProvider");
            this._provider = (SecuredProvider)cl.newInstance();
            if (!this._provider.tryProvider()) {
                throw new Exception();
            }
            return true;
        }
        catch (Exception ex) {
            this._provider = old;
            return false;
        }
    }

    public String getProviderName() {
        return this._provider.getName();
    }

    public Socket getSocket(String host, int port) throws UnknownHostException, IOException {
        try {
            Socket ans = (Socket)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getSocket", new Object[]{host, new Integer(port)});
            return ans;
        }
        catch (InterruptedException ex) {
            throw new IOException("Interrupted");
        }
        catch (Throwable ex) {
            throw new IOException(ex.getClass().getName() + " : " + ex.getMessage());
        }
    }

    public ServerSocket getServerSocket(int port) throws IOException {
        try {
            return (ServerSocket)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getServerSocket", new Object[]{new Integer(port)});
        }
        catch (InterruptedException ex) {
            throw new IOException("Interrupted");
        }
        catch (Throwable ex) {
            throw new IOException(ex.getClass().getName() + " : " + ex.getMessage());
        }
    }

    public boolean confirm(Frame parent, String title, String msg) {
        Dialog f;
        Frame tmp = null;
        if (parent == null) {
            tmp = new Frame();
            f = new Dialog(tmp, title, true);
        } else {
            f = new Dialog(parent, title, true);
        }
        f.setLayout(new BorderLayout());
        f.add((Component)new Label(msg), "Center");
        Button b1 = new Button("Yes");
        Button b2 = new Button("No");
        Panel p = new Panel();
        f.setResizable(false);
        f.add((Component)p, "South");
        p.add(b1);
        p.add(b2);
        b1.addActionListener(this);
        b2.addActionListener(this);
        f.pack();
        this._answer = false;
        f.setVisible(true);
        b1.removeActionListener(this);
        b2.removeActionListener(this);
        f.setVisible(false);
        f.dispose();
        f = null;
        if (tmp != null) {
            tmp.setVisible(false);
            tmp.dispose();
            tmp = null;
        }
        return this._answer;
    }

    public void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        this._answer = false;
        if (b.getLabel().equals("Yes")) {
            this._answer = true;
        }
        ((Window)b.getParent().getParent()).setVisible(false);
    }

    public FileInputStream getFileInputStream(File file) throws IOException {
        if (!this.confirm(null, "Security warning", "Authorize file read action on " + file + "?")) {
            throw new IOException("User denied access");
        }
        try {
            return (FileInputStream)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getFileInputStream", new Object[]{file});
        }
        catch (InterruptedException ex) {
            throw new IOException("Interrupted");
        }
        catch (Throwable ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public FileOutputStream getFileOutputStream(File file) throws IOException {
        if (!this.confirm(null, "Security warning", "Authorize file write action on " + file + "?")) {
            throw new IOException("User denied access");
        }
        try {
            return (FileOutputStream)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getFileOutputStream", new Object[]{file});
        }
        catch (InterruptedException ex) {
            throw new IOException("Interrupted");
        }
        catch (Throwable ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public int getFileSize(File file) {
        try {
            return (Integer)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getFileSize", new Object[]{file});
        }
        catch (Throwable ex) {
            return -1;
        }
    }

    public File getLoadFile(String title) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getLoadFile", new Object[]{title});
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public File getSaveFile(String title) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getSaveFile", new Object[]{title});
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public File getSaveFile(String file, String title) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getSaveFile", new Object[]{file, title});
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public InetAddress getLocalHost() throws UnknownHostException {
        try {
            return (InetAddress)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getLocalHost", new Object[0]);
        }
        catch (InterruptedException ex) {
            throw new UnknownHostException("Unable to resolve");
        }
        catch (Throwable ex) {
            throw new UnknownHostException(ex.getMessage());
        }
    }

    public String resolve(InetAddress addr) {
        try {
            return (String)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "resolve", new Object[]{addr});
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

