/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

import irc.IRCConfiguration;
import irc.SmileyTable;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.Vector;

public class CharactersDrawer {
    private IRCConfiguration _ircConfiguration;
    private char[] _current;
    private int _lineSpacing;

    public CharactersDrawer(IRCConfiguration config) {
        this._ircConfiguration = config;
        this._current = new char[256];
        this._lineSpacing = config.getI("style:linespacing");
    }

    private int getBitmapSmileyWidth(int c, ImageObserver obs) {
        Image img = this._ircConfiguration.getSmileyTable().getImage(c);
        if (img == null) {
            return 0;
        }
        return img.getWidth(obs);
    }

    private int getBitmapSmileyHeight(int c, ImageObserver obs) {
        Image img = this._ircConfiguration.getSmileyTable().getImage(c);
        if (img == null) {
            return 0;
        }
        return img.getHeight(obs);
    }

    private Object drawBitmapSmiley(Graphics g, FontMetrics fm, int smiley, int x, int y, ImageObserver obs) {
        Image img = this._ircConfiguration.getSmileyTable().getImage(smiley);
        if (img == null) {
            return null;
        }
        int h = this.getBitmapSmileyHeight(smiley, obs);
        y -= h;
        g.drawImage(img, x, y += fm.getDescent(), obs);
        return img;
    }

    private String handleSmiley(String line, String ascii, char code) {
        int pos = line.indexOf(ascii);
        if (pos == -1) {
            return line;
        }
        String previous = line.substring(0, pos);
        String after = line.substring(pos + ascii.length());
        char toAdd = (char)(code + 57344);
        line = previous + toAdd + after;
        return this.handleSmiley(line, ascii, code);
    }

    public String decodeLine(String line) {
        SmileyTable table = this._ircConfiguration.getSmileyTable();
        int s = table.getSize();
        for (int i = 0; i < s; ++i) {
            String m = table.getMatch(i);
            line = this.handleSmiley(line, m, (char)i);
        }
        return line;
    }

    public int getWidth(String str, FontMetrics fm, ImageObserver obs) {
        if (this._current.length < str.length()) {
            this._current = new char[str.length() * 2];
        }
        int size = 0;
        int w = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\ue000' && c <= '\uf8ff') {
                c = (char)(c - 57344);
                w += fm.charsWidth(this._current, 0, size);
                size = 0;
                w += this.getBitmapSmileyWidth(c, obs);
                continue;
            }
            this._current[size++] = c;
        }
        return w += fm.charsWidth(this._current, 0, size);
    }

    public int getHeight(String str, FontMetrics fm, ImageObserver obs) {
        int h = 0;
        int mh = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < '\ue000' || c > '\uf8ff' || (h = this.getBitmapSmileyHeight(c = (char)(c - 57344), obs)) <= mh) continue;
            mh = h;
        }
        h = fm.getFont().getSize() + 1;
        if (h > mh) {
            mh = h;
        }
        return mh + this._lineSpacing;
    }

    public void getWidthHeight(String str, FontMetrics fm, Dimension res, ImageObserver obs) {
        if (this._current.length < str.length()) {
            this._current = new char[str.length() * 2];
        }
        int size = 0;
        int h = 0;
        int w = 0;
        int mh = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\ue000' && c <= '\uf8ff') {
                c = (char)(c - 57344);
                w += fm.charsWidth(this._current, 0, size);
                h = this.getBitmapSmileyHeight(c, obs);
                if (h > mh) {
                    mh = h;
                }
                w += this.getBitmapSmileyWidth(c, obs);
                size = 0;
                continue;
            }
            this._current[size++] = c;
        }
        w += fm.charsWidth(this._current, 0, size);
        h = fm.getFont().getSize() + 1;
        if (h > mh) {
            mh = h;
        }
        res.width = w;
        res.height = mh + this._lineSpacing;
    }

    public void draw(String str, Graphics g, FontMetrics fm, int x, int y, ImageObserver obs, Vector handles) {
        if (this._current.length < str.length()) {
            this._current = new char[str.length() * 2];
        }
        int size = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\ue000' && c <= '\uf8ff') {
                c = (char)(c - 57344);
                g.drawChars(this._current, 0, size, x, y);
                size = 0;
                Object handle = this.drawBitmapSmiley(g, fm, c, x += fm.charsWidth(this._current, 0, size), y, obs);
                if (handles == null) {
                    handles = new Vector<Object>();
                }
                handles.insertElementAt(handle, handles.size());
                x += this.getBitmapSmileyWidth(c, obs);
                continue;
            }
            this._current[size++] = c;
        }
        g.drawChars(this._current, 0, size, x, y);
    }
}

