/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.StyleContext;
import irc.style.CharacterGroupItem;
import irc.style.CharacterInfo;
import irc.style.CharactersDrawer;
import irc.style.DecodedLine;
import irc.style.DecodedLineInternal;
import irc.style.DrawResult;
import irc.style.DrawResultItem;
import irc.style.FormattedStringDrawerListener;
import irc.style.LineItem;
import irc.style.StyledRectangle;
import irc.style.WordItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.Vector;

public class FormattedStringDrawer
implements ImageObserver {
    private Font _font;
    private Font _fontPlain;
    private Font _fontBold;
    private Color[] _cols;
    private CharactersDrawer _drawer;
    private IRCConfiguration _config;
    private Dimension _tmp;
    private LineItem[] _lines;
    private int _vdirection;
    private int _hdirection;
    private FormattedStringDrawerListener _listener;
    public static final int BOTTOM = 0;
    public static final int TOP = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;

    public FormattedStringDrawer(IRCConfiguration config, StyleContext context, FormattedStringDrawerListener listener) {
        this._listener = listener;
        this._tmp = new Dimension();
        this._lines = new LineItem[8];
        for (int i = 0; i < this._lines.length; ++i) {
            this._lines[i] = new LineItem();
        }
        this._config = config;
        this.setFont(config.getStyleFont(context));
        this._drawer = new CharactersDrawer(this._config);
        this.setStyleContext(context);
        this._vdirection = 0;
        this._hdirection = 0;
        if (config.getB("style:righttoleft")) {
            this.setHorizontalDirection(1);
        }
    }

    public FormattedStringDrawer(IRCConfiguration config, StyleContext context) {
        this(config, context, null);
    }

    public void setVerticalDirection(int dir) {
        this._vdirection = dir;
    }

    public int getVerticalDirection() {
        return this._vdirection;
    }

    public void setHorizontalDirection(int dir) {
        this._hdirection = dir;
    }

    public int getHorizontalDirection() {
        return this._hdirection;
    }

    public void setStyleContext(StyleContext context) {
        this._cols = this._config.getStyleColors(context);
    }

    public DecodedLine decodeLine(String str) {
        String decoded;
        DecodedLineInternal ans = new DecodedLineInternal();
        ans.original = str;
        str = str + '\u000f';
        ans.decoded = decoded = this._drawer.decodeLine(str);
        ans.decoded_stripped = this.getStripped(decoded);
        Vector v = this.doWords(str, decoded);
        ans.words = new WordItem[v.size()];
        for (int i = 0; i < ans.words.length; ++i) {
            ans.words[i] = (WordItem)v.elementAt(i);
        }
        return ans;
    }

    private Vector doWords(String ostr, String dstr) {
        Vector<WordItem> words = new Vector<WordItem>();
        CharacterInfo info = new CharacterInfo();
        info.frontColor = this._cols[1];
        info.backColor = this._cols[0];
        info.isTransparent = true;
        while (dstr.length() > 0) {
            WordItem word;
            int opos = ostr.indexOf(32);
            int dpos = dstr.indexOf(32);
            if (dpos == -1) {
                word = this.decodeWord(info, dstr + " ", this._cols);
                word.originalword = ostr + " ";
                word.originalstrippedword = this.getStripped(ostr + " ");
                dstr = "";
            } else {
                String owrd = ostr.substring(0, opos);
                String dwrd = dstr.substring(0, dpos);
                word = this.decodeWord(info, dwrd + " ", this._cols);
                word.originalword = owrd + " ";
                word.originalstrippedword = this.getStripped(owrd + " ");
                ostr = ostr.substring(opos + 1);
                dstr = dstr.substring(dpos + 1);
            }
            words.insertElementAt(word, words.size());
            info = word.lastInfo;
        }
        return words;
    }

    public int getHeight(DecodedLine str, FontMetrics fm) {
        return this._drawer.getHeight(str.decoded_stripped, fm, this);
    }

    public int getWidth(DecodedLine str, FontMetrics fm) {
        return this._drawer.getWidth(str.decoded_stripped, fm, this);
    }

    private Font deriveFont(Font fnt, int style) {
        return new Font(fnt.getName(), style, fnt.getSize());
    }

    public void setColors(Color[] cols) {
        this._cols = cols;
    }

    public Color getColor(int i) {
        return this._cols[i];
    }

    public void setFont(Font fnt) {
        this._font = fnt;
        this._fontPlain = this.deriveFont(this._font, 0);
        this._fontBold = this.deriveFont(this._font, 1);
    }

    public Font getFont() {
        return this._font;
    }

    private WordItem decodeWord(CharacterInfo base, String str, Color[] cols) {
        Vector<CharacterGroupItem> v = new Vector<CharacterGroupItem>();
        CharacterInfo current = new CharacterInfo(base);
        CharacterGroupItem currentItem = new CharacterGroupItem(new CharacterInfo(current));
        int size = str.length();
        for (int pos = 0; pos < size; ++pos) {
            char c = str.charAt(pos);
            if (c < ' ') {
                char code = c;
                if (code == '\u000f') {
                    current.isBold = false;
                    current.isUnderline = false;
                    current.isReverse = false;
                    current.frontColor = cols[1];
                    current.backColor = cols[0];
                    current.isTransparent = true;
                } else if (code == '\u0002') {
                    current.isBold = !current.isBold;
                } else if (code == '\u001f') {
                    current.isUnderline = !current.isUnderline;
                } else if (code == '\u0016') {
                    boolean bl = current.isReverse = !current.isReverse;
                    if (current.isReverse) {
                        current.frontColor = cols[0];
                        current.backColor = cols[1];
                        current.isTransparent = false;
                    } else {
                        current.frontColor = cols[1];
                        current.backColor = cols[0];
                        current.isTransparent = true;
                    }
                } else if (code == '\u0003') {
                    int col;
                    boolean front = true;
                    String frontC = "";
                    String backC = "";
                    ++pos;
                    while (pos < size) {
                        char d = str.charAt(pos);
                        if (d >= '0' && d <= '9') {
                            if (front) {
                                if (frontC.length() == 2) {
                                    --pos;
                                    break;
                                }
                                frontC = frontC + d;
                            } else {
                                if (backC.length() == 2) {
                                    --pos;
                                    break;
                                }
                                backC = backC + d;
                            }
                            ++pos;
                            continue;
                        }
                        if (d == ',') {
                            if (front) {
                                front = false;
                                ++pos;
                                continue;
                            }
                            --pos;
                            break;
                        }
                        --pos;
                        break;
                    }
                    if (frontC.length() == 0) {
                        backC = "";
                    }
                    if (frontC.length() > 0) {
                        col = Integer.parseInt(frontC);
                        current.frontColor = cols[col %= this._cols.length];
                    }
                    if (backC.length() > 0) {
                        col = Integer.parseInt(backC);
                        current.backColor = cols[col %= this._cols.length];
                        boolean bl = current.isTransparent = col == 0;
                    }
                    if (frontC.length() == 0 && backC.length() == 0) {
                        current.frontColor = cols[1];
                        current.backColor = cols[0];
                        current.isTransparent = true;
                    }
                }
                if (current.equals(currentItem.info)) continue;
                v.insertElementAt(currentItem, v.size());
                currentItem = new CharacterGroupItem(new CharacterInfo(current));
                continue;
            }
            currentItem.s = currentItem.s + c;
        }
        v.insertElementAt(currentItem, v.size());
        CharacterGroupItem[] ans = new CharacterGroupItem[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ans[i] = (CharacterGroupItem)v.elementAt(i);
        }
        return new WordItem(ans, current);
    }

    private FontMetrics getFontMetrics(Graphics g, CharacterInfo nfo) {
        Font old = g.getFont();
        if (nfo.isBold) {
            g.setFont(this._fontBold);
        } else {
            g.setFont(this._fontPlain);
        }
        FontMetrics res = g.getFontMetrics();
        g.setFont(old);
        return res;
    }

    private int drawPart(Graphics g, CharacterInfo nfo, String str, int x, int y, FontMetrics plainMetrics, int clipxl, int clipxr, ImageObserver obs, Vector handles) {
        FontMetrics fm = plainMetrics;
        int down = plainMetrics.getDescent();
        if (nfo.isBold) {
            g.setFont(this._fontBold);
        }
        fm = g.getFontMetrics();
        int width = this._drawer.getWidth(str, fm, this);
        if (x <= clipxr && x + width > clipxl) {
            int height = this._drawer.getHeight(str, fm, this);
            Rectangle originalClip = g.getClipBounds();
            int cx = clipxl;
            int cy = y - height;
            int cw = clipxr - clipxl + 1;
            int ch = height;
            g.clipRect(cx, cy, cw, ch);
            g.setColor(nfo.backColor);
            if (!nfo.isTransparent) {
                g.fillRect(x, y - height, width, height);
            }
            g.setColor(nfo.frontColor);
            this._drawer.draw(str, g, fm, x, y -= down, obs, handles);
            if (nfo.isUnderline) {
                g.drawLine(x, y + 1, x + width - 1, y + 1);
            }
            if (originalClip != null) {
                g.setClip(originalClip.x, originalClip.y, originalClip.width, originalClip.height);
            } else {
                g.setClip(null);
            }
        }
        if (nfo.isBold) {
            g.setFont(this._fontPlain);
        }
        return width;
    }

    private void drawWord(Graphics g, WordItem word, int x, int y, boolean last, FontMetrics plainMetrics, int clipxl, int clipxr, ImageObserver obs, Vector handles) {
        for (int pos = 0; pos < word.items.length; ++pos) {
            CharacterGroupItem item = word.items[pos];
            x += this.drawPart(g, item.info, item.s, x, y, plainMetrics, clipxl, clipxr, obs, handles);
        }
    }

    public String getStripped(String str) {
        CharacterInfo info = new CharacterInfo();
        info.frontColor = this._cols[1];
        info.backColor = this._cols[0];
        info.isTransparent = true;
        String res = "";
        while (str.length() > 0) {
            WordItem word;
            int pos = str.indexOf(32);
            if (pos == -1) {
                word = this.decodeWord(info, str, this._cols);
                str = "";
            } else {
                String wrd = str.substring(0, pos);
                word = this.decodeWord(info, wrd + " ", this._cols);
                str = str.substring(pos + 1);
            }
            if (res.length() > 0) {
                res = res + " " + word.originalword;
                continue;
            }
            res = res + word.originalword;
        }
        return res;
    }

    private boolean isAlphaNum(char c) {
        if (c == '(' || c == ')') {
            return false;
        }
        if (c == '<' || c == '>') {
            return false;
        }
        if (c == '\"' || c == '\"') {
            return false;
        }
        if (c == '{' || c == '}') {
            return false;
        }
        if (c == '.' || c == ',') {
            return false;
        }
        return c != ':';
    }

    private String trimAlphaNum(String s) {
        int index;
        for (index = 0; index < s.length() && !this.isAlphaNum(s.charAt(index)); ++index) {
        }
        if (index == s.length()) {
            return "";
        }
        s = s.substring(index);
        for (index = s.length() - 1; index >= 0 && !this.isAlphaNum(s.charAt(index)); --index) {
        }
        if (index == -1) {
            return "";
        }
        s = s.substring(0, index + 1);
        return s;
    }

    private void getWordItemWidthHeight(Graphics g, WordItem item, Dimension res) {
        int resx = 0;
        int resy = 0;
        for (int i = 0; i < item.items.length; ++i) {
            FontMetrics fm = this.getFontMetrics(g, item.items[i].info);
            this._drawer.getWidthHeight(item.items[i].s, fm, res, this);
            resx += res.width;
            int h = res.height;
            if (h <= resy) continue;
            resy = h;
        }
        res.width = resx;
        res.height = resy;
    }

    private void expandLines() {
        LineItem[] n = new LineItem[this._lines.length * 2];
        System.arraycopy(this._lines, 0, n, 0, this._lines.length);
        for (int i = this._lines.length; i < n.length; ++i) {
            n[i] = new LineItem();
        }
        this._lines = n;
    }

    public int getHeight(DecodedLine str, Graphics g, int x, int wmax, boolean wrap) {
        WordItem[] words = ((DecodedLineInternal)str).words;
        Font currFont = this._fontPlain;
        g.setFont(currFont);
        FontMetrics plainFm = g.getFontMetrics();
        int currentLineLength = 0;
        int w = 0;
        int h = 0;
        int mh = 0;
        for (int i = 0; i < words.length; ++i) {
            WordItem word = words[i];
            this.getWordItemWidthHeight(g, word, this._tmp);
            int wordWidth = this._tmp.width;
            if (w + wordWidth > wmax && currentLineLength > 0 && wrap) {
                w = this._drawer.getWidth("  ", plainFm, this);
                currentLineLength = 0;
                h += mh;
                mh = 0;
            }
            if (this._tmp.height > mh) {
                mh = this._tmp.height;
            }
            ++currentLineLength;
            w += wordWidth;
        }
        if (currentLineLength > 0) {
            h += mh;
        }
        return h;
    }

    public void draw(DecodedLine str, Graphics g, int left, int right, int y, int clipxl, int clipxr, boolean analyse, boolean wrap, DrawResult res) {
        int trimmedWidth;
        int wordHeight;
        int wordWidth;
        int j;
        LineItem line;
        int maxHeight;
        int px;
        int i;
        WordItem[] words = ((DecodedLineInternal)str).words;
        if (res.updateHandles == null) {
            res.updateHandles = new Vector();
        } else if (res.updateHandles.size() > 0) {
            res.updateHandles.removeAllElements();
        }
        Font currFont = this._fontPlain;
        g.setFont(currFont);
        FontMetrics plainFm = g.getFontMetrics();
        int lineCount = 0;
        int firstWordInLine = 0;
        int currentLineLength = 0;
        int wmax = right - left + 1;
        if (wrap) {
            int w = 0;
            for (int i2 = 0; i2 < words.length; ++i2) {
                WordItem word = words[i2];
                this.getWordItemWidthHeight(g, word, this._tmp);
                int wordWidth2 = this._tmp.width;
                if (w + wordWidth2 > wmax && currentLineLength > 0) {
                    w = this._drawer.getWidth("  ", plainFm, this);
                    LineItem newLine = this._lines[lineCount++];
                    if (lineCount == this._lines.length) {
                        this.expandLines();
                    }
                    newLine.first = firstWordInLine;
                    newLine.count = currentLineLength;
                    firstWordInLine = i2;
                    currentLineLength = 0;
                }
                ++currentLineLength;
                w += wordWidth2;
            }
            if (currentLineLength != 0) {
                LineItem newLine = this._lines[lineCount++];
                if (lineCount == this._lines.length) {
                    this.expandLines();
                }
                newLine.first = firstWordInLine;
                newLine.count = currentLineLength;
            }
        } else {
            LineItem newLine = this._lines[lineCount++];
            newLine.first = 0;
            newLine.count = words.length;
        }
        int s = 0;
        if (analyse) {
            s = words.length;
        }
        if (res.items == null || res.items.length != s) {
            res.items = new DrawResultItem[s];
        }
        DrawResultItem[] dres = res.items;
        int minX = right;
        int maxX = left;
        int h = 0;
        int py = 0;
        int marginWidth = this._drawer.getWidth("  ", plainFm, this);
        int hdir = 1;
        if (this._hdirection == 1) {
            hdir = -1;
        }
        if (this._vdirection == 0) {
            for (i = lineCount - 1; i >= 0; --i) {
                px = left;
                if (hdir == -1) {
                    px = right;
                }
                maxHeight = 0;
                if (i != 0) {
                    px += hdir * marginWidth;
                }
                line = this._lines[i];
                for (j = line.first; j < line.first + line.count; ++j) {
                    this.getWordItemWidthHeight(g, words[j], this._tmp);
                    wordWidth = this._tmp.width;
                    wordHeight = this._tmp.height;
                    if (hdir == -1) {
                        px -= wordWidth;
                    }
                    trimmedWidth = wordWidth;
                    if (maxHeight < wordHeight) {
                        maxHeight = wordHeight;
                    }
                    if (px + wordWidth > clipxl && px <= clipxr) {
                        this.drawWord(g, words[j], px, y, j == line.first + line.count - 1, plainFm, clipxl, clipxr, this, res.updateHandles);
                    }
                    if (analyse) {
                        String owrd = words[j].originalword;
                        String swrd = words[j].originalstrippedword;
                        String twrd = this.trimAlphaNum(swrd.trim());
                        if (dres[j] == null) {
                            dres[j] = new DrawResultItem();
                        }
                        DrawResultItem ritem = dres[j];
                        ritem.parent = res;
                        ritem.item = twrd;
                        ritem.originalword = owrd;
                        ritem.originalstrippedword = swrd;
                        ritem.rectangle = new StyledRectangle(px, py - wordHeight, trimmedWidth, wordHeight);
                    }
                    if (hdir == 1) {
                        px += wordWidth;
                    }
                    if (px > maxX) {
                        maxX = px;
                    }
                    if (px >= minX) continue;
                    minX = px;
                }
                y -= maxHeight;
                py -= maxHeight;
                h += maxHeight;
            }
            if (analyse) {
                for (i = 0; i < dres.length; ++i) {
                    dres[i].rectangle.y += h;
                }
            }
        } else if (this._vdirection == 1) {
            for (i = 0; i < lineCount; ++i) {
                px = left;
                if (hdir == -1) {
                    px = right;
                }
                maxHeight = 0;
                if (i != 0) {
                    px += hdir * marginWidth;
                }
                line = this._lines[i];
                for (j = line.first; j < line.first + line.count; ++j) {
                    this.getWordItemWidthHeight(g, words[j], this._tmp);
                    wordWidth = this._tmp.width;
                    wordHeight = this._tmp.height;
                    if (hdir == -1) {
                        px -= wordWidth;
                    }
                    trimmedWidth = wordWidth;
                    if (maxHeight < wordHeight) {
                        maxHeight = wordHeight;
                    }
                    if (px + wordWidth > clipxl && px <= clipxr) {
                        this.drawWord(g, words[j], px, y + wordHeight, j == line.first + line.count - 1, plainFm, clipxl, clipxr, this, res.updateHandles);
                    }
                    if (analyse) {
                        String wrd = words[j].decodedword;
                        String owrd = words[j].originalword;
                        String swrd = words[j].originalstrippedword;
                        String twrd = this.trimAlphaNum(wrd.trim());
                        if (dres[j] == null) {
                            dres[j] = new DrawResultItem();
                        }
                        DrawResultItem ritem = dres[j];
                        ritem.parent = res;
                        ritem.item = twrd;
                        ritem.originalword = owrd;
                        ritem.originalstrippedword = swrd;
                        ritem.rectangle = new StyledRectangle(px, py, trimmedWidth, wordHeight);
                    }
                    if (hdir == 1) {
                        px += wordWidth;
                    }
                    if (px > maxX) {
                        maxX = px;
                    }
                    if (px >= minX) continue;
                    minX = px;
                }
                y += maxHeight;
                py += maxHeight;
                h += maxHeight;
            }
            y -= h;
        }
        int x1 = left;
        int x2 = maxX;
        if (hdir == -1) {
            x1 = minX;
            x2 = right;
        }
        if (analyse) {
            for (int i3 = 0; i3 < res.items.length; ++i3) {
                res.items[i3].rectangle.x -= x1;
            }
        }
        if (res.rectangle == null) {
            res.rectangle = new StyledRectangle(x1, y, x2 - x1 + 1, h);
        } else {
            res.rectangle.x = x1;
            res.rectangle.y = y;
            res.rectangle.width = x2 - x1 + 1;
            res.rectangle.height = h;
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x40) != 0) {
            return false;
        }
        if ((infoflags & 0x80) != 0) {
            return false;
        }
        if ((infoflags & 4) != 0) {
            return true;
        }
        if (this._listener != null) {
            int what = 0;
            if ((infoflags & 1) != 0) {
                what |= 2;
            }
            if ((infoflags & 2) != 0) {
                what |= 2;
            }
            if ((infoflags & 0x20) != 0) {
                what |= 1;
            }
            if ((infoflags & 0x10) != 0) {
                what |= 4;
            }
            if ((infoflags & 8) != 0) {
                what |= 1;
            }
            try {
                Boolean b = (Boolean)EventDispatcher.dispatchEventAsyncAndWaitEx(this._listener, "displayUpdated", new Object[]{img, new Integer(what)});
                return b;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

