/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

class LimitedArray {
    private int _size = 0;
    private int _maximum;
    private int _missing = 0;
    private Object[] _array;

    public LimitedArray(int max) {
        this._maximum = max;
        this._array = new Object[4];
    }

    public void expand() {
        if (this._array.length >= this._maximum) {
            return;
        }
        int ns = this._array.length << 1;
        Object[] n = new Object[ns];
        System.arraycopy(this._array, 0, n, 0, this._array.length);
        this._array = n;
    }

    public void add(Object obj) {
        if (this.size() >= this._array.length) {
            this.expand();
        }
        if (this.size() >= this._array.length) {
            ++this._missing;
        }
        this._array[this.size() % this._array.length] = obj;
        ++this._size;
    }

    public Object get(int index) {
        if (index < this._missing) {
            return null;
        }
        return this._array[index % this._array.length];
    }

    public int size() {
        return this._size;
    }
}

