/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

import irc.IRCConfiguration;
import irc.ListenerGroup;
import irc.StyleContext;
import irc.style.ChannelRecognizer;
import irc.style.DecodedLine;
import irc.style.DrawResult;
import irc.style.DrawResultItem;
import irc.style.FormattedStringDrawer;
import irc.style.FormattedStringDrawerListener;
import irc.style.LimitedArray;
import irc.style.MultipleWordCatcher;
import irc.style.ResultPair;
import irc.style.StyledListListener;
import irc.style.StyledRectangle;
import irc.style.URLRecognizer;
import irc.style.WordListRecognizer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class StyledList
extends Panel
implements MouseListener,
MouseMotionListener,
FormattedStringDrawerListener {
    private LimitedArray _list;
    private Hashtable _nickInfos;
    private boolean _wrap;
    private int _last;
    private int _first;
    private int _left;
    private int _width;
    private int _toScrollX;
    private int _toScrollY;
    private FormattedStringDrawer _drawer;
    private Image _buffer;
    private int _bufferWidth;
    private int _bufferHeight;
    private int _lastWidth;
    private int _lastHeight;
    private Hashtable _results;
    private MultipleWordCatcher _catcher;
    private WordListRecognizer _wordListRecognizer;
    private IRCConfiguration _ircConfiguration;
    private int _pressedX;
    private int _pressedY;
    private int _draggedX;
    private int _draggedY;
    private boolean _dragging;
    private DrawResultItem _currentItem;
    private DrawResultItem _currentFloatItem;
    private DrawResultItem _currentHighLightItem;
    private String _currentFloatText;
    private String _copiedString;
    private boolean _fullDraw;
    private ListenerGroup _listeners;
    private ResultPair[] _addedResults;
    private int _addedCount;
    private int _hdirection;
    private int _vdirection;
    private Color _colormale;
    private Color _colorfemeale;
    private Color _colorundef;
    private Vector _updateItems;
    private long _lastRefresh = System.currentTimeMillis();
    private Image _backImage = null;
    private int _backTiling = 0;
    private int _maximumSize;
    private DecodedLine _emptyLine;
    private static final int BOTTOM = 0;
    private static final int TOP = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private static final boolean _doubleBuffer = true;

    public StyledList(IRCConfiguration config, StyleContext context) {
        this(config, true, context);
    }

    public StyledList(IRCConfiguration config, boolean wrap, StyleContext context) {
        this(config, wrap, context, Color.blue, Color.pink, Color.gray);
    }

    public StyledList(IRCConfiguration config, boolean wrap, StyleContext context, Color male, Color femeale, Color undef) {
        this._colormale = male;
        this._colorfemeale = femeale;
        this._colorundef = undef;
        this._nickInfos = new Hashtable();
        this._fullDraw = false;
        this._addedResults = new ResultPair[64];
        for (int i = 0; i < this._addedResults.length; ++i) {
            this._addedResults[i] = new ResultPair();
        }
        this._addedCount = 0;
        this._hdirection = 0;
        this._vdirection = 0;
        this._ircConfiguration = config;
        this._copiedString = "";
        this._dragging = false;
        this._currentFloatItem = null;
        this._currentFloatText = null;
        this._currentItem = null;
        this._toScrollX = 0;
        this._toScrollY = 0;
        this._left = 0;
        this._wrap = wrap;
        this._buffer = null;
        this._drawer = new FormattedStringDrawer(this._ircConfiguration, context, this);
        this._drawer.setHorizontalDirection(this._hdirection);
        this._drawer.setVerticalDirection(this._vdirection);
        this._catcher = new MultipleWordCatcher();
        this._wordListRecognizer = new WordListRecognizer();
        this._catcher.addRecognizer(new ChannelRecognizer());
        this._catcher.addRecognizer(new URLRecognizer());
        this._catcher.addRecognizer(this._wordListRecognizer);
        this._results = new Hashtable();
        this._listeners = new ListenerGroup();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._maximumSize = this._ircConfiguration.getI("style:maximumlinecount");
        this._emptyLine = this._drawer.decodeLine("");
        this.clear();
        this.setBackgroundImage(this._ircConfiguration.getStyleBackgroundImage(context));
        this.setBackgroundTiling(this._ircConfiguration.getStyleBackgroundTiling(context));
        if (this._ircConfiguration.getB("style:righttoleft")) {
            this.setHorizontalDirection(1);
        }
    }

    public void release() {
        this.clear();
        this.dispose();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    private void drawBackImage(Graphics g, int w, int h) {
        int iw = this._backImage.getWidth(this);
        int ih = this._backImage.getHeight(this);
        switch (this._backTiling & 0xFF) {
            case 3: {
                int x = 0;
                int y = 0;
                if ((this._backTiling & 0x100) != 0) {
                    x = w - iw - 1;
                }
                if ((this._backTiling & 0x200) != 0) {
                    y = h - ih - 1;
                }
                g.setColor(this._drawer.getColor(0));
                g.fillRect(0, 0, w, h);
                g.drawImage(this._backImage, x, y, this._drawer.getColor(0), this);
                break;
            }
            case 0: {
                int x = (w - iw) / 2;
                int y = (h - ih) / 2;
                g.setColor(this._drawer.getColor(0));
                g.fillRect(0, 0, w, h);
                g.drawImage(this._backImage, x, y, this._drawer.getColor(0), this);
                break;
            }
            case 1: {
                g.drawImage(this._backImage, 0, 0, w, h, this._drawer.getColor(0), this);
                break;
            }
            case 2: {
                for (int x = 0; x < w; x += iw) {
                    for (int y = 0; y < h; y += ih) {
                        g.drawImage(this._backImage, x, y, this._drawer.getColor(0), this);
                    }
                }
                break;
            }
        }
    }

    private void expandResult() {
        ResultPair[] n = new ResultPair[this._addedResults.length * 2];
        System.arraycopy(this._addedResults, 0, n, 0, this._addedResults.length);
        for (int i = this._addedResults.length; i < n.length; ++i) {
            n[i] = new ResultPair();
        }
        this._addedResults = n;
    }

    public void setHorizontalDirection(int direction) {
        this._hdirection = direction;
        this._drawer.setHorizontalDirection(this._hdirection);
    }

    public int getHorizontalDirection() {
        return this._hdirection;
    }

    public void setBackgroundImage(Image img) {
        this._backImage = img;
        this.repaint();
    }

    public void setBackgroundTiling(int t) {
        this._backTiling = t;
        this.repaint();
    }

    public void setFont(Font fnt) {
        this._drawer.setFont(fnt);
        this.reinit();
        this.repaint();
    }

    public void setWrap(boolean wrap) {
        this._wrap = wrap;
        this.reinit();
        this.repaint();
    }

    public synchronized void setNickList(String[] list) {
        String[] actualList = new String[list.length];
        this._nickInfos.clear();
        for (int i = 0; i < list.length; ++i) {
            String nick = list[i];
            String info = "";
            int pos = nick.indexOf(":");
            if (pos != -1) {
                info = nick.substring(pos + 1);
                nick = nick.substring(0, pos);
            }
            actualList[i] = nick;
            this._nickInfos.put(nick.toLowerCase(Locale.ENGLISH), info);
        }
        this._wordListRecognizer.setList(actualList);
    }

    public synchronized void addStyledListListener(StyledListListener lis) {
        this._listeners.addListener(lis);
    }

    public synchronized void removeStyledListListener(StyledListListener lis) {
        this._listeners.removeListener(lis);
    }

    public synchronized void setLeft(int left) {
        int oldLeft = this._left;
        this._left = left;
        if (this._left < 0) {
            this._left = 0;
        }
        if (this._left >= this.getLogicalWidth()) {
            this._left = this.getLogicalWidth() - 1;
        }
        if (this._hdirection == 1) {
            this._left = -this._left;
        }
        if (this._left != oldLeft) {
            this.addToScroll(this._left - oldLeft, 0);
            this.repaint();
        }
    }

    public int getLeft() {
        if (this._hdirection == 1) {
            return -this._left;
        }
        return this._left;
    }

    public synchronized void setFirst(int first) {
        if (this._vdirection != 1) {
            this._fullDraw = true;
        }
        this._vdirection = 1;
        this._drawer.setVerticalDirection(1);
        int oldFirst = this._first;
        this._first = first;
        if (this._first < 0) {
            this._last = 0;
        }
        if (this._first >= this._list.size()) {
            this._last = this._list.size() - 1;
        }
        if (this._first != oldFirst) {
            this.addToScroll(0, this._first - oldFirst);
            this.repaint();
        }
    }

    public synchronized void setLast(int last) {
        if (this._vdirection != 0) {
            this._fullDraw = true;
        }
        this._vdirection = 0;
        this._drawer.setVerticalDirection(0);
        int oldLast = this._last;
        this._last = last;
        if (this._last < 0) {
            this._last = 0;
        }
        if (this._last >= this._list.size()) {
            this._last = this._list.size() - 1;
        }
        if (this._last != oldLast) {
            this.addToScroll(0, this._last - oldLast);
            this.repaint();
        }
    }

    public int getLogicalWidth() {
        return this._width;
    }

    public int getLast() {
        return this._last;
    }

    public synchronized int getLineCount() {
        return this._list.size();
    }

    public synchronized void addLine(String line) {
        DecodedLine dline = this._drawer.decodeLine(line);
        this._list.add(dline);
        if (this._vdirection == 0) {
            if (this._last == this._list.size() - 2) {
                this.setLast(this._last + 1);
            }
        } else if (this._vdirection == 1) {
            this._fullDraw = true;
            this.repaint();
        }
    }

    public synchronized void addLines(String[] lines) {
        boolean willScroll = this._list.size() - 1 == this._last;
        for (int i = 0; i < lines.length; ++i) {
            this._list.add(this._drawer.decodeLine(lines[i]));
        }
        if (this._vdirection == 0) {
            if (willScroll) {
                this.setLast(this._list.size() - 1);
            }
        } else if (this._vdirection == 1) {
            this._fullDraw = true;
            this.repaint();
        }
    }

    private void reinit() {
        if (this._buffer != null) {
            this._buffer.flush();
        }
        this._buffer = null;
        this._results = new Hashtable();
    }

    public synchronized void dispose() {
        this.reinit();
    }

    public synchronized void clear() {
        this._list = new LimitedArray(this._maximumSize);
        this._last = this._list.size() - 1;
        this._first = 0;
        this.setLeft(0);
        this._width = this.getSize().width;
        this._fullDraw = true;
        this.repaint();
    }

    public synchronized void clear(int max) {
        this._maximumSize = max;
        this.clear();
    }

    private void drawPart(Graphics g, int x, int y, int w, int h, boolean analyse, int gw, int gh) {
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (this._backImage != null) {
            this.drawBackImage(g, gw, gh);
        } else {
            g.setColor(this._drawer.getColor(0));
            g.fillRect(x, y, w, h);
        }
        if (this._vdirection == 0) {
            int posY;
            int first = this._last;
            for (posY = this.getSize().height; posY > y + h && first >= 0; posY -= this.getHeight(first--, g)) {
            }
            if (first != this._last) {
                posY += this.getHeight(++first, g);
            }
            this.draw(g, 0, first, posY, y, x, x + w - 1, analyse);
        } else if (this._vdirection == 1) {
            int posY;
            int first = this._first;
            for (posY = 0; posY < y && first < this._list.size(); posY += this.getHeight(first++, g)) {
            }
            if (first != this._first) {
                posY -= this.getHeight(--first, g);
            }
            this.draw(g, first, this._list.size() - 1, posY, y + h, x, x + w - 1, analyse);
        }
    }

    public synchronized void paint(Graphics g) {
        if (this._toScrollX != 0 || this._toScrollY != 0) {
            this._fullDraw = true;
        }
        this.update(g);
    }

    private int getHeight(Graphics g, int a, int b) {
        if (b < a) {
            int tmp = a;
            a = b;
            b = tmp;
        }
        int res = 0;
        for (int i = a; i <= b; ++i) {
            res += this.getHeight(i, g);
        }
        return res;
    }

    private void draw(Graphics g, int from, int to, int y, int crossy, int debx, int finx, boolean analyse) {
        int w = this.getSize().width;
        this._addedCount = 0;
        DrawResult res = new DrawResult();
        if (this._vdirection == 0) {
            StyledRectangle rect;
            for (int index = to; index >= from && y > crossy; y -= rect.height, --index) {
                DecodedLine str = (DecodedLine)this._list.get(index);
                if (str == null) {
                    str = this._emptyLine;
                }
                this._drawer.draw(str, g, -this._left, w - 1 - this._left, y, debx, finx, analyse, this._wrap, res);
                rect = res.rectangle;
                if (rect.width > this._width) {
                    this._width = rect.width;
                    this._listeners.sendEventAsync("virtualSizeChanged", this);
                }
                if (!analyse) continue;
                ResultPair p = this._addedResults[this._addedCount++];
                if (this._addedCount == this._addedResults.length) {
                    this.expandResult();
                }
                p.line = index;
                p.result = res;
                res = new DrawResult();
            }
        } else {
            StyledRectangle rect;
            for (int index = from; index <= to && y < crossy; y += rect.height, ++index) {
                DecodedLine str = (DecodedLine)this._list.get(index);
                if (str == null) {
                    str = this._emptyLine;
                }
                this._drawer.draw(str, g, -this._left, w - 1 - this._left, y, debx, finx, analyse, this._wrap, res);
                rect = res.rectangle;
                if (rect.width > this._width) {
                    this._width = rect.width;
                    this._listeners.sendEventAsync("virtualSizeChanged", this);
                }
                if (!analyse) continue;
                ResultPair p = this._addedResults[this._addedCount++];
                if (this._addedCount == this._addedResults.length) {
                    this.expandResult();
                }
                p.line = index;
                p.result = res;
                res = new DrawResult();
            }
        }
    }

    private void addToScroll(int vx, int vy) {
        this._toScrollX += vx;
        this._toScrollY += vy;
    }

    private int getScrollX() {
        if (this._dragging) {
            return 0;
        }
        int res = this._toScrollX;
        this._toScrollX = 0;
        return res;
    }

    private int getScrollY() {
        if (this._dragging) {
            return 0;
        }
        int res = this._toScrollY;
        this._toScrollY = 0;
        return res;
    }

    private void scrollDrawItems(int dx, int dy) {
        int h = this.getSize().height;
        Enumeration e = this._results.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            DrawResult res = (DrawResult)this._results.get(key);
            res.rectangle.x += dx;
            res.rectangle.y += dy;
            if (res.rectangle.y + res.rectangle.height >= 0 && res.rectangle.y < h) continue;
            this._results.remove(key);
        }
    }

    private void combineItems() {
        for (int i = 0; i < this._addedCount; ++i) {
            ResultPair k = this._addedResults[i];
            this._results.put(new Integer(k.line), k.result);
        }
        this._addedCount = 0;
    }

    private DrawResultItem findItem(int x, int y) {
        Enumeration e = this._results.elements();
        while (e.hasMoreElements()) {
            DrawResult result = (DrawResult)e.nextElement();
            if (!result.rectangle.contains(x, y)) continue;
            int rx = x - result.rectangle.x;
            int ry = y - result.rectangle.y;
            for (int i = 0; i < result.items.length; ++i) {
                DrawResultItem item = result.items[i];
                if (!item.rectangle.contains(rx, ry)) continue;
                return item;
            }
        }
        return null;
    }

    private int findLine(int y) {
        Enumeration e = this._results.keys();
        while (e.hasMoreElements()) {
            Integer i = (Integer)e.nextElement();
            DrawResult result = (DrawResult)this._results.get(i);
            if (result.rectangle.y > y || result.rectangle.y + result.rectangle.height <= y) continue;
            return i;
        }
        return -1;
    }

    private int getHeight(int lineIndex, Graphics g) {
        DrawResult r = (DrawResult)this._results.get(new Integer(lineIndex));
        if (r != null) {
            return r.rectangle.height;
        }
        int wrapPos = this.getSize().width;
        DecodedLine str = (DecodedLine)this._list.get(lineIndex);
        if (str == null) {
            str = this._emptyLine;
        }
        return this._drawer.getHeight(str, g, -this._left, wrapPos, this._wrap);
    }

    private Color findColor(String info) {
        return this._ircConfiguration.getASLColor(info, this._colormale, this._colorfemeale, this._colorundef);
    }

    private synchronized Vector getUpdateItems() {
        Vector items = this._updateItems;
        this._updateItems = null;
        return items;
    }

    private synchronized boolean addToUpdateItems(Integer line) {
        if (this._updateItems == null) {
            this._updateItems = new Vector();
        }
        for (int i = 0; i < this._updateItems.size(); ++i) {
            Integer r = (Integer)this._updateItems.elementAt(i);
            if (!r.equals(line)) continue;
            return false;
        }
        this._updateItems.insertElementAt(line, this._updateItems.size());
        return true;
    }

    public synchronized void update(Graphics g) {
        int x;
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (h <= 0 || w <= 0) {
            return;
        }
        Graphics gra = g;
        if (this._buffer != null) {
            if (this._bufferWidth < w || this._bufferHeight < h) {
                this.reinit();
            }
            if ((double)this._bufferHeight > (double)w * 1.5 || (double)this._bufferHeight > (double)h * 1.5) {
                this.reinit();
            }
            if (this._lastWidth != w || this._lastHeight != h) {
                this._fullDraw = true;
            }
        }
        this._lastWidth = w;
        this._lastHeight = h;
        if (this._buffer == null) {
            this._buffer = this.createImage(w, h);
            if (this._buffer == null) {
                this.repaint();
                return;
            }
            this._bufferWidth = w;
            this._bufferHeight = h;
            this._fullDraw = true;
        }
        gra = this._buffer.getGraphics();
        if (this._ircConfiguration.getB("style:backgroundimage")) {
            this._fullDraw = true;
        }
        int scrx = this.getScrollX();
        int scry = this.getScrollY();
        Vector items = this.getUpdateItems();
        if (!this._fullDraw) {
            int baseY;
            if (scrx < 0) {
                gra.copyArea(0, 0, w + scrx, h, -scrx, 0);
                this.scrollDrawItems(-scrx, 0);
                this.drawPart(gra, 0, 0, -scrx, h, false, w, h);
            } else if (scrx > 0) {
                gra.copyArea(scrx, 0, w - scrx, h, -scrx, 0);
                this.scrollDrawItems(-scrx, 0);
                this.drawPart(gra, w - scrx, 0, scrx, h, false, w, h);
            }
            if (scry > 0) {
                baseY = this._vdirection == 0 ? this.getHeight(gra, this._last - scry + 1, this._last) : this.getHeight(gra, this._first - scry, this._first - 1);
                gra.copyArea(0, baseY, w, h - baseY, 0, -baseY);
                this.scrollDrawItems(0, -baseY);
                this.drawPart(gra, 0, h - baseY, w, baseY, true, w, h);
                this.combineItems();
            } else if (scry < 0) {
                baseY = this._vdirection == 0 ? this.getHeight(gra, this._last + 1, this._last - scry) : this.getHeight(gra, this._first, this._first - scry - 1);
                gra.copyArea(0, 0, w, h - baseY, 0, baseY);
                this.scrollDrawItems(0, baseY);
                this.drawPart(gra, 0, 0, w, baseY, true, w, h);
                this.combineItems();
            }
            if (items != null) {
                for (int i = 0; i < items.size(); ++i) {
                    Integer line = (Integer)items.elementAt(i);
                    DrawResult res = (DrawResult)this._results.get(line);
                    if (res == null) continue;
                    StyledRectangle r = res.rectangle;
                    this.drawPart(gra, r.x, r.y, r.width, r.height, false, w, h);
                }
            }
        } else {
            this._results = new Hashtable();
            this.drawPart(gra, 0, 0, w, h, true, w, h);
            this.combineItems();
            this._fullDraw = false;
        }
        if (this._dragging) {
            this.makeXor(gra);
        }
        g.drawImage(this._buffer, 0, 0, this);
        if (this._dragging) {
            this.makeXor(gra);
        }
        if (!this._dragging && this._currentFloatItem != null && this._ircConfiguration.getB("style:floatingasl")) {
            String info;
            String text;
            x = this._currentFloatItem.rectangle.x + this._currentFloatItem.parent.rectangle.x + 4;
            int y = this._currentFloatItem.rectangle.y + this._currentFloatItem.parent.rectangle.y;
            y = this._vdirection == 1 ? (y += 8) : (y -= 8);
            if (y < 0) {
                y = 0;
            }
            if ((text = this._ircConfiguration.formatASL(info = this._currentFloatText)).length() > 0) {
                int tw = g.getFontMetrics().stringWidth(text);
                int fh = g.getFont().getSize();
                if (y + fh + 5 > h) {
                    y = h - fh - 5;
                }
                if (x + tw + 5 > w) {
                    x = w - tw - 5;
                }
                g.setColor(this.getAlphaColor(this.findColor(info), this._ircConfiguration.getI("style:floatingaslalpha")));
                g.fillRect(x, y, tw + 4, fh + 4);
                g.setColor(Color.white);
                g.drawString(text, x + 2, y + fh);
            }
        }
        if (this._ircConfiguration.getB("style:highlightlinks") && !this._dragging && this._currentHighLightItem != null) {
            x = this._currentHighLightItem.rectangle.x + this._currentHighLightItem.parent.rectangle.x;
            int y = this._currentHighLightItem.rectangle.y + this._currentHighLightItem.parent.rectangle.y;
            g.setXORMode(Color.white);
            g.setColor(Color.black);
            g.fillRect(x, y, this._currentHighLightItem.rectangle.width, this._currentHighLightItem.rectangle.height);
            g.setPaintMode();
        }
    }

    private Color getAlphaColor(Color c, int alpha) {
        try {
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        catch (Throwable ex) {
            return c;
        }
    }

    private void makeXor(Graphics g) {
        int a;
        int i;
        String res = "";
        int dw = this._draggedX - this._pressedX;
        int dh = this._draggedY - this._pressedY;
        int pressedX = this._pressedX;
        int pressedY = this._pressedY;
        g.setXORMode(Color.white);
        g.setColor(Color.black);
        int basei = i = this.findLine(pressedY);
        DrawResult result = (DrawResult)this._results.get(new Integer(i));
        if (result == null) {
            this._copiedString = "";
            return;
        }
        int px = pressedX - result.rectangle.x;
        int py = pressedY - result.rectangle.y;
        DrawResultItem item = null;
        int b = 0;
        for (a = 0; a < result.items.length; ++a) {
            if (!result.items[a].rectangle.contains(px, py)) continue;
            item = result.items[a];
            b = a;
        }
        if (item == null || px + dw < item.rectangle.x && py + dh < item.rectangle.y || py + dh < item.rectangle.y) {
            this._copiedString = "";
            return;
        }
        boolean terminated = false;
        while (!terminated) {
            res = res + item.originalstrippedword;
            StyledRectangle r = item.rectangle;
            g.fillRect(r.x + result.rectangle.x, r.y + result.rectangle.y, r.width, r.height);
            if ((i != basei || a != b) && item.rectangle.contains(px + dw, py + dh)) break;
            if (++b >= result.items.length) {
                b = 0;
                if ((result = (DrawResult)this._results.get(new Integer(++i))) == null) break;
                px = pressedX - result.rectangle.x;
                py = pressedY - result.rectangle.y;
                res = res + "\n";
            }
            item = result.items[b];
            if (item.rectangle.y > py + dh) {
                terminated = true;
            }
            if (this._hdirection == 0 && item.rectangle.x > px + dw && item.rectangle.y + item.rectangle.height > py + dh) {
                terminated = true;
            }
            if (this._hdirection != 1 || item.rectangle.x + item.rectangle.width >= px + dw || item.rectangle.y + item.rectangle.height <= py + dh) continue;
            terminated = true;
        }
        this._copiedString = res;
        g.setPaintMode();
    }

    public synchronized void mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 1) != 0) {
            String res = "";
            for (int i = 0; i < this._list.size(); ++i) {
                DecodedLine str = (DecodedLine)this._list.get(i);
                if (str == null) {
                    str = this._emptyLine;
                }
                res = res + str.original + "\n";
            }
            this._listeners.sendEventAsync("copyEvent", this, res, e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        this._currentFloatItem = null;
        this._currentItem = null;
        this._currentHighLightItem = null;
        this.defCursor();
        this.mouseMoved(e);
    }

    public void mouseExited(MouseEvent e) {
        this._currentFloatItem = null;
        this._currentItem = null;
        this._currentHighLightItem = null;
        this.repaint();
    }

    public synchronized void mousePressed(MouseEvent e) {
        String type;
        this._pressedX = e.getX();
        this._pressedY = e.getY();
        this._draggedX = this._pressedX;
        this._draggedY = this._pressedY;
        this._copiedString = "";
        this._dragging = false;
        this._currentItem = null;
        DrawResultItem item = this.findItem(e.getX(), e.getY());
        if (item != null && (type = this._catcher.getType(item.item)) != null) {
            if (type.equals("channel")) {
                this._listeners.sendEventAsync("channelEvent", this, item.item, e);
            } else if (type.equals("url")) {
                this._listeners.sendEventAsync("URLEvent", this, item.item, e);
            } else if (type.equals("wordlist")) {
                this._listeners.sendEventAsync("nickEvent", this, item.item, e);
            }
        }
    }

    public synchronized void mouseReleased(MouseEvent e) {
        if (this._dragging) {
            this._dragging = false;
            this.repaint();
            if (this._copiedString.length() > 0) {
                this._listeners.sendEventAsync("copyEvent", this, this._copiedString, e);
            }
        }
    }

    public synchronized void mouseDragged(MouseEvent e) {
        this._draggedX = e.getX();
        this._draggedY = e.getY();
        this._dragging = true;
        DrawResultItem item = this.findItem(e.getX(), e.getY());
        if (item != this._currentItem) {
            this._currentItem = item;
            this.repaint();
        }
    }

    private void handCursor() {
        if (!this.getCursor().equals(new Cursor(12))) {
            this.setCursor(new Cursor(12));
        }
    }

    private void defCursor() {
        if (!this.getCursor().equals(new Cursor(0))) {
            this.setCursor(new Cursor(0));
        }
    }

    private boolean sameItem(DrawResultItem a, DrawResultItem b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public synchronized void mouseMoved(MouseEvent e) {
        DrawResultItem item = this.findItem(e.getX(), e.getY());
        DrawResultItem oldFloat = this._currentFloatItem;
        DrawResultItem oldHigh = this._currentHighLightItem;
        if (!this.sameItem(item, this._currentItem)) {
            this._currentItem = item;
            this._currentFloatItem = null;
            this._currentHighLightItem = null;
            if (item != null) {
                String type = this._catcher.getType(item.item);
                if (type != null) {
                    this.handCursor();
                    if (type.equals("wordlist")) {
                        String info = (String)this._nickInfos.get(item.item.toLowerCase(Locale.ENGLISH));
                        if (info == null) {
                            info = "";
                        }
                        if (info.length() == 0) {
                            this._currentFloatItem = null;
                        } else {
                            this._currentFloatItem = item;
                            this._currentFloatText = info;
                        }
                    }
                    if (this._currentFloatItem == null) {
                        this._currentHighLightItem = item;
                    }
                } else {
                    this.defCursor();
                }
            } else {
                this.defCursor();
            }
        }
        boolean repaint = false;
        if (!this.sameItem(oldFloat, this._currentFloatItem) && this._ircConfiguration.getB("style:floatingasl")) {
            repaint = true;
        }
        if (!this.sameItem(oldHigh, this._currentHighLightItem)) {
            repaint = true;
        }
        if (repaint) {
            this.repaint();
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this._fullDraw = true;
        this.repaint();
        return true;
    }

    public synchronized Boolean displayUpdated(Object handle, Integer what) {
        boolean foundSome = false;
        Enumeration e = this._results.keys();
        while (e.hasMoreElements()) {
            Integer line = (Integer)e.nextElement();
            DrawResult result = (DrawResult)this._results.get(line);
            if (result.updateHandles == null) continue;
            for (int i = 0; i < result.updateHandles.size(); ++i) {
                if (!result.updateHandles.elementAt(i).equals(handle)) continue;
                if ((what & 2) != 0) {
                    this._fullDraw = true;
                    this.repaint();
                    return Boolean.TRUE;
                }
                foundSome = true;
                this.addToUpdateItems(line);
                if (System.currentTimeMillis() - this._lastRefresh <= 10L && (what & 1) == 0) continue;
                this.repaint();
                this._lastRefresh = System.currentTimeMillis();
            }
        }
        if (foundSome) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

