/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

public class StyledRectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public StyledRectangle(int ax, int ay, int w, int h) {
        this.x = ax;
        this.y = ay;
        this.width = w;
        this.height = h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StyledRectangle)) {
            return false;
        }
        StyledRectangle r = (StyledRectangle)o;
        return r.x == this.x && r.y == this.y && r.width == this.width && r.height == this.height;
    }

    public int hashCode() {
        return this.x + this.y + this.width + this.height;
    }

    public boolean contains(int px, int py) {
        return px >= this.x && py >= this.y && px < this.x + this.width && py < this.y + this.height;
    }

    private boolean noEmpty(int v1, int lv1, int v2, int lv2) {
        if (v1 < v2) {
            return v1 + lv1 > v2;
        }
        return v2 + lv2 > v1;
    }

    public boolean hit(StyledRectangle r) {
        if (!this.noEmpty(r.x, r.width, this.x, this.width)) {
            return false;
        }
        return this.noEmpty(r.y, r.height, this.y, this.height);
    }

    public void add(StyledRectangle r) {
        if (r.x < this.x) {
            this.width += this.x - r.x;
            this.x = r.x;
        }
        if (r.y < this.y) {
            this.height += this.y - r.y;
            this.y = r.y;
        }
        if (r.width > this.width) {
            this.width = r.width;
        }
        if (r.height > this.height) {
            this.height = r.height;
        }
    }

    public String toString() {
        return "StyledRectangle : " + this.x + "," + this.y + "," + this.width + "," + this.height;
    }
}

