/*
 * Decompiled with CFR 0.152.
 */
package irc.tree;

import irc.tree.Comparator;
import irc.tree.TreeNode;
import irc.tree.TreeTraversalListener;
import java.util.Enumeration;
import java.util.Vector;

public class SortedList
implements TreeTraversalListener {
    private TreeNode _root;
    private Vector _items;
    private Comparator _comparator;
    private boolean _upToDate;

    public SortedList(Comparator comparator) {
        this._comparator = comparator;
        this._root = new TreeNode(this._comparator);
        this._items = new Vector();
        this._upToDate = false;
    }

    public int getSize() {
        if (!this._upToDate) {
            this.computeVector();
        }
        return this._items.size();
    }

    public void add(Object item) {
        try {
            this._root = this._root.add(item);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._upToDate = false;
    }

    public void remove(Object item) {
        try {
            this._root = this._root.remove(item);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._upToDate = false;
    }

    public void begin(Object param) {
        this._items = new Vector();
    }

    public void nextItem(Object item, Object param) {
        this._items.insertElementAt(item, this._items.size());
    }

    public void end(Object param) {
        this._upToDate = true;
    }

    private void computeVector() {
        this.getItems(this, null);
    }

    public Enumeration getItems() {
        if (!this._upToDate) {
            this.computeVector();
        }
        return this._items.elements();
    }

    public Object getItemAt(int i) {
        if (!this._upToDate) {
            this.computeVector();
        }
        return this._items.elementAt(i);
    }

    public void getItems(TreeTraversalListener lis, Object param) {
        lis.begin(param);
        this._root.inorder(lis, param);
        lis.end(param);
    }

    public void clear() {
        this._root = new TreeNode(this._comparator);
        this._items = new Vector();
        this._upToDate = false;
    }
}

