/*
 * Decompiled with CFR 0.152.
 */
package irc.tree;

import irc.tree.Comparator;
import irc.tree.TreeTraversalListener;
import java.util.Vector;

class TreeNode {
    public TreeNode left;
    public TreeNode right;
    public Vector objects;
    private Comparator _comparator;

    public TreeNode(Object itm, Comparator comparator) {
        this._comparator = comparator;
        this.objects = new Vector(1, 0);
        this.objects.insertElementAt(itm, this.objects.size());
        this.left = new TreeNode(comparator);
        this.right = new TreeNode(comparator);
    }

    public TreeNode(Comparator comparator) {
        this._comparator = comparator;
        this.objects = new Vector(1, 0);
        this.left = null;
        this.right = null;
    }

    public boolean external() {
        return this.left == null || this.right == null;
    }

    public TreeNode remove(Object itm) throws Exception {
        if (this.external()) {
            throw new Exception();
        }
        int compare = this._comparator.compare(itm, this.objects.elementAt(0));
        if (compare == 0) {
            this.objects.removeElement(itm);
            if (this.objects.size() == 0) {
                if (this.left.external()) {
                    return this.right;
                }
                if (this.right.external()) {
                    return this.left;
                }
                return this.right.addTree(this.left);
            }
            return this;
        }
        if (compare < 0) {
            this.left = this.left.remove(itm);
            return this;
        }
        this.right = this.right.remove(itm);
        return this;
    }

    private TreeNode addTree(TreeNode tree) throws Exception {
        if (this.external()) {
            return tree;
        }
        if (tree.external()) {
            return this;
        }
        int compare = this._comparator.compare(tree.objects.elementAt(0), this.objects.elementAt(0));
        if (compare == 0) {
            throw new Exception();
        }
        if (compare < 0) {
            this.left = this.left.addTree(tree);
            return this;
        }
        this.right = this.right.addTree(tree);
        return this;
    }

    public TreeNode add(Object itm) throws Exception {
        if (this.external()) {
            return new TreeNode(itm, this._comparator);
        }
        int compare = this._comparator.compare(itm, this.objects.elementAt(0));
        if (compare == 0) {
            this.objects.insertElementAt(itm, this.objects.size());
            return this;
        }
        if (compare < 0) {
            this.left = this.left.add(itm);
            return this;
        }
        this.right = this.right.add(itm);
        return this;
    }

    public void inorder(TreeTraversalListener lis, Object param) {
        if (this.external()) {
            return;
        }
        this.left.inorder(lis, param);
        for (int i = 0; i < this.objects.size(); ++i) {
            lis.nextItem(this.objects.elementAt(i), param);
        }
        this.right.inorder(lis, param);
    }
}

