/*****************************************************************************
 * interface.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

#ifndef _INTERFACE_H_
#define _INTERFACE_H_

GtkWidget *bd_tree;

GtkWidget *bimdiag_window;
GtkWidget *bimdiag_radio1;
GtkWidget *bimdiag_radio2;
GtkWidget *bimdiag_radio3;
GtkWidget *bimdiag_entry1;
GtkWidget *bimdiag_entry2;
GtkWidget *bimdiag_check1;
GtkWidget *bimdiag_check2;
GtkWidget *bimdiag_check3;
GtkWidget *bimdiag_check4;
GtkWidget *bimdiag_size_radio1;
GtkWidget *bimdiag_size_radio2;
GtkWidget *bimdiag_size_radio3;
GtkWidget *bimdiag_image1;
GtkWidget *bimdiag_image2;
GtkWidget *create_bimage_select_window(GtkWidget *parent);

GtkWidget *create_window1 (void);
GtkWidget *create_user_menu (GtkWidget *parent);
GtkWidget *create_login_window (void);
GtkWidget *create_profile_window(GtkWidget *parent);
GtkWidget *create_alias_menu(GtkWidget *parent);
GtkWidget *create_alias_window(GtkWidget *parent);
GtkWidget *create_find_window(void);
/* added: PhrozenSmoke - from interface.c, fader support */
GtkWidget *fader_text_start;
GtkWidget *fader_text_end;
GtkWidget *login_credentials;

GtkWidget *chatroom_user_pane;
GtkWidget *emotes_pane;
GtkWidget *chatroom_input_pane;
GtkWidget *add_to_favorites_menuitem;
GtkWidget *conf_invite1;
GtkWidget *conf_invite2;
GtkWidget *conf_invite3;
GtkWidget *conf_invite4;
GtkWidget *conf_leave1;
GtkWidget *conf_leave2;

GtkWidget *conf_invite6;  /* trayicon.c */
GtkWidget *conf_invite7;  /* trayicon.c */

GtkWidget *create_buddy_list_tab();
GtkWidget *create_budlist_popup_menu(GtkWidget *parent);
GtkWidget *create_budgrp_popup_menu(GtkWidget *parent);

GtkWidget* create_stealth_window(GtkWidget *parent, char *who);
GtkWidget *get_pixmapped_button(char *button_label, const gchar *stock_id);

/* added PhrozenSmoke: common dialogs */
void show_ok_dialog(char *mymsg);
GtkWidget *show_ok_dialog_p(GtkWidget *parent, char *mymsg);
gboolean on_close_bimage_select_window(GtkWidget *widget, gpointer user_data);

GtkWidget *show_confirm_dialog(char *mymsg, char *okbuttonlabel, char *cancelbuttonlabel);
GtkWidget *show_confirm_dialog_config_p(GtkWidget *parent, char *mymsg, char *okbuttonlabel, char *cancelbuttonlabel, int with_callback);
GtkWidget *show_input_dialog(GtkWidget *parent, char *mymsg, char *okbuttonlabel, char *cancelbuttonlabel);
extern void show_popup_dialog(char *mytitle, char *mymsg, int myicon);
extern GtkWidget *create_list_dialog(GtkWidget *parent, char *wintitle, char *header, char *ldefault, GList *comblist, int editable, int icon);
GtkWidget *create_fileselection2(GtkWidget *parent);

void show_credentials_box(GtkWidget *window, GdkPixbuf *imbuf);
GtkWidget *create_yprivacy_window(GtkWidget *parent);


GtkWidget *get_smiley_button(char *filename, int allow_fail);
void show_smiley_window_chat(GtkWidget *button, gpointer user_data);
void show_smiley_window_pm(GtkWidget *button, gpointer user_data);

extern GtkWidget *chat_window;
extern GtkWidget *load_smiley_icon(char *str);

extern int show_quick_access_toolbar;
extern char *fader_text_end_str;
extern char *fader_text_start_str;
extern int num_dialogs_too_fast;
extern char *_(char *some);  /* added PhrozenSmoke: locale support */
extern GHashTable *buddy_status;
extern int find_online_friend( char *friend );
extern int dialogs_opening_too_fast();
extern void reset_buddy_groups();

void set_preselected_filename(char *who);
char *get_preselected_filename();
void update_buddy_clist();

GtkWidget *get_stocki_button(const gchar *stock_id, char *tip, GtkIconSize size);
gboolean on_close_ok_dialog(GtkWidget *widget, gpointer user_data);
gboolean on_close_ok_dialogw(GtkWidget *widget, GdkEvent *event, gpointer user_data);

#endif

